/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.controller;

import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IMemoryBlock;
import de.mossgrabers.framework.graphics.IBitmap;
import de.mossgrabers.framework.usb.IUsbDevice;
import de.mossgrabers.framework.usb.IUsbEndpoint;
import de.mossgrabers.framework.usb.UsbException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PushUsbDisplay {
    private static final int DATA_SZ = 327680;
    private static final int TIMEOUT = 1000;
    private static final byte[] DISPLAY_HEADER = new byte[]{-1, -52, -86, -120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private IUsbDevice usbDevice;
    private IUsbEndpoint usbEndpoint;
    private final IHost host;
    private final IMemoryBlock headerBlock;
    private final IMemoryBlock imageBlock;
    private final byte[] byteStore = new byte[327680];
    private final Object sendLock = new Object();
    private final Object bufferUpdateLock = new Object();
    private final ScheduledExecutorService sendExecutor = Executors.newSingleThreadScheduledExecutor();

    public PushUsbDisplay(IHost host) {
        this.host = host;
        try {
            this.usbDevice = host.getUsbDevice(0);
            this.usbEndpoint = this.usbDevice.getEndpoint(0, 0);
        }
        catch (UsbException ex) {
            this.usbDevice = null;
            this.usbEndpoint = null;
            host.error("Could not open USB output.");
        }
        this.headerBlock = host.createMemoryBlock(DISPLAY_HEADER.length);
        this.headerBlock.createByteBuffer().put(DISPLAY_HEADER);
        this.imageBlock = host.createMemoryBlock(327680);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(IBitmap image) {
        Object object = this.bufferUpdateLock;
        synchronized (object) {
            image.encode((imageBuffer, width, height) -> {
                int counter = 0;
                int padding = (327680 - height * width * 2) / height;
                for (int y = 0; y < height; ++y) {
                    int x;
                    for (x = 0; x < width; ++x) {
                        byte blue = imageBuffer.get();
                        byte green = imageBuffer.get();
                        byte red = imageBuffer.get();
                        imageBuffer.get();
                        int pixel = PushUsbDisplay.sPixelFromRGB(red, green, blue);
                        this.byteStore[counter] = (byte)(pixel & 0xFF);
                        this.byteStore[counter + 1] = (byte)((pixel & 0xFF00) >> 8);
                        counter += 2;
                    }
                    for (x = 0; x < padding; ++x) {
                        this.byteStore[counter] = 0;
                        ++counter;
                    }
                }
                this.signalShaping();
                imageBuffer.rewind();
            });
        }
        object = this.sendLock;
        synchronized (object) {
            if (!this.sendExecutor.isShutdown()) {
                this.sendExecutor.submit(this::sendData);
            }
        }
    }

    private void signalShaping() {
        for (int pos = 0; pos < this.byteStore.length; pos += 4) {
            int n = pos;
            this.byteStore[n] = (byte)(this.byteStore[n] ^ 0xE7);
            int n2 = pos + 1;
            this.byteStore[n2] = (byte)(this.byteStore[n2] ^ 0xF3);
            int n3 = pos + 2;
            this.byteStore[n3] = (byte)(this.byteStore[n3] ^ 0xE7);
            int n4 = pos + 3;
            this.byteStore[n4] = (byte)(this.byteStore[n4] ^ 0xFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendData() {
        Object object = this.bufferUpdateLock;
        synchronized (object) {
            ByteBuffer buffer = this.imageBlock.createByteBuffer();
            buffer.clear();
            for (int i = 0; i < 327680; ++i) {
                buffer.put(this.byteStore[i]);
            }
        }
        object = this.sendLock;
        synchronized (object) {
            if (this.usbDevice == null || this.usbEndpoint == null) {
                return;
            }
            this.usbEndpoint.send(this.headerBlock, 1000);
            this.usbEndpoint.send(this.imageBlock, 1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.sendLock;
        synchronized (object) {
            this.usbDevice = null;
            this.usbEndpoint = null;
            this.sendExecutor.shutdown();
            try {
                if (!this.sendExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.host.error("USB Send executor did not end in 5 seconds.");
                }
            }
            catch (InterruptedException ex) {
                this.host.error("USB Send executor interrupted.", ex);
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isShutdown() {
        return this.sendExecutor.isShutdown();
    }

    private static int sPixelFromRGB(int red, int green, int blue) {
        int pixel = (blue & 0xF8) >> 3;
        pixel <<= 6;
        pixel += (green & 0xFC) >> 2;
        pixel <<= 5;
        return pixel += (red & 0xF8) >> 3;
    }
}

