/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.trigger;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.trigger.clip.QuantizeCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class PushQuantizeCommand
extends QuantizeCommand<PushControlSurface, PushConfiguration> {
    public PushQuantizeCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        if (event == ButtonEvent.LONG || event == ButtonEvent.DOWN && ((PushControlSurface)this.surface).isShiftPressed()) {
            modeManager.setTemporary(Modes.REC_ARM);
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.QUANTIZE);
            return;
        }
        if (event != ButtonEvent.UP) {
            return;
        }
        if (Modes.REC_ARM.equals(modeManager.getActiveID())) {
            modeManager.restore();
        } else {
            this.quantize();
        }
    }
}

