/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.trigger;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class MuteCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public MuteCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        ((IView)((PushControlSurface)this.surface).getViewManager().getActive()).updateNoteMapping();
        if (((PushControlSurface)this.surface).isSelectPressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
            if (event == ButtonEvent.UP) {
                this.model.getProject().clearMute();
            }
            return;
        }
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        if (!config.isPushModern()) {
            if (event == ButtonEvent.DOWN) {
                config.setLockState(PushConfiguration.LockState.MUTE);
            }
            return;
        }
        if (event != ButtonEvent.UP) {
            return;
        }
        if (((PushControlSurface)this.surface).isShiftPressed() || ((PushControlSurface)this.surface).isPressed(ButtonID.LOCK_MODE)) {
            config.setLockState(config.getLockState() == PushConfiguration.LockState.MUTE ? PushConfiguration.LockState.OFF : PushConfiguration.LockState.MUTE);
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        if (modeManager.isActive(new Modes[]{Modes.MASTER})) {
            this.model.getMasterTrack().toggleMute();
            return;
        }
        if (config.getLockState() == PushConfiguration.LockState.MUTE) {
            return;
        }
        if (Modes.isLayerMode((Modes)((Object)modeManager.getActiveID()))) {
            ICursorDevice cd = this.model.getCursorDevice();
            Optional layer = cd.getLayerBank().getSelectedItem();
            if (layer.isPresent()) {
                ((ILayer)layer.get()).toggleMute();
            }
        } else {
            this.model.getCursorTrack().toggleMute();
        }
    }
}

