/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.pitchbend;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.core.AbstractPitchbendCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.midi.INoteRepeat;
import de.mossgrabers.framework.parameter.IFocusedParameter;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.view.Views;
import java.util.Optional;

public class TouchstripCommand
extends AbstractPitchbendCommand<PushControlSurface, PushConfiguration> {
    private int pitchValue = 0;

    public TouchstripCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void onPitchbend(int data1, int data2) {
        if (((PushControlSurface)this.surface).getViewManager().isActive(new Views[]{Views.SESSION})) {
            int value = ((PushControlSurface)this.surface).isShiftPressed() ? 63 : data2;
            this.model.getTransport().setCrossfade(this.model.getValueChanger().toDAWValue(value));
            ((PushControlSurface)this.surface).setRibbonValue(value);
            return;
        }
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            return;
        }
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        double scaled = (double)data2 / 127.0;
        int ribbonNoteRepeat = config.getRibbonNoteRepeat();
        if (config.isNoteRepeatActive() && ribbonNoteRepeat > 0) {
            Resolution[] values = Resolution.values();
            int index = (int)Math.round(scaled * (double)(values.length - 1));
            double value = values[values.length - 1 - index].getValue();
            INoteRepeat noteRepeat = ((PushControlSurface)this.surface).getMidiInput().getDefaultNoteInput().getNoteRepeat();
            if (ribbonNoteRepeat == 1) {
                noteRepeat.setPeriod(value);
            } else {
                noteRepeat.setNoteLength(value);
            }
            return;
        }
        this.handleRibbonMode(data1, data2, config);
    }

    protected void handleRibbonMode(int data1, int data2, PushConfiguration config) {
        boolean isReset = ((PushControlSurface)this.surface).isDeletePressed();
        if (isReset) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
        }
        switch (config.getRibbonMode()) {
            case 0: {
                ((PushControlSurface)this.surface).sendMidiEvent(224, data1, data2);
                break;
            }
            case 1: {
                ((PushControlSurface)this.surface).sendMidiEvent(176, config.getRibbonModeCCVal(), data2);
                this.pitchValue = data2;
                break;
            }
            case 2: {
                if (data2 > 64) {
                    ((PushControlSurface)this.surface).sendMidiEvent(224, data1, data2);
                    break;
                }
                if (data2 < 64) {
                    ((PushControlSurface)this.surface).sendMidiEvent(176, config.getRibbonModeCCVal(), 127 - data2 * 2);
                    break;
                }
                ((PushControlSurface)this.surface).sendMidiEvent(224, data1, data2);
                ((PushControlSurface)this.surface).sendMidiEvent(176, config.getRibbonModeCCVal(), 0);
                break;
            }
            case 3: {
                if (data2 > 64) {
                    ((PushControlSurface)this.surface).sendMidiEvent(176, config.getRibbonModeCCVal(), (data2 - 64) * 2);
                    break;
                }
                if (data2 < 64) {
                    ((PushControlSurface)this.surface).sendMidiEvent(224, data1, data2);
                    break;
                }
                ((PushControlSurface)this.surface).sendMidiEvent(224, data1, data2);
                ((PushControlSurface)this.surface).sendMidiEvent(176, config.getRibbonModeCCVal(), 0);
                break;
            }
            case 4: {
                IParameter volumeParameter = this.model.getCursorTrack().getVolumeParameter();
                if (isReset) {
                    volumeParameter.resetValue();
                } else {
                    volumeParameter.setValue(this.model.getValueChanger().toDAWValue(data2));
                }
                return;
            }
            case 5: {
                Optional<IFocusedParameter> parameterOpt = this.model.getFocusedParameter();
                if (parameterOpt.isPresent() && parameterOpt.get().doesExist()) {
                    if (isReset) {
                        parameterOpt.get().resetValue();
                    } else {
                        parameterOpt.get().setValue(this.model.getValueChanger().toDAWValue(data2));
                    }
                } else {
                    ((PushControlSurface)this.surface).getMidiOutput().sendPitchbend(0, 0);
                }
                return;
            }
        }
        ((PushControlSurface)this.surface).getMidiOutput().sendPitchbend(data1, data2);
    }

    @Override
    public void updateValue() {
        IValueChanger valueChanger = this.model.getValueChanger();
        if (((PushControlSurface)this.surface).getViewManager().isActive(new Views[]{Views.SESSION})) {
            ((PushControlSurface)this.surface).setRibbonValue(valueChanger.toMidiValue(this.model.getTransport().getCrossfade()));
            return;
        }
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        int ribbonNoteRepeat = config.getRibbonNoteRepeat();
        if (config.isNoteRepeatActive() && ribbonNoteRepeat > 0) {
            Resolution[] values = Resolution.values();
            INoteRepeat noteRepeat = ((PushControlSurface)this.surface).getMidiInput().getDefaultNoteInput().getNoteRepeat();
            double value = ribbonNoteRepeat == 1 ? noteRepeat.getPeriod() : noteRepeat.getNoteLength();
            int index = Resolution.getMatch(value);
            ((PushControlSurface)this.surface).setRibbonValue(127 - (int)Math.round((double)index * 127.0 / (double)(values.length - 1)));
            return;
        }
        switch (config.getRibbonMode()) {
            case 1: {
                ((PushControlSurface)this.surface).setRibbonValue(this.pitchValue);
                break;
            }
            case 4: {
                ICursorTrack t = this.model.getCursorTrack();
                ((PushControlSurface)this.surface).setRibbonValue(valueChanger.toMidiValue(t.getVolume()));
                break;
            }
            case 5: {
                Optional<IFocusedParameter> parameterOpt = this.model.getFocusedParameter();
                int v = parameterOpt.isPresent() && parameterOpt.get().doesExist() ? valueChanger.toMidiValue(parameterOpt.get().getValue()) : 0;
                ((PushControlSurface)this.surface).setRibbonValue(v);
                break;
            }
            default: {
                ((PushControlSurface)this.surface).setRibbonValue(64);
            }
        }
    }
}

