/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push;

import de.mossgrabers.controller.ableton.push.PushVersion;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IColorSetting;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.IIntegerSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.graphics.IGraphicsConfiguration;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.view.Views;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class PushConfiguration
extends AbstractConfiguration
implements IGraphicsConfiguration {
    public static final Integer RIBBON_MODE = 50;
    public static final Integer RIBBON_MODE_CC_VAL = 51;
    public static final Integer RIBBON_MODE_NOTE_REPEAT = 52;
    public static final Integer VELOCITY_CURVE = 53;
    public static final Integer PAD_THRESHOLD = 54;
    public static final Integer DISPLAY_BRIGHTNESS = 55;
    public static final Integer LED_BRIGHTNESS = 56;
    public static final Integer PAD_SENSITIVITY = 57;
    public static final Integer PAD_GAIN = 58;
    public static final Integer PAD_DYNAMICS = 59;
    public static final Integer STOP_AUTOMATION_ON_KNOB_RELEASE = 60;
    public static final Integer DEBUG_MODE = 61;
    public static final Integer DEBUG_WINDOW = 62;
    public static final Integer COLOR_BACKGROUND = 70;
    public static final Integer COLOR_BORDER = 71;
    public static final Integer COLOR_TEXT = 72;
    public static final Integer COLOR_FADER = 73;
    public static final Integer COLOR_VU = 74;
    public static final Integer COLOR_EDIT = 75;
    public static final Integer COLOR_RECORD = 76;
    public static final Integer COLOR_SOLO = 77;
    public static final Integer COLOR_MUTE = 78;
    public static final Integer COLOR_BACKGROUND_DARKER = 79;
    public static final Integer COLOR_BACKGROUND_LIGHTER = 80;
    public static final Integer SESSION_VIEW = 81;
    public static final Integer DISPLAY_SCENES_CLIPS = 82;
    public static final Integer PER_PAD_PITCHBEND = 83;
    public static final Integer IN_TUNE_LOCATION = 84;
    public static final Integer IN_TUNE_WIDTH = 85;
    public static final Integer IN_TUNE_SLIDE_HEIGHT = 86;
    public static final Integer PEDAL_1 = 87;
    public static final Integer PEDAL_2 = 88;
    public static final Integer PREAMP_TYPE_1 = 89;
    public static final Integer PREAMP_TYPE_2 = 90;
    public static final Integer PREAMP_GAIN_1 = 91;
    public static final Integer PREAMP_GAIN_2 = 92;
    public static final Integer AUDIO_OUTPUTS = 93;
    public static final int RIBBON_MODE_PITCH = 0;
    public static final int RIBBON_MODE_CC = 1;
    public static final int RIBBON_MODE_CC_PB = 2;
    public static final int RIBBON_MODE_PB_CC = 3;
    public static final int RIBBON_MODE_FADER = 4;
    public static final int RIBBON_MODE_LAST_TOUCHED = 5;
    public static final int NOTE_REPEAT_OFF = 0;
    public static final int NOTE_REPEAT_PERIOD = 1;
    public static final int NOTE_REPEAT_LENGTH = 2;
    private static final String CATEGORY_RIBBON = "Ribbon";
    private static final String CATEGORY_AUDIO = "Audio Interface";
    private static final String CATEGORY_COLORS = "Display Colors";
    private static final String[] RIBBON_MODE_VALUES = new String[]{"Pitch", "CC", "CC/Pitch", "Pitch/CC", "Fader", "Last Touched"};
    private static final String[] RIBBON_NOTE_REPEAT_VALUES = new String[]{"Off", "Period", "Length"};
    private static final String[] SESSION_VIEW_OPTIONS = new String[]{"Clips", "Flipped", "Scenes"};
    public static final int CURSOR_KEYS_TRACK_OPTION_MOVE_BANK_BY_PAGE = 0;
    public static final int CURSOR_KEYS_TRACK_OPTION_MOVE_BANK_BY_1 = 1;
    public static final int CURSOR_KEYS_TRACK_OPTION_SWAP = 2;
    private static final String[] CURSOR_KEYS_TRACK_OPTIONS = new String[]{"Scroll track bank by page", "Scroll track bank by 1", "Swap tracks"};
    public static final int CURSOR_KEYS_SCENE_OPTION_MOVE_BANK_BY_PAGE = 0;
    public static final int CURSOR_KEYS_SCENE_OPTION_MOVE_BANK_BY_1 = 1;
    private static final String[] CURSOR_KEYS_SCENE_OPTIONS = new String[]{"Scroll scene bank by page", "Scroll scene bank by 1"};
    private static final Views[] PREFERRED_NOTE_VIEWS = new Views[]{Views.PLAY, Views.CHORDS, Views.PIANO, Views.DRUM64, Views.DRUM, Views.DRUM4, Views.DRUM8, Views.DRUM_XOX, Views.SEQUENCER, Views.RAINDROPS, Views.POLY_SEQUENCER};
    private static final Set<Modes> DEBUG_MODES = EnumSet.noneOf(Modes.class);
    public static final String[] IN_TUNE_LOCATION_OPTIONS;
    public static final String[] IN_TUNE_WIDTH_OPTIONS;
    public static final String[] SLIDE_HEIGHT_OPTIONS;
    public static final String[] FOOT_CV_OPTIONS;
    public static final String[] PREAMP_TYPE_OPTIONS;
    public static final String[] PREAMP_GAIN_OPTIONS;
    public static final String[] OUTPUT_CONFIGURATION;
    public static final String[] OUTPUT_CONFIGURATION_SHORT;
    private LockState lockState = LockState.OFF;
    private int cursorKeysTrackOption = 0;
    private int cursorKeysTrackShiftedOption = 2;
    private int cursorKeysSceneOption = 1;
    private int cursorKeysSceneShiftedOption = 0;
    private boolean isScenesClipView;
    private int ribbonMode = 0;
    private int ribbonModeCCVal = 1;
    private int ribbonModeNoteRepeat = 1;
    private boolean stopAutomationOnKnobRelease = false;
    private Modes debugMode = Modes.TRACK;
    private Modes layerMode = null;
    private int velocityCurve = 1;
    private int padThreshold = 20;
    private int displayBrightness = 255;
    private int ledBrightness = 127;
    private int padSensitivity = 5;
    private int padGain = 5;
    private int padDynamics = 5;
    private ColorEx colorBackground = DEFAULT_COLOR_BACKGROUND;
    private ColorEx colorBorder = DEFAULT_COLOR_BORDER;
    private ColorEx colorText = DEFAULT_COLOR_TEXT;
    private ColorEx colorFader = DEFAULT_COLOR_FADER;
    private ColorEx colorVU = DEFAULT_COLOR_VU;
    private ColorEx colorEdit = DEFAULT_COLOR_EDIT;
    private ColorEx colorRecord = DEFAULT_COLOR_RECORD;
    private ColorEx colorSolo = DEFAULT_COLOR_SOLO;
    private ColorEx colorMute = DEFAULT_COLOR_MUTE;
    private ColorEx colorBackgroundDarker = DEFAULT_COLOR_BACKGROUND_DARKER;
    private ColorEx colorBackgroundLighter = DEFAULT_COLOR_BACKGROUND_LIGHTER;
    private boolean perPadPitchbend = true;
    private int inTuneLocation;
    private int inTuneWidth;
    private int slideHeight;
    private int pedal1;
    private int pedal2;
    private int preamp1Type;
    private int preamp2Type;
    private int preamp1Gain;
    private int preamp2Gain;
    private int audioOutputs;
    private final PushVersion pushVersion;
    private IIntegerSetting displayBrightnessSetting;
    private IIntegerSetting ledBrightnessSetting;
    private IEnumSetting ribbonModeSetting;
    private IIntegerSetting ribbonModeCCSetting;
    private IEnumSetting ribbonModeNoteRepeatSetting;
    private IIntegerSetting padSensitivitySetting;
    private IIntegerSetting padGainSetting;
    private IIntegerSetting padDynamicsSetting;
    private IEnumSetting velocityCurveSetting;
    private IEnumSetting padThresholdSetting;
    private IEnumSetting debugModeSetting;
    private IColorSetting colorBackgroundSetting;
    private IColorSetting colorBackgroundDarkerSetting;
    private IColorSetting colorBackgroundLighterSetting;
    private IColorSetting colorBorderSetting;
    private IColorSetting colorTextSetting;
    private IColorSetting colorFaderSetting;
    private IColorSetting colorVUSetting;
    private IColorSetting colorEditSetting;
    private IColorSetting colorRecordSetting;
    private IColorSetting colorSoloSetting;
    private IColorSetting colorMuteSetting;
    private IEnumSetting sessionViewSetting;
    private IEnumSetting perPadPitchbendSetting;
    private IEnumSetting inTuneLocationSetting;
    private IEnumSetting inTuneWidthSetting;
    private IEnumSetting slideHeightSetting;
    private IEnumSetting pedal1Setting;
    private IEnumSetting pedal2Setting;
    private IEnumSetting preamp1Setting;
    private IEnumSetting preamp2Setting;
    private IEnumSetting preamp1GainSetting;
    private IEnumSetting preamp2GainSetting;
    private IEnumSetting audioOutputSetting;

    public PushConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes, PushVersion pushVersion) {
        super(host, valueChanger, arpeggiatorModes);
        this.pushVersion = pushVersion;
        this.preferredAudioView = Views.CLIP_LENGTH;
        this.dontNotifyAll.add(DEBUG_WINDOW);
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.activateScaleSetting(documentSettings);
        this.activateScaleBaseSetting(documentSettings);
        this.activateScaleInScaleSetting(documentSettings);
        this.activateScaleLayoutSetting(documentSettings);
        this.activateNoteRepeatSetting(documentSettings);
        this.activateSessionView(globalSettings);
        this.activateSelectClipOnLaunchSetting(globalSettings);
        this.activateDrawRecordStripeSetting(globalSettings);
        this.activateActionForRecArmedPad(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateFlipRecordSetting(globalSettings);
        this.activateAccentActiveSetting(globalSettings);
        this.activateAccentValueSetting(globalSettings);
        this.activateQuantizeAmountSetting(globalSettings);
        this.activateStartupViewSetting(globalSettings, PREFERRED_NOTE_VIEWS);
        this.activateStartWithSessionViewSetting(globalSettings);
        this.activateMidiEditChannelSetting(documentSettings);
        this.activateTurnOffScalePadsSetting(globalSettings);
        this.activateShowPlayedChordsSetting(globalSettings);
        if (this.host.supports(Capability.HAS_DRUM_DEVICE)) {
            this.activateAutoSelectDrumSetting(globalSettings);
            this.activateTurnOffEmptyDrumPadsSetting(globalSettings);
        }
        this.activateTrackNavigationSetting(globalSettings, "Workflow", false);
        this.activateCursorKeysSettings(globalSettings);
        this.activateIncludeMasterSetting(globalSettings);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateEnableVUMetersSetting(globalSettings);
        this.activateFootswitchSetting(globalSettings, 0, "Footswitch 2");
        this.activateStopAutomationOnKnobReleaseSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
        this.activateKnobSpeedSetting(globalSettings);
        this.activateDeviceFavorites(globalSettings, 7, 7, 7, 7);
        this.activateRibbonSettings(globalSettings);
        if (this.pushVersion == PushVersion.VERSION_1) {
            this.activatePush1PadSettings(globalSettings);
        } else {
            this.activatePush2PadSettings(globalSettings);
        }
        if (this.pushVersion == PushVersion.VERSION_3) {
            this.activatePush3MPESettings(globalSettings);
            this.convertAftertouch = -3;
            this.activatePush3AudioSettings(globalSettings);
        } else {
            this.activateConvertAftertouchSetting(globalSettings);
        }
        this.activatePush2HardwareSettings(globalSettings);
        this.activatePush2DisplayColorsSettings(globalSettings);
        this.activateDebugSettings(globalSettings);
    }

    public int getCursorKeysTrackOption() {
        return this.cursorKeysTrackOption;
    }

    public int getCursorKeysTrackShiftedOption() {
        return this.cursorKeysTrackShiftedOption;
    }

    public int getCursorKeysSceneOption() {
        return this.cursorKeysSceneOption;
    }

    public int getCursorKeysSceneShiftedOption() {
        return this.cursorKeysSceneShiftedOption;
    }

    public void setRibbonMode(int mode) {
        this.ribbonModeSetting.set(RIBBON_MODE_VALUES[mode]);
    }

    public int getRibbonMode() {
        return this.ribbonMode;
    }

    public void setRibbonModeCC(int value) {
        this.ribbonModeCCSetting.set(value);
    }

    public int getRibbonModeCCVal() {
        return this.ribbonModeCCVal;
    }

    public void setRibbonNoteRepeat(int mode) {
        this.ribbonModeNoteRepeatSetting.set(RIBBON_NOTE_REPEAT_VALUES[mode]);
    }

    public int getRibbonNoteRepeat() {
        return this.ribbonModeNoteRepeat;
    }

    public void changePadThreshold(int control) {
        int size = PushControlSurface.PUSH_PAD_THRESHOLDS_NAME.size();
        int value = this.valueChanger.changeValue(control, this.padThreshold, -100.0, size);
        this.padThreshold = Math.max(0, Math.min(value, size - 1));
        this.padThresholdSetting.set(PushControlSurface.PUSH_PAD_THRESHOLDS_NAME.get(this.padThreshold));
    }

    public void changeVelocityCurve(int control) {
        int size = PushControlSurface.PUSH_PAD_CURVES_NAME.size();
        int value = this.valueChanger.changeValue(control, this.velocityCurve, -100.0, size);
        this.velocityCurve = Math.max(0, Math.min(value, size - 1));
        this.velocityCurveSetting.set(PushControlSurface.PUSH_PAD_CURVES_NAME.get(this.velocityCurve));
    }

    public void changeDisplayBrightness(int control) {
        this.displayBrightnessSetting.set(this.valueChanger.changeValue(control, this.displayBrightness, -100.0, 101));
    }

    public void changeLEDBrightness(int control) {
        this.ledBrightnessSetting.set(this.valueChanger.changeValue(control, this.ledBrightness, -100.0, 101));
    }

    public void changePadSensitivity(int control) {
        this.padSensitivitySetting.set(this.valueChanger.changeValue(control, this.padSensitivity, -100.0, 11));
    }

    public void changePadGain(int control) {
        this.padGainSetting.set(this.valueChanger.changeValue(control, this.padGain, -100.0, 11));
    }

    public void changePadDynamics(int control) {
        this.padDynamicsSetting.set(this.valueChanger.changeValue(control, this.padDynamics, -100.0, 11));
    }

    public PushVersion getPushVersion() {
        return this.pushVersion;
    }

    public boolean isPushModern() {
        return this.pushVersion != PushVersion.VERSION_1;
    }

    public int getVelocityCurve() {
        return this.velocityCurve;
    }

    public void setVelocityCurve(int velocityCurve) {
        this.velocityCurve = velocityCurve;
    }

    public int getPadThreshold() {
        return this.padThreshold;
    }

    public void setPadThreshold(int padThreshold) {
        this.padThreshold = padThreshold;
    }

    public int getDisplayBrightness() {
        return this.displayBrightness;
    }

    public void setDisplayBrightness(int displayBrightness) {
        this.displayBrightnessSetting.set(displayBrightness);
    }

    public int getLedBrightness() {
        return this.ledBrightness;
    }

    public void setLEDBrightness(int ledBrightness) {
        this.ledBrightnessSetting.set(ledBrightness);
    }

    public boolean isStopAutomationOnKnobRelease() {
        return this.stopAutomationOnKnobRelease;
    }

    public boolean isSoloState(boolean isSoloLongPressed) {
        return isSoloLongPressed || this.lockState == LockState.SOLO;
    }

    public boolean isMuteState(boolean isMuteLongPressed) {
        return isMuteLongPressed || this.lockState == LockState.MUTE;
    }

    public boolean isClipStopState(boolean isClipStopLongPressed) {
        return isClipStopLongPressed || this.lockState == LockState.CLIP_STOP;
    }

    public LockState getLockState() {
        return this.lockState;
    }

    public void setLockState(LockState lockState) {
        this.lockState = lockState;
    }

    public int getPadSensitivity() {
        return this.padSensitivity;
    }

    public void setPadSensitivity(int padSensitivity) {
        this.padSensitivitySetting.set(padSensitivity);
    }

    public int getPadGain() {
        return this.padGain;
    }

    public void setPadGain(int padGain) {
        this.padGainSetting.set(padGain);
    }

    public int getPadDynamics() {
        return this.padDynamics;
    }

    public void setPadDynamics(int padDynamics) {
        this.padDynamicsSetting.set(padDynamics);
    }

    public Modes getCurrentMixMode() {
        return Modes.isTrackMode(this.debugMode) ? this.debugMode : null;
    }

    public void setLayerMixMode(Modes layerMode) {
        this.layerMode = layerMode;
    }

    public Modes getCurrentLayerMixMode() {
        if (this.layerMode != null) {
            return this.layerMode;
        }
        Modes currentMixMode = this.getCurrentMixMode();
        if (!this.isPushModern() || currentMixMode == null) {
            this.layerMode = Modes.DEVICE_LAYER;
        } else {
            switch (currentMixMode) {
                case VOLUME: {
                    this.layerMode = Modes.DEVICE_LAYER_VOLUME;
                    break;
                }
                case PAN: {
                    this.layerMode = Modes.DEVICE_LAYER_PAN;
                    break;
                }
                case SEND1: {
                    this.layerMode = Modes.DEVICE_LAYER_SEND1;
                    break;
                }
                case SEND2: {
                    this.layerMode = Modes.DEVICE_LAYER_SEND2;
                    break;
                }
                case SEND3: {
                    this.layerMode = Modes.DEVICE_LAYER_SEND3;
                    break;
                }
                case SEND4: {
                    this.layerMode = Modes.DEVICE_LAYER_SEND4;
                    break;
                }
                case SEND5: {
                    this.layerMode = Modes.DEVICE_LAYER_SEND5;
                    break;
                }
                case SEND6: {
                    this.layerMode = Modes.DEVICE_LAYER_SEND6;
                    break;
                }
                case SEND7: {
                    this.layerMode = Modes.DEVICE_LAYER_SEND7;
                    break;
                }
                case SEND8: {
                    this.layerMode = Modes.DEVICE_LAYER_SEND8;
                    break;
                }
                default: {
                    this.layerMode = Modes.DEVICE_LAYER;
                }
            }
        }
        return this.layerMode;
    }

    @Override
    public ColorEx getColorBackground() {
        return this.colorBackground;
    }

    @Override
    public ColorEx getColorBackgroundDarker() {
        return this.colorBackgroundDarker;
    }

    @Override
    public ColorEx getColorBackgroundLighter() {
        return this.colorBackgroundLighter;
    }

    @Override
    public ColorEx getColorBorder() {
        return this.colorBorder;
    }

    @Override
    public ColorEx getColorText() {
        return this.colorText;
    }

    @Override
    public ColorEx getColorEdit() {
        return this.colorEdit;
    }

    @Override
    public ColorEx getColorFader() {
        return this.colorFader;
    }

    @Override
    public ColorEx getColorVu() {
        return this.colorVU;
    }

    @Override
    public ColorEx getColorRecord() {
        return this.colorRecord;
    }

    @Override
    public ColorEx getColorSolo() {
        return this.colorSolo;
    }

    @Override
    public ColorEx getColorMute() {
        return this.colorMute;
    }

    @Override
    public boolean isAntialiasEnabled() {
        return true;
    }

    public Modes getMixerMode() {
        return this.debugMode;
    }

    public void setMixerMode(Modes debugMode) {
        this.debugModeSetting.set(debugMode.toString());
    }

    public boolean isPerPadPitchbend() {
        return this.perPadPitchbend;
    }

    public void changePerPadPitchbendEnabled(int control) {
        if (this.perPadPitchbendSetting != null) {
            this.perPadPitchbendSetting.set(ON_OFF_OPTIONS[this.valueChanger.isIncrease(control) ? 1 : 0]);
        }
    }

    public void setPerPadPitchbendEnabled(boolean enable) {
        if (this.perPadPitchbendSetting != null) {
            this.perPadPitchbendSetting.set(ON_OFF_OPTIONS[enable ? 1 : 0]);
        }
    }

    public int getInTuneLocation() {
        return this.inTuneLocation;
    }

    public void changeInTuneLocation(int control) {
        int index = this.valueChanger.changeValue(control, this.inTuneLocation, -100.0, IN_TUNE_LOCATION_OPTIONS.length);
        this.inTuneLocationSetting.set(IN_TUNE_LOCATION_OPTIONS[index]);
    }

    public void setInTuneLocation(int value) {
        this.inTuneLocationSetting.set(IN_TUNE_LOCATION_OPTIONS[value == 0 ? 0 : 1]);
    }

    public int getInTuneWidth() {
        return this.inTuneWidth;
    }

    public void changeInTuneWidth(int control) {
        int index = this.valueChanger.changeValue(control, this.inTuneWidth, -100.0, IN_TUNE_WIDTH_OPTIONS.length);
        this.inTuneWidthSetting.set(IN_TUNE_WIDTH_OPTIONS[index]);
    }

    public void setInTuneWidth(int value) {
        this.inTuneWidthSetting.set(IN_TUNE_WIDTH_OPTIONS[Math.min(IN_TUNE_WIDTH_OPTIONS.length - 1, Math.max(0, value))]);
    }

    public int getInTuneSlideHeight() {
        return this.slideHeight;
    }

    public void changeSlideHeight(int control) {
        int index = this.valueChanger.changeValue(control, this.slideHeight, -100.0, SLIDE_HEIGHT_OPTIONS.length);
        this.slideHeightSetting.set(SLIDE_HEIGHT_OPTIONS[index]);
    }

    public void setSlideHeight(int value) {
        this.slideHeightSetting.set(SLIDE_HEIGHT_OPTIONS[Math.min(SLIDE_HEIGHT_OPTIONS.length - 1, Math.max(0, value))]);
    }

    public int getPedal1() {
        return this.pedal1;
    }

    public void setPedal1(int pedal) {
        this.pedal1Setting.set(FOOT_CV_OPTIONS[pedal]);
    }

    public void changePedal1(int control) {
        this.pedal1Setting.set(FOOT_CV_OPTIONS[this.valueChanger.isIncrease(control) ? 1 : 0]);
    }

    public int getPedal2() {
        return this.pedal2;
    }

    public void setPedal2(int pedal) {
        this.pedal1Setting.set(FOOT_CV_OPTIONS[pedal]);
    }

    public void changePedal2(int control) {
        this.pedal2Setting.set(FOOT_CV_OPTIONS[this.valueChanger.isIncrease(control) ? 1 : 0]);
    }

    public int getPreamp1Type() {
        return this.preamp1Type;
    }

    public void setPreamp1Type(int preampType) {
        this.preamp1Setting.set(PREAMP_TYPE_OPTIONS[Math.min(PREAMP_TYPE_OPTIONS.length - 1, Math.max(0, preampType))]);
    }

    public void changePreamp1Type(int control) {
        int index = this.valueChanger.changeValue(control, this.preamp1Type, -100.0, PREAMP_TYPE_OPTIONS.length);
        this.preamp1Setting.set(PREAMP_TYPE_OPTIONS[index]);
    }

    public int getPreamp2Type() {
        return this.preamp2Type;
    }

    public void setPreamp2Type(int preampType) {
        this.preamp2Setting.set(PREAMP_TYPE_OPTIONS[Math.min(PREAMP_TYPE_OPTIONS.length - 1, Math.max(0, preampType))]);
    }

    public void changePreamp2Type(int control) {
        int index = this.valueChanger.changeValue(control, this.preamp2Type, -100.0, PREAMP_TYPE_OPTIONS.length);
        this.preamp2Setting.set(PREAMP_TYPE_OPTIONS[index]);
    }

    public int getPreamp1Gain() {
        return this.preamp1Gain;
    }

    public void setPreamp1Gain(int preampGain) {
        this.preamp1GainSetting.set(PREAMP_GAIN_OPTIONS[Math.min(PREAMP_GAIN_OPTIONS.length - 1, Math.max(0, preampGain))]);
    }

    public void changePreamp1Gain(int control) {
        int index = this.valueChanger.changeValue(control, this.preamp1Gain, -100.0, PREAMP_GAIN_OPTIONS.length);
        this.preamp1GainSetting.set(PREAMP_GAIN_OPTIONS[index]);
    }

    public int getPreamp2Gain() {
        return this.preamp2Gain;
    }

    public void setPreamp2Gain(int preampGain) {
        this.preamp2GainSetting.set(PREAMP_GAIN_OPTIONS[Math.min(PREAMP_GAIN_OPTIONS.length - 1, Math.max(0, preampGain))]);
    }

    public void changePreamp2Gain(int control) {
        int index = this.valueChanger.changeValue(control, this.preamp2Gain, -100.0, PREAMP_GAIN_OPTIONS.length);
        this.preamp2GainSetting.set(PREAMP_GAIN_OPTIONS[index]);
    }

    public int getAudioOutputs() {
        return this.audioOutputs;
    }

    public void setAudioOutputs(int audioOutputs) {
        this.audioOutputSetting.set(OUTPUT_CONFIGURATION[audioOutputs]);
    }

    public void changeAudioOutputs(int control) {
        int index = this.valueChanger.changeValue(control, this.audioOutputs, -100.0, OUTPUT_CONFIGURATION.length);
        this.audioOutputSetting.set(OUTPUT_CONFIGURATION[index]);
    }

    private void activateSessionView(ISettingsUI settingsUI) {
        this.sessionViewSetting = settingsUI.getEnumSetting("Pads", "Session", SESSION_VIEW_OPTIONS, SESSION_VIEW_OPTIONS[0]);
        this.sessionViewSetting.addValueObserver(value -> {
            this.flipSession = SESSION_VIEW_OPTIONS[1].equals(value);
            this.isScenesClipView = SESSION_VIEW_OPTIONS[2].equals(value);
            this.notifyObservers(AbstractConfiguration.FLIP_SESSION);
            this.notifyObservers(SESSION_VIEW);
        });
    }

    private void activateCursorKeysSettings(ISettingsUI settingsUI) {
        IEnumSetting cursorKeysTrackSetting = settingsUI.getEnumSetting("Cursor Keys Track Option", "Workflow", CURSOR_KEYS_TRACK_OPTIONS, CURSOR_KEYS_TRACK_OPTIONS[0]);
        cursorKeysTrackSetting.addValueObserver(value -> {
            this.cursorKeysTrackOption = PushConfiguration.lookupIndex(CURSOR_KEYS_TRACK_OPTIONS, value);
        });
        IEnumSetting cursorKeysTrackShiftedSetting = settingsUI.getEnumSetting("Shifted Cursor Keys Track Option", "Workflow", CURSOR_KEYS_TRACK_OPTIONS, CURSOR_KEYS_TRACK_OPTIONS[2]);
        cursorKeysTrackShiftedSetting.addValueObserver(value -> {
            this.cursorKeysTrackShiftedOption = PushConfiguration.lookupIndex(CURSOR_KEYS_TRACK_OPTIONS, value);
        });
        IEnumSetting cursorKeysSceneSetting = settingsUI.getEnumSetting("Cursor Keys Scene Option", "Workflow", CURSOR_KEYS_SCENE_OPTIONS, CURSOR_KEYS_SCENE_OPTIONS[1]);
        cursorKeysSceneSetting.addValueObserver(value -> {
            this.cursorKeysSceneOption = PushConfiguration.lookupIndex(CURSOR_KEYS_SCENE_OPTIONS, value);
        });
        IEnumSetting cursorKeysSceneShiftedSetting = settingsUI.getEnumSetting("Shifted Cursor Keys Scene Option", "Workflow", CURSOR_KEYS_SCENE_OPTIONS, CURSOR_KEYS_SCENE_OPTIONS[0]);
        cursorKeysSceneShiftedSetting.addValueObserver(value -> {
            this.cursorKeysSceneShiftedOption = PushConfiguration.lookupIndex(CURSOR_KEYS_SCENE_OPTIONS, value);
        });
    }

    @Override
    public void setFlipSession(boolean enabled) {
        this.sessionViewSetting.set(enabled ? SESSION_VIEW_OPTIONS[1] : SESSION_VIEW_OPTIONS[0]);
    }

    public void setSceneView() {
        this.sessionViewSetting.set(SESSION_VIEW_OPTIONS[2]);
    }

    public boolean isScenesClipViewSelected() {
        return this.isScenesClipView;
    }

    private void activatePush2HardwareSettings(ISettingsUI settingsUI) {
        if (this.pushVersion == PushVersion.VERSION_1) {
            return;
        }
        this.displayBrightnessSetting = settingsUI.getRangeSetting("Display Brightness", "Hardware Setup", 0, 100, 1, "%", 100);
        this.displayBrightnessSetting.addValueObserver(value -> {
            this.displayBrightness = value;
            this.notifyObservers(DISPLAY_BRIGHTNESS);
        });
        this.ledBrightnessSetting = settingsUI.getRangeSetting("LED Brightness", "Hardware Setup", 0, 100, 1, "%", 100);
        this.ledBrightnessSetting.addValueObserver(value -> {
            this.ledBrightness = value;
            this.notifyObservers(LED_BRIGHTNESS);
        });
    }

    private void activateRibbonSettings(ISettingsUI settingsUI) {
        this.ribbonModeSetting = settingsUI.getEnumSetting("Mode", CATEGORY_RIBBON, RIBBON_MODE_VALUES, RIBBON_MODE_VALUES[0]);
        this.ribbonModeSetting.addValueObserver(value -> {
            this.ribbonMode = PushConfiguration.lookupIndex(RIBBON_MODE_VALUES, value);
            this.notifyObservers(RIBBON_MODE);
        });
        this.ribbonModeCCSetting = settingsUI.getRangeSetting("CC", CATEGORY_RIBBON, 0, 127, 1, "", 1);
        this.ribbonModeCCSetting.addValueObserver(value -> {
            this.ribbonModeCCVal = value;
            this.notifyObservers(RIBBON_MODE_CC_VAL);
        });
        this.ribbonModeNoteRepeatSetting = settingsUI.getEnumSetting("Function if Note Repeat is active", CATEGORY_RIBBON, RIBBON_NOTE_REPEAT_VALUES, RIBBON_NOTE_REPEAT_VALUES[1]);
        this.ribbonModeNoteRepeatSetting.addValueObserver(value -> {
            this.ribbonModeNoteRepeat = PushConfiguration.lookupIndex(RIBBON_NOTE_REPEAT_VALUES, value);
            this.notifyObservers(RIBBON_MODE_NOTE_REPEAT);
        });
    }

    private void activateStopAutomationOnKnobReleaseSetting(ISettingsUI settingsUI) {
        settingsUI.getEnumSetting("Stop automation recording on knob release", "Workflow", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]).addValueObserver(value -> {
            this.stopAutomationOnKnobRelease = "On".equals(value);
            this.notifyObservers(STOP_AUTOMATION_ON_KNOB_RELEASE);
        });
    }

    private void activatePush1PadSettings(ISettingsUI settingsUI) {
        this.velocityCurveSetting = settingsUI.getEnumSetting("Velocity Curve", "Pads", PushControlSurface.PUSH_PAD_CURVES_NAME, PushControlSurface.PUSH_PAD_CURVES_NAME.get(1));
        this.velocityCurveSetting.addValueObserver(value -> {
            this.velocityCurve = PushConfiguration.lookupIndex(PushControlSurface.PUSH_PAD_CURVES_NAME, value);
            this.notifyObservers(VELOCITY_CURVE);
        });
        this.padThresholdSetting = settingsUI.getEnumSetting("Pad Threshold", "Pads", PushControlSurface.PUSH_PAD_THRESHOLDS_NAME, PushControlSurface.PUSH_PAD_THRESHOLDS_NAME.get(20));
        this.padThresholdSetting.addValueObserver(value -> {
            this.padThreshold = PushConfiguration.lookupIndex(PushControlSurface.PUSH_PAD_THRESHOLDS_NAME, value);
            this.notifyObservers(PAD_THRESHOLD);
        });
    }

    private void activatePush2PadSettings(ISettingsUI settingsUI) {
        this.padSensitivitySetting = settingsUI.getRangeSetting("Sensitivity", "Pads", 0, 10, 1, "", 5);
        this.padSensitivitySetting.addValueObserver(value -> {
            this.padSensitivity = value;
            this.notifyObservers(PAD_SENSITIVITY);
        });
        this.padGainSetting = settingsUI.getRangeSetting("Gain", "Pads", 0, 10, 1, "", 5);
        this.padGainSetting.addValueObserver(value -> {
            this.padGain = value;
            this.notifyObservers(PAD_GAIN);
        });
        this.padDynamicsSetting = settingsUI.getRangeSetting("Dynamics", "Pads", 0, 10, 1, "", 5);
        this.padDynamicsSetting.addValueObserver(value -> {
            this.padDynamics = value;
            this.notifyObservers(PAD_DYNAMICS);
        });
    }

    private void activatePush3MPESettings(ISettingsUI settingsUI) {
        this.activateMPESetting(settingsUI, "Pads", true);
        this.perPadPitchbendSetting = settingsUI.getEnumSetting("Per-Pad Pitchbend", "Pads", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        this.perPadPitchbendSetting.addValueObserver(value -> {
            this.perPadPitchbend = ON_OFF_OPTIONS[1].equals(value);
            this.notifyObservers(PER_PAD_PITCHBEND);
        });
        this.inTuneLocationSetting = settingsUI.getEnumSetting("In Tune Location", "Pads", IN_TUNE_LOCATION_OPTIONS, IN_TUNE_LOCATION_OPTIONS[1]);
        this.inTuneLocationSetting.addValueObserver(value -> {
            this.inTuneLocation = PushConfiguration.lookupIndex(IN_TUNE_LOCATION_OPTIONS, value);
            this.notifyObservers(IN_TUNE_LOCATION);
        });
        this.inTuneWidthSetting = settingsUI.getEnumSetting("In Tune Width (mm)", "Pads", IN_TUNE_WIDTH_OPTIONS, IN_TUNE_WIDTH_OPTIONS[9]);
        this.inTuneWidthSetting.addValueObserver(value -> {
            this.inTuneWidth = PushConfiguration.lookupIndex(IN_TUNE_WIDTH_OPTIONS, value);
            this.notifyObservers(IN_TUNE_WIDTH);
        });
        this.slideHeightSetting = settingsUI.getEnumSetting("Slide Height (mm)", "Pads", SLIDE_HEIGHT_OPTIONS, SLIDE_HEIGHT_OPTIONS[3]);
        this.slideHeightSetting.addValueObserver(value -> {
            this.slideHeight = PushConfiguration.lookupIndex(SLIDE_HEIGHT_OPTIONS, value);
            this.notifyObservers(IN_TUNE_SLIDE_HEIGHT);
        });
    }

    private void activatePush3AudioSettings(ISettingsUI settingsUI) {
        this.pedal1Setting = settingsUI.getEnumSetting("Pedal & CV 1", CATEGORY_AUDIO, FOOT_CV_OPTIONS, FOOT_CV_OPTIONS[0]);
        this.pedal1Setting.addValueObserver(value -> {
            this.pedal1 = PushConfiguration.lookupIndex(FOOT_CV_OPTIONS, value);
            this.notifyObservers(PEDAL_1);
        });
        this.pedal2Setting = settingsUI.getEnumSetting("Pedal & CV 2", CATEGORY_AUDIO, FOOT_CV_OPTIONS, FOOT_CV_OPTIONS[0]);
        this.pedal2Setting.addValueObserver(value -> {
            this.pedal2 = PushConfiguration.lookupIndex(FOOT_CV_OPTIONS, value);
            this.notifyObservers(PEDAL_2);
        });
        this.preamp1Setting = settingsUI.getEnumSetting("Preamp 1", CATEGORY_AUDIO, PREAMP_TYPE_OPTIONS, PREAMP_TYPE_OPTIONS[0]);
        this.preamp1Setting.addValueObserver(value -> {
            this.preamp1Type = PushConfiguration.lookupIndex(PREAMP_TYPE_OPTIONS, value);
            this.notifyObservers(PREAMP_TYPE_1);
        });
        this.preamp2Setting = settingsUI.getEnumSetting("Preamp 2", CATEGORY_AUDIO, PREAMP_TYPE_OPTIONS, PREAMP_TYPE_OPTIONS[0]);
        this.preamp2Setting.addValueObserver(value -> {
            this.preamp2Type = PushConfiguration.lookupIndex(PREAMP_TYPE_OPTIONS, value);
            this.notifyObservers(PREAMP_TYPE_2);
        });
        this.preamp1GainSetting = settingsUI.getEnumSetting("Gain 1", CATEGORY_AUDIO, PREAMP_GAIN_OPTIONS, PREAMP_GAIN_OPTIONS[0]);
        this.preamp1GainSetting.addValueObserver(value -> {
            this.preamp1Gain = PushConfiguration.lookupIndex(PREAMP_GAIN_OPTIONS, value);
            this.notifyObservers(PREAMP_GAIN_1);
        });
        this.preamp2GainSetting = settingsUI.getEnumSetting("Gain 2", CATEGORY_AUDIO, PREAMP_GAIN_OPTIONS, PREAMP_GAIN_OPTIONS[0]);
        this.preamp2GainSetting.addValueObserver(value -> {
            this.preamp2Gain = PushConfiguration.lookupIndex(PREAMP_GAIN_OPTIONS, value);
            this.notifyObservers(PREAMP_GAIN_2);
        });
        this.audioOutputSetting = settingsUI.getEnumSetting("Outputs", CATEGORY_AUDIO, OUTPUT_CONFIGURATION, OUTPUT_CONFIGURATION[0]);
        this.audioOutputSetting.addValueObserver(value -> {
            this.audioOutputs = PushConfiguration.lookupIndex(OUTPUT_CONFIGURATION, value);
            this.notifyObservers(AUDIO_OUTPUTS);
        });
    }

    private void activatePush2DisplayColorsSettings(ISettingsUI settingsUI) {
        if (this.pushVersion == PushVersion.VERSION_1) {
            return;
        }
        settingsUI.getSignalSetting("Reset colors to default", CATEGORY_COLORS, "Reset").addSignalObserver(value -> {
            this.colorBackgroundSetting.set(DEFAULT_COLOR_BACKGROUND);
            this.colorBackgroundDarkerSetting.set(DEFAULT_COLOR_BACKGROUND_DARKER);
            this.colorBackgroundLighterSetting.set(DEFAULT_COLOR_BACKGROUND_LIGHTER);
            this.colorBorderSetting.set(DEFAULT_COLOR_BORDER);
            this.colorTextSetting.set(DEFAULT_COLOR_TEXT);
            this.colorFaderSetting.set(DEFAULT_COLOR_FADER);
            this.colorVUSetting.set(DEFAULT_COLOR_VU);
            this.colorEditSetting.set(DEFAULT_COLOR_EDIT);
            this.colorRecordSetting.set(DEFAULT_COLOR_RECORD);
            this.colorSoloSetting.set(DEFAULT_COLOR_SOLO);
            this.colorMuteSetting.set(DEFAULT_COLOR_MUTE);
        });
        this.colorBackgroundSetting = settingsUI.getColorSetting("Background", CATEGORY_COLORS, DEFAULT_COLOR_BACKGROUND);
        this.colorBackgroundSetting.addValueObserver(color -> {
            this.colorBackground = color;
            this.notifyObservers(COLOR_BACKGROUND);
        });
        this.colorBackgroundDarkerSetting = settingsUI.getColorSetting("Background Darker", CATEGORY_COLORS, DEFAULT_COLOR_BACKGROUND_DARKER);
        this.colorBackgroundDarkerSetting.addValueObserver(color -> {
            this.colorBackgroundDarker = color;
            this.notifyObservers(COLOR_BACKGROUND_DARKER);
        });
        this.colorBackgroundLighterSetting = settingsUI.getColorSetting("Background Selected", CATEGORY_COLORS, DEFAULT_COLOR_BACKGROUND_LIGHTER);
        this.colorBackgroundLighterSetting.addValueObserver(color -> {
            this.colorBackgroundLighter = color;
            this.notifyObservers(COLOR_BACKGROUND_LIGHTER);
        });
        this.colorBorderSetting = settingsUI.getColorSetting("Border", CATEGORY_COLORS, DEFAULT_COLOR_BORDER);
        this.colorBorderSetting.addValueObserver(color -> {
            this.colorBorder = color;
            this.notifyObservers(COLOR_BORDER);
        });
        this.colorTextSetting = settingsUI.getColorSetting("Text", CATEGORY_COLORS, DEFAULT_COLOR_TEXT);
        this.colorTextSetting.addValueObserver(color -> {
            this.colorText = color;
            this.notifyObservers(COLOR_TEXT);
        });
        this.colorFaderSetting = settingsUI.getColorSetting("Fader", CATEGORY_COLORS, DEFAULT_COLOR_FADER);
        this.colorFaderSetting.addValueObserver(color -> {
            this.colorFader = color;
            this.notifyObservers(COLOR_FADER);
        });
        this.colorVUSetting = settingsUI.getColorSetting("VU", CATEGORY_COLORS, DEFAULT_COLOR_VU);
        this.colorVUSetting.addValueObserver(color -> {
            this.colorVU = color;
            this.notifyObservers(COLOR_VU);
        });
        this.colorEditSetting = settingsUI.getColorSetting("Edit", CATEGORY_COLORS, DEFAULT_COLOR_EDIT);
        this.colorEditSetting.addValueObserver(color -> {
            this.colorEdit = color;
            this.notifyObservers(COLOR_EDIT);
        });
        this.colorRecordSetting = settingsUI.getColorSetting("Record", CATEGORY_COLORS, DEFAULT_COLOR_RECORD);
        this.colorRecordSetting.addValueObserver(color -> {
            this.colorRecord = color;
            this.notifyObservers(COLOR_RECORD);
        });
        this.colorSoloSetting = settingsUI.getColorSetting("Solo", CATEGORY_COLORS, DEFAULT_COLOR_SOLO);
        this.colorSoloSetting.addValueObserver(color -> {
            this.colorSolo = color;
            this.notifyObservers(COLOR_SOLO);
        });
        this.colorMuteSetting = settingsUI.getColorSetting("Mute", CATEGORY_COLORS, DEFAULT_COLOR_MUTE);
        this.colorMuteSetting.addValueObserver(color -> {
            this.colorMute = color;
            this.notifyObservers(COLOR_MUTE);
        });
    }

    private void activateDebugSettings(ISettingsUI settingsUI) {
        String[] modes = new String[DEBUG_MODES.size()];
        int i = 0;
        for (Modes mode : DEBUG_MODES) {
            modes[i] = mode.toString();
            ++i;
        }
        this.debugModeSetting = settingsUI.getEnumSetting("Display Mode", "Debug", modes, Modes.TRACK.toString());
        this.debugModeSetting.addValueObserver(value -> {
            try {
                this.debugMode = Modes.valueOf(value);
            }
            catch (IllegalArgumentException ex) {
                this.debugMode = Modes.TRACK;
            }
            this.notifyObservers(DEBUG_MODE);
        });
        if (this.pushVersion == PushVersion.VERSION_1) {
            return;
        }
        settingsUI.getSignalSetting(" ", "Debug", "Display window").addSignalObserver(value -> this.notifyObservers(DEBUG_WINDOW));
    }

    static {
        DEBUG_MODES.add(Modes.TRACK);
        DEBUG_MODES.add(Modes.TRACK_DETAILS);
        DEBUG_MODES.add(Modes.VOLUME);
        DEBUG_MODES.add(Modes.CROSSFADER);
        DEBUG_MODES.add(Modes.PAN);
        DEBUG_MODES.add(Modes.SEND1);
        DEBUG_MODES.add(Modes.SEND2);
        DEBUG_MODES.add(Modes.SEND3);
        DEBUG_MODES.add(Modes.SEND4);
        DEBUG_MODES.add(Modes.SEND5);
        DEBUG_MODES.add(Modes.SEND6);
        DEBUG_MODES.add(Modes.SEND7);
        DEBUG_MODES.add(Modes.SEND8);
        DEBUG_MODES.add(Modes.MASTER);
        DEBUG_MODES.add(Modes.MASTER_TEMP);
        DEBUG_MODES.add(Modes.DEVICE_PARAMS);
        DEBUG_MODES.add(Modes.DEVICE_CHAINS);
        DEBUG_MODES.add(Modes.DEVICE_LAYER);
        DEBUG_MODES.add(Modes.DEVICE_LAYER_VOLUME);
        DEBUG_MODES.add(Modes.DEVICE_LAYER_PAN);
        DEBUG_MODES.add(Modes.DEVICE_LAYER_SEND1);
        DEBUG_MODES.add(Modes.DEVICE_LAYER_SEND2);
        DEBUG_MODES.add(Modes.DEVICE_LAYER_SEND3);
        DEBUG_MODES.add(Modes.DEVICE_LAYER_SEND4);
        DEBUG_MODES.add(Modes.DEVICE_LAYER_SEND5);
        DEBUG_MODES.add(Modes.DEVICE_LAYER_SEND6);
        DEBUG_MODES.add(Modes.DEVICE_LAYER_SEND7);
        DEBUG_MODES.add(Modes.DEVICE_LAYER_SEND8);
        DEBUG_MODES.add(Modes.DEVICE_LAYER_DETAILS);
        DEBUG_MODES.add(Modes.BROWSER);
        DEBUG_MODES.add(Modes.CLIP);
        DEBUG_MODES.add(Modes.NOTE);
        DEBUG_MODES.add(Modes.FRAME);
        DEBUG_MODES.add(Modes.GROOVE);
        DEBUG_MODES.add(Modes.REC_ARM);
        DEBUG_MODES.add(Modes.ACCENT);
        DEBUG_MODES.add(Modes.SCALES);
        DEBUG_MODES.add(Modes.SCALE_LAYOUT);
        DEBUG_MODES.add(Modes.FIXED);
        DEBUG_MODES.add(Modes.RIBBON);
        DEBUG_MODES.add(Modes.VIEW_SELECT);
        DEBUG_MODES.add(Modes.AUTOMATION);
        DEBUG_MODES.add(Modes.TRANSPORT);
        DEBUG_MODES.add(Modes.MARKERS);
        DEBUG_MODES.add(Modes.USER);
        DEBUG_MODES.add(Modes.SETUP);
        DEBUG_MODES.add(Modes.INFO);
        DEBUG_MODES.add(Modes.CONFIGURATION);
        DEBUG_MODES.add(Modes.SESSION);
        DEBUG_MODES.add(Modes.SESSION_VIEW_SELECT);
        DEBUG_MODES.add(Modes.REPEAT_NOTE);
        IN_TUNE_LOCATION_OPTIONS = new String[]{"Pad", "Finger"};
        IN_TUNE_WIDTH_OPTIONS = new String[]{"0", "1", "2", "2.5", "3", "4", "5", "6", "7", "10", "13", "20"};
        SLIDE_HEIGHT_OPTIONS = new String[]{"10", "11", "12", "13", "14", "15", "16"};
        FOOT_CV_OPTIONS = new String[]{"Footswitch", "CV Out"};
        PREAMP_TYPE_OPTIONS = new String[]{"Line", "Instrument", "High"};
        PREAMP_GAIN_OPTIONS = new String[]{"0dB", "1dB", "2dB", "3dB", "4dB", "5dB", "6dB", "7dB", "8dB", "9dB", "10dB", "11dB", "12dB", "13dB", "14dB", "15dB", "16dB", "17dB", "18dB", "19dB", "20dB"};
        OUTPUT_CONFIGURATION = new String[]{"Headphones 1/2 - Speaker 1/2", "Headphones 3/4 - Speaker 1/2", "Headphones 1/2 - Speaker 3/4"};
        OUTPUT_CONFIGURATION_SHORT = new String[]{"H1/2-S1/2", "H3/4-S1/2", "H1/2-S3/4"};
    }

    public static enum LockState {
        OFF,
        MUTE,
        SOLO,
        CLIP_STOP;

    }
}

