/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push;

import de.mossgrabers.framework.controller.DefaultControllerDefinition;
import de.mossgrabers.framework.usb.UsbMatcher;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.List;
import java.util.UUID;

public class Push3ControllerDefinition
extends DefaultControllerDefinition {
    private static final UUID EXTENSION_ID = UUID.fromString("F8D561F2-722D-4DC7-975A-C562788C63FA");
    private static final short VENDOR_ID = 10626;
    private static final short PRODUCT_ID = 6505;
    private static final byte INTERFACE_NUMBER = 0;
    private static final byte ENDPOINT_ADDRESS = 1;

    public Push3ControllerDefinition() {
        super(EXTENSION_ID, "Push 3", "Ableton", 1, 1);
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        List<Pair<String[], String[]>> midiDiscoveryPairs = super.getMidiDiscoveryPairs(os);
        switch (os) {
            case WINDOWS: {
                midiDiscoveryPairs.addAll(this.createDeviceDiscoveryPairs("Ableton Push 3 MIDI"));
                break;
            }
            case MAC: 
            case MAC_ARM: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("Ableton Push 3 Live Port"));
                break;
            }
            case LINUX: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("Ableton Push 3 Live Port"));
                break;
            }
        }
        return midiDiscoveryPairs;
    }

    @Override
    public UsbMatcher claimUSBDevice() {
        return new UsbMatcher(10626, 6505, 0, 1, true);
    }
}

