/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push;

import de.mossgrabers.framework.controller.DefaultControllerDefinition;
import de.mossgrabers.framework.usb.UsbMatcher;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.List;
import java.util.UUID;

public class Push2ControllerDefinition
extends DefaultControllerDefinition {
    private static final UUID EXTENSION_ID = UUID.fromString("15176AA0-C476-11E6-9598-0800200C9A66");
    private static final short VENDOR_ID = 10626;
    private static final short PRODUCT_ID = 6503;
    private static final byte INTERFACE_NUMBER = 0;
    private static final byte ENDPOINT_ADDRESS = 1;

    public Push2ControllerDefinition() {
        super(EXTENSION_ID, "Push 2", "Ableton", 1, 1);
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        List<Pair<String[], String[]>> midiDiscoveryPairs = super.getMidiDiscoveryPairs(os);
        switch (os) {
            case WINDOWS: {
                midiDiscoveryPairs.addAll(this.createDeviceDiscoveryPairs("Ableton Push 2"));
                break;
            }
            case MAC: 
            case MAC_ARM: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("Ableton Push 2 Live Port"));
                break;
            }
            case LINUX: {
                midiDiscoveryPairs.addAll(this.createLinuxDeviceDiscoveryPairs("A2", "A2"));
                break;
            }
        }
        return midiDiscoveryPairs;
    }

    @Override
    public UsbMatcher claimUSBDevice() {
        return new UsbMatcher(10626, 6503, 0, 1, true);
    }
}

