/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi;

import com.sun.jna.Platform;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import purejavahidapi.HidDevice;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.linux.LinuxBackend;
import purejavahidapi.macosx.MacOsXBackend;
import purejavahidapi.shared.Backend;
import purejavahidapi.windows.WindowsBackend;

public class PureJavaHidApi {
    private static Object m_Mutex = new Object();
    private static Backend m_Backend = null;
    private static LinkedList<HidDevice> m_OpenDevices = new LinkedList();

    public static String getVersion() {
        return "0.0.20";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HidDeviceInfo> enumerateDevices() {
        Object object = m_Mutex;
        synchronized (object) {
            PureJavaHidApi.ensureBackend();
            return m_Backend.enumerateDevices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HidDevice openDevice(HidDeviceInfo path) throws IOException {
        Object object = m_Mutex;
        synchronized (object) {
            PureJavaHidApi.ensureBackend();
            HidDevice device = m_Backend.openDevice(path);
            if (device != null) {
                m_OpenDevices.add(device);
            }
            return device;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup() {
        Object object = m_Mutex;
        synchronized (object) {
            if (m_Backend == null) {
                return;
            }
            m_OpenDevices.clear();
            m_Backend.cleanup();
            m_Backend = null;
        }
    }

    private static void ensureBackend() {
        if (m_Backend == null) {
            if (Platform.isMac()) {
                m_Backend = new MacOsXBackend();
            } else if (Platform.isWindows()) {
                m_Backend = new WindowsBackend();
            } else if (Platform.isLinux()) {
                m_Backend = new LinuxBackend();
            } else {
                throw new IllegalStateException("Unsupported platform");
            }
        }
        m_Backend.init();
    }
}

