/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.windows;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinNT;
import purejavahidapi.windows.HidLibrary;

class HidDeviceInfo
extends purejavahidapi.HidDeviceInfo {
    public HidDeviceInfo(String path, String deviceId, WinNT.HANDLE handle, HidLibrary.HIDD_ATTRIBUTES attrib) {
        try {
            int sizeofWstr;
            Memory wstr;
            this.m_Path = path;
            this.m_DeviceId = deviceId;
            this.m_VendorId = attrib.VendorID;
            this.m_ProductId = attrib.ProductID;
            HidLibrary.HIDP_CAPS caps = new HidLibrary.HIDP_CAPS();
            HidLibrary.HIDP_PREPARSED_DATA[] ppd = new HidLibrary.HIDP_PREPARSED_DATA[1];
            if (HidLibrary.HidD_GetPreparsedData(handle, ppd)) {
                if (HidLibrary.HidP_GetCaps(ppd[0], caps) == 0x110000) {
                    this.m_UsagePage = caps.UsagePage;
                }
                HidLibrary.HidD_FreePreparsedData(ppd[0]);
            }
            if (HidLibrary.HidD_GetSerialNumberString(handle, (Pointer)(wstr = new Memory(256L)), sizeofWstr = (int)wstr.size())) {
                this.m_SerialNumberString = wstr.getWideString(0L);
            }
            if (HidLibrary.HidD_GetManufacturerString(handle, (Pointer)wstr, sizeofWstr)) {
                this.m_ManufactureString = wstr.getWideString(0L);
            }
            if (HidLibrary.HidD_GetProductString(handle, (Pointer)wstr, sizeofWstr)) {
                this.m_ProductString = wstr.getWideString(0L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

