/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.macosx;

import com.sun.jna.Pointer;
import java.util.LinkedList;
import java.util.List;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.macosx.CoreFoundationLibrary;
import purejavahidapi.macosx.HidDevice;
import purejavahidapi.macosx.IOHIDManagerLibrary;
import purejavahidapi.shared.Backend;

public class MacOsXBackend
extends Backend {
    static IOHIDManagerLibrary.IOHIDManagerRef m_HidManager;

    @Override
    public List<HidDeviceInfo> enumerateDevices() {
        LinkedList<HidDeviceInfo> list = new LinkedList<HidDeviceInfo>();
        HidDevice.processPendingEvents();
        IOHIDManagerLibrary.IOHIDManagerSetDeviceMatching(m_HidManager, null);
        CoreFoundationLibrary.CFSetRef device_set = IOHIDManagerLibrary.IOHIDManagerCopyDevices(m_HidManager);
        int num_devices = (int)CoreFoundationLibrary.CFSetGetCount(device_set);
        Pointer[] device_array = new Pointer[num_devices];
        CoreFoundationLibrary.CFSetGetValues(device_set, device_array);
        int i = 0;
        while (i < num_devices) {
            IOHIDManagerLibrary.IOHIDDeviceRef dev = new IOHIDManagerLibrary.IOHIDDeviceRef(device_array[i]);
            purejavahidapi.macosx.HidDeviceInfo info = new purejavahidapi.macosx.HidDeviceInfo(dev);
            list.add(info);
            ++i;
        }
        CoreFoundationLibrary.CFRelease(device_set);
        return list;
    }

    @Override
    public purejavahidapi.HidDevice openDevice(HidDeviceInfo deviceInfo) {
        return new HidDevice((purejavahidapi.macosx.HidDeviceInfo)deviceInfo, this);
    }

    IOHIDManagerLibrary.IOHIDDeviceRef getIOHIDDeviceRef(String path) {
        HidDevice.processPendingEvents();
        CoreFoundationLibrary.CFSetRef device_set = IOHIDManagerLibrary.IOHIDManagerCopyDevices(m_HidManager);
        int num_devices = (int)CoreFoundationLibrary.CFSetGetCount(device_set);
        Pointer[] device_array = new Pointer[num_devices];
        CoreFoundationLibrary.CFSetGetValues(device_set, device_array);
        int i = 0;
        while (i < num_devices) {
            IOHIDManagerLibrary.IOHIDDeviceRef os_dev = new IOHIDManagerLibrary.IOHIDDeviceRef(device_array[i]);
            String x = HidDevice.createPathForDevide(os_dev);
            if (path.equals(x)) {
                int ret = IOHIDManagerLibrary.IOHIDDeviceOpen(os_dev, 0);
                if (ret == 0) {
                    CoreFoundationLibrary.CFRetain(os_dev);
                    CoreFoundationLibrary.CFRelease(device_set);
                    return os_dev;
                }
                System.out.printf("IOHIDDeviceOpen: %d,%d,%d\n", ret >> 26 & 0x3F, ret >> 14 & 0xFFF, ret & 0x3FFF);
            }
            ++i;
        }
        CoreFoundationLibrary.CFRelease(device_set);
        return null;
    }

    @Override
    public void cleanup() {
        if (m_HidManager != null) {
            IOHIDManagerLibrary.IOHIDManagerClose(m_HidManager, 0);
            CoreFoundationLibrary.CFRelease(m_HidManager);
            m_HidManager = null;
        }
    }

    @Override
    public void init() {
        if (m_HidManager == null) {
            m_HidManager = IOHIDManagerLibrary.IOHIDManagerCreate(CoreFoundationLibrary.kCFAllocatorDefault, 0);
            if (m_HidManager == null) {
                throw new RuntimeException("IOHIDManagerCreate call failed");
            }
            IOHIDManagerLibrary.IOHIDManagerSetDeviceMatching(m_HidManager, null);
            IOHIDManagerLibrary.IOHIDManagerScheduleWithRunLoop(m_HidManager, CoreFoundationLibrary.CFRunLoopGetCurrent(), CoreFoundationLibrary.kCFRunLoopDefaultMode);
        }
    }
}

