/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.messageselector;

import com.illposed.osc.MessageSelector;
import com.illposed.osc.OSCMessageEvent;

public class CombinedMessageSelector
implements MessageSelector {
    private final MessageSelector selector1;
    private final MessageSelector selector2;
    private final LogicOperator logicOperator;

    public CombinedMessageSelector(MessageSelector selector1, MessageSelector selector2, LogicOperator logicOperator) {
        this.selector1 = selector1;
        this.selector2 = selector2;
        this.logicOperator = logicOperator;
    }

    public CombinedMessageSelector(MessageSelector selector1, MessageSelector selector2) {
        this(selector1, selector2, LogicOperator.AND);
    }

    @Override
    public boolean isInfoRequired() {
        return this.selector1.isInfoRequired() || this.selector2.isInfoRequired();
    }

    @Override
    public boolean matches(OSCMessageEvent messageEvent) {
        return this.logicOperator.matches(this.selector1.matches(messageEvent), this.selector2.matches(messageEvent));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum LogicOperator {
        AND{

            @Override
            public boolean matches(boolean matches1, boolean matches2) {
                return matches1 && matches2;
            }
        }
        ,
        OR{

            @Override
            public boolean matches(boolean matches1, boolean matches2) {
                return matches1 || matches2;
            }
        }
        ,
        XOR{

            @Override
            public boolean matches(boolean matches1, boolean matches2) {
                return matches1 && !matches2 || !matches1 && matches2;
            }
        };


        public abstract boolean matches(boolean var1, boolean var2);
    }
}

