/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui.dialog;

import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.reaper.framework.daw.data.bank.ParameterBankImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.ParameterImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.map.ParameterMap;
import de.mossgrabers.reaper.framework.daw.data.parameter.map.ParameterMapPage;
import de.mossgrabers.reaper.framework.daw.data.parameter.map.ParameterMapPageParameter;
import de.mossgrabers.reaper.ui.dialog.BasicDialog;
import de.mossgrabers.reaper.ui.widget.BoxPanel;
import de.mossgrabers.reaper.ui.widget.Functions;
import de.mossgrabers.reaper.ui.widget.JListX;
import de.mossgrabers.reaper.ui.widget.TwoColsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.text.Position;

public class ParameterMappingDialog
extends BasicDialog {
    private static final long serialVersionUID = 3773770769128020035L;
    private final ICursorDevice cursorDevice;
    private final ParameterMap parameterMap;
    private JListX<ParameterImpl> parametersListBox;
    private JTextField searchField;
    private JListX<ParameterMapPage> pagesListBox;
    private JListX<ParameterMapPageParameter> pageParametersListBox;
    private JButton addPageButton;
    private JButton removePageButton;
    private JButton editPageButton;
    private JButton movePageUpButton;
    private JButton movePageDownButton;
    private JButton assignParamButton;
    private JButton clearParamButton;
    private JButton editParamButton;
    private JButton moveParamUpButton;
    private JButton moveParamDownButton;

    public ParameterMappingDialog(Window owner, ICursorDevice cursorDevice, ParameterMap parameterMap) {
        super((JFrame)owner, "Parameter Mapping", true, true);
        this.setMinimumSize(new Dimension(800, 600));
        this.setSize(600, 600);
        this.cursorDevice = cursorDevice;
        this.parameterMap = parameterMap;
        this.basicInit();
    }

    @Override
    protected void setFocusOn() {
        this.searchField.requestFocus();
    }

    @Override
    protected Container init() {
        JPanel contentPane = new JPanel(new BorderLayout());
        TwoColsPanel titlePane = new TwoColsPanel(true);
        contentPane.add((Component)titlePane, "North");
        titlePane.addComponent(new JLabel(this.cursorDevice.getName()), "Device:", null, 12);
        JPanel center = new JPanel(new BorderLayout());
        contentPane.add((Component)center, "Center");
        BoxPanel searchPane = new BoxPanel(0, true);
        this.searchField = searchPane.createField("Search:", "S", 4);
        searchPane.createButton(Functions.getIcon("Clear", 16), 4).addActionListener(event -> this.clearSearchField());
        searchPane.createButton(Functions.getIcon("Up", 16), 4).addActionListener(event -> this.searchParam(Position.Bias.Backward));
        JButton searchNextButton = searchPane.createButton(Functions.getIcon("Down", 16), 0);
        searchNextButton.addActionListener(event -> this.searchParam(Position.Bias.Forward));
        BoxPanel parameterPane = new BoxPanel(1, true);
        ParameterBankImpl parameterBank = (ParameterBankImpl)this.cursorDevice.getParameterBank();
        this.parametersListBox = parameterPane.createListBox("Parameters:", "P", 0, ParameterMappingDialog.getParameters(parameterBank));
        JPanel leftColumn = new JPanel(new BorderLayout());
        leftColumn.add((Component)searchPane, "North");
        leftColumn.add((Component)parameterPane, "Center");
        center.add((Component)leftColumn, "Center");
        JPanel rightColumn = new JPanel(new BorderLayout());
        center.add((Component)rightColumn, "East");
        BoxPanel pagesBoxWrapper = new BoxPanel(1, true);
        List<ParameterMapPage> pages = this.parameterMap.getPages();
        this.pagesListBox = pagesBoxWrapper.createListBox("Pages:", "G", 0, pages);
        BoxPanel pagesButtonsPanel = new BoxPanel(1, true);
        pagesButtonsPanel.createSpace(-1);
        this.addPageButton = pagesButtonsPanel.createButton(Functions.getIcon("Add"), "Add", null, 4);
        this.addPageButton.setHorizontalAlignment(2);
        this.addPageButton.addActionListener(event -> this.addParamPage());
        this.removePageButton = pagesButtonsPanel.createButton(Functions.getIcon("Remove"), "Remove", null, 4);
        this.removePageButton.addActionListener(event -> this.removeParamPage());
        this.removePageButton.setHorizontalAlignment(2);
        this.editPageButton = pagesButtonsPanel.createButton(Functions.getIcon("Edit"), "Rename", null, 0);
        this.editPageButton.addActionListener(event -> this.editParamPage());
        this.editPageButton.setHorizontalAlignment(2);
        this.movePageUpButton = pagesButtonsPanel.createButton(Functions.getIcon("Up"), "Move Up", null, 0);
        this.movePageUpButton.addActionListener(event -> this.moveParamPageUp());
        this.movePageUpButton.setHorizontalAlignment(2);
        this.movePageDownButton = pagesButtonsPanel.createButton(Functions.getIcon("Down"), "Move Down", null, 0);
        this.movePageDownButton.addActionListener(event -> this.moveParamPageDown());
        this.movePageDownButton.setHorizontalAlignment(2);
        pagesButtonsPanel.sizeEqual();
        JPanel pagesRowPanel = new JPanel(new BorderLayout());
        pagesRowPanel.add((Component)pagesBoxWrapper, "Center");
        pagesRowPanel.add((Component)pagesButtonsPanel, "East");
        this.pagesListBox.addListSelectionListener(e -> this.handlePageListChanges());
        BoxPanel paramsOfPageBoxWrapper = new BoxPanel(1, true);
        List content = pages.isEmpty() ? Collections.emptyList() : pages.get(0).getParameters();
        this.pageParametersListBox = paramsOfPageBoxWrapper.createListBox("Parameters assigned to page:", "T", 0, content);
        BoxPanel paramButtonsPanel = new BoxPanel(1, true);
        paramButtonsPanel.createSpace(-1);
        this.assignParamButton = paramButtonsPanel.createButton(Functions.getIcon("Assign"), "Assign", null, 4);
        this.assignParamButton.setHorizontalAlignment(2);
        this.assignParamButton.addActionListener(event -> this.assignParam());
        this.clearParamButton = paramButtonsPanel.createButton(Functions.getIcon("Remove"), "Clear", null, 4);
        this.clearParamButton.setHorizontalAlignment(2);
        this.clearParamButton.addActionListener(event -> this.clearParam());
        this.editParamButton = paramButtonsPanel.createButton(Functions.getIcon("Edit"), "Rename", null, 0);
        this.editParamButton.setHorizontalAlignment(2);
        this.editParamButton.addActionListener(event -> this.editParam());
        this.moveParamUpButton = paramButtonsPanel.createButton(Functions.getIcon("Up"), "Move Up", null, 0);
        this.moveParamUpButton.setHorizontalAlignment(2);
        this.moveParamUpButton.addActionListener(event -> this.moveParamUp());
        this.moveParamDownButton = paramButtonsPanel.createButton(Functions.getIcon("Down"), "Move Down", null, 0);
        this.moveParamDownButton.setHorizontalAlignment(2);
        this.moveParamDownButton.addActionListener(event -> this.moveParamDown());
        paramButtonsPanel.sizeEqual();
        JPanel paramsOfPageRowPanel = new JPanel(new BorderLayout());
        paramsOfPageRowPanel.add((Component)paramsOfPageBoxWrapper, "Center");
        paramsOfPageRowPanel.add((Component)paramButtonsPanel, "East");
        rightColumn.add((Component)pagesRowPanel, "Center");
        rightColumn.add((Component)paramsOfPageRowPanel, "South");
        this.pageParametersListBox.addListSelectionListener(e -> this.updateParameterListButtons());
        BoxPanel buttons = new BoxPanel(0, true);
        contentPane.add((Component)buttons, "South");
        buttons.createSpace(-1);
        JButton discardButton = buttons.createButton(Functions.getIcon("Remove"), "Discard", null, 12);
        JButton saveButton = buttons.createButton(Functions.getIcon("Confirm"), "Save", null, 0);
        Functions.asWidthAs(discardButton, saveButton);
        this.setButtons(saveButton, discardButton);
        this.getRootPane().setDefaultButton(searchNextButton);
        this.handlePageListChanges();
        return contentPane;
    }

    @Override
    protected boolean onOk() {
        List<ParameterMapPage> pages = this.parameterMap.getPages();
        pages.clear();
        ListModel model = this.pagesListBox.getModel();
        for (int i = 0; i < ((DefaultListModel)model).getSize(); ++i) {
            pages.add((ParameterMapPage)((DefaultListModel)model).get(i));
        }
        return super.onOk();
    }

    private void handlePageListChanges() {
        int selectedIndex = this.pagesListBox.getSelectedIndex();
        boolean hasSelection = selectedIndex >= 0;
        this.removePageButton.setEnabled(hasSelection);
        this.editPageButton.setEnabled(hasSelection);
        this.movePageUpButton.setEnabled(hasSelection && selectedIndex > 0);
        this.movePageDownButton.setEnabled(hasSelection && selectedIndex < ((DefaultListModel)this.pagesListBox.getModel()).getSize() - 1);
        this.fillParameterBox();
    }

    private void fillParameterBox() {
        ListModel model = this.pageParametersListBox.getModel();
        int selectedPage = this.pagesListBox.getSelectedIndex();
        ((DefaultListModel)model).clear();
        if (selectedPage < 0) {
            return;
        }
        int selectedIndex = this.pageParametersListBox.getSelectedIndex();
        ((DefaultListModel)model).addAll(((ParameterMapPage)((DefaultListModel)this.pagesListBox.getModel()).get(selectedPage)).getParameters());
        this.pageParametersListBox.setSelectedIndex(selectedIndex < 0 ? 0 : selectedIndex);
    }

    private void updateParameterListButtons() {
        int selectedIndex = this.pageParametersListBox.getSelectedIndex();
        boolean hasSelection = selectedIndex >= 0;
        ListModel model = this.pageParametersListBox.getModel();
        boolean isAssigned = hasSelection && ((ParameterMapPageParameter)((DefaultListModel)model).get(selectedIndex)).isAssigned();
        this.assignParamButton.setEnabled(hasSelection);
        this.clearParamButton.setEnabled(hasSelection && isAssigned);
        this.editParamButton.setEnabled(hasSelection && isAssigned);
        this.moveParamUpButton.setEnabled(hasSelection && selectedIndex > 0);
        this.moveParamDownButton.setEnabled(hasSelection && selectedIndex < ((DefaultListModel)model).getSize() - 1);
    }

    private void addParamPage() {
        ListModel model = this.pagesListBox.getModel();
        int size = ((DefaultListModel)model).getSize();
        ((DefaultListModel)model).addElement(new ParameterMapPage("Page " + (size + 1)));
        this.pagesListBox.setSelectedIndex(size);
    }

    private void removeParamPage() {
        int selectedIndex = this.pagesListBox.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        ListModel model = this.pagesListBox.getModel();
        ((DefaultListModel)model).remove(selectedIndex);
        if (((DefaultListModel)model).isEmpty()) {
            return;
        }
        selectedIndex = Math.min(selectedIndex, ((DefaultListModel)model).getSize() - 1);
        this.pagesListBox.setSelectedIndex(selectedIndex);
    }

    private void editParamPage() {
        ParameterMapPage page = (ParameterMapPage)this.pagesListBox.getSelectedValue();
        if (page == null) {
            return;
        }
        String result = JOptionPane.showInputDialog("Page Name:", (Object)page.getName());
        if (result == null || result.isBlank()) {
            return;
        }
        page.setName(result);
        this.pagesListBox.updateUI();
    }

    private void moveParamPageDown() {
        int selectedIndex = this.pagesListBox.getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex < ((DefaultListModel)this.pagesListBox.getModel()).getSize() - 1) {
            this.swapParamPage(selectedIndex, selectedIndex + 1);
        }
    }

    private void moveParamPageUp() {
        int selectedIndex = this.pagesListBox.getSelectedIndex();
        if (selectedIndex > 0) {
            this.swapParamPage(selectedIndex, selectedIndex - 1);
        }
    }

    private void swapParamPage(int selectedIndex, int destinationIndex) {
        ListModel model = this.pagesListBox.getModel();
        ParameterMapPage page1 = (ParameterMapPage)((DefaultListModel)model).get(selectedIndex);
        ParameterMapPage page2 = (ParameterMapPage)((DefaultListModel)model).get(destinationIndex);
        ((DefaultListModel)model).set(selectedIndex, page2);
        ((DefaultListModel)model).set(destinationIndex, page1);
        this.pagesListBox.setSelectedIndex(destinationIndex);
    }

    private void assignParam() {
        ParameterImpl selectedParameter = (ParameterImpl)this.parametersListBox.getSelectedValue();
        ParameterMapPageParameter selectedValue = (ParameterMapPageParameter)this.pageParametersListBox.getSelectedValue();
        if (selectedParameter == null || selectedValue == null) {
            return;
        }
        selectedValue.assign(selectedParameter.getPosition(), selectedParameter.getName());
        this.pageParametersListBox.repaint();
        this.updateParameterListButtons();
    }

    private void clearParam() {
        ParameterMapPageParameter selectedValue = (ParameterMapPageParameter)this.pageParametersListBox.getSelectedValue();
        if (selectedValue == null) {
            return;
        }
        selectedValue.assign(-1, "");
        this.pageParametersListBox.repaint();
        this.updateParameterListButtons();
    }

    private void editParam() {
        ParameterMapPageParameter selectedParam = (ParameterMapPageParameter)this.pageParametersListBox.getSelectedValue();
        if (selectedParam == null) {
            return;
        }
        String result = JOptionPane.showInputDialog("Parameter Name:", (Object)selectedParam.getName());
        if (result == null) {
            return;
        }
        selectedParam.setName(result);
        this.pageParametersListBox.updateUI();
    }

    private void moveParamDown() {
        int selectedIndex = this.pageParametersListBox.getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex < ((DefaultListModel)this.pageParametersListBox.getModel()).getSize() - 1) {
            this.swapParam(selectedIndex, selectedIndex + 1);
        }
    }

    private void moveParamUp() {
        int selectedIndex = this.pageParametersListBox.getSelectedIndex();
        if (selectedIndex > 0) {
            this.swapParam(selectedIndex, selectedIndex - 1);
        }
    }

    protected void swapParam(int selectedIndex, int destinationIndex) {
        int selectedPage = this.pagesListBox.getSelectedIndex();
        if (selectedPage < 0) {
            return;
        }
        ParameterMapPage parameterMapPage = (ParameterMapPage)((DefaultListModel)this.pagesListBox.getModel()).get(selectedPage);
        parameterMapPage.swapParameters(selectedIndex, destinationIndex);
        ListModel model = this.pageParametersListBox.getModel();
        ParameterMapPageParameter param1 = (ParameterMapPageParameter)((DefaultListModel)model).get(selectedIndex);
        ParameterMapPageParameter param2 = (ParameterMapPageParameter)((DefaultListModel)model).get(destinationIndex);
        ((DefaultListModel)model).set(selectedIndex, param2);
        ((DefaultListModel)model).set(destinationIndex, param1);
        this.pageParametersListBox.setSelectedIndex(destinationIndex);
    }

    private void clearSearchField() {
        this.searchField.setText("");
        this.searchField.requestFocus();
    }

    private void searchParam(Position.Bias direction) {
        int nextIndex;
        if (((DefaultListModel)this.parametersListBox.getModel()).getSize() == 0) {
            return;
        }
        String searchText = this.searchField.getText();
        if (searchText.isBlank()) {
            return;
        }
        int index = this.parametersListBox.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        if ((nextIndex = Functions.getNextMatch(this.parametersListBox, searchText, index, direction)) >= 0) {
            this.parametersListBox.setSelectedIndex(nextIndex);
        }
    }

    private static List<ParameterImpl> getParameters(ParameterBankImpl parameterBank) {
        int count = parameterBank.getUnpagedItemCount();
        ArrayList<ParameterImpl> params = new ArrayList<ParameterImpl>(count);
        for (int i = 0; i < count; ++i) {
            params.add((ParameterImpl)parameterBank.getUnpagedItem(i));
        }
        return params;
    }
}

