/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui;

import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.hardware.IHwLight;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.reaper.framework.graphics.GraphicsContextImpl;
import de.mossgrabers.reaper.framework.hardware.HwSurfaceFactoryImpl;
import de.mossgrabers.reaper.framework.hardware.IReaperHwControl;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SimulatorWindow
extends JFrame {
    private static final long serialVersionUID = 683494997839264599L;
    private final transient HwSurfaceFactoryImpl surfaceFactory;
    private final transient IControlSurface<?> surface;
    private double scaleFactor = -1.0;

    public SimulatorWindow(IControlSurface<?> surface, String title, final boolean enableAntialias) {
        super(title);
        URL resource = this.getClass().getResource("/images/AppIcon.gif");
        Image image = Toolkit.getDefaultToolkit().getImage(resource);
        if (image != null) {
            this.setIconImage(image);
        }
        this.surface = surface;
        this.surfaceFactory = (HwSurfaceFactoryImpl)this.surface.getSurfaceFactory();
        JPanel canvas = new JPanel(){
            private static final long serialVersionUID = 6138483938641840923L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                SimulatorWindow.this.render(new GraphicsContextImpl((Graphics2D)g, "Monospaced", enableAntialias));
            }
        };
        this.getContentPane().add(canvas);
        this.pack();
        this.setSize(this.getSimulatorSize());
        this.getRootPane().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SimulatorWindow.this.scaleFactor = -1.0;
                SimulatorWindow.this.repaint();
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SimulatorWindow.this.handleMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SimulatorWindow.this.handleMouseEvent(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                SimulatorWindow.this.handleMouseEvent(e);
            }
        };
        canvas.addMouseListener(mouseListener);
        canvas.addMouseMotionListener(mouseListener);
    }

    private void handleMouseEvent(MouseEvent event) {
        this.surfaceFactory.getControls().forEach(control -> control.mouse(event.getID(), event.getX(), event.getY(), this.scaleFactor));
    }

    private void render(IGraphicsContext gc) {
        Dimension innerSize = this.getInnerSize();
        if (this.scaleFactor < 0.0) {
            this.scaleFactor = Math.min((double)innerSize.width / this.surfaceFactory.getWidth(), (double)innerSize.height / this.surfaceFactory.getHeight());
        }
        gc.fillRectangle(0.0, 0.0, innerSize.width, innerSize.height, ColorEx.GRAY);
        List<IReaperHwControl> controls = this.surfaceFactory.getControls();
        controls.forEach(control -> {
            if (control instanceof IHwLight) {
                control.draw(gc, this.scaleFactor);
            }
        });
        controls.forEach(control -> {
            if (!(control instanceof IHwLight)) {
                control.draw(gc, this.scaleFactor);
            }
        });
    }

    private Dimension getInnerSize() {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        if (insets != null) {
            size.height -= insets.top + insets.bottom;
            size.width -= insets.left + insets.right;
        }
        return size;
    }

    private Dimension getSimulatorSize() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode displayMode = gd.getDisplayMode();
        int screenHeight = displayMode.getHeight();
        int screenWidth = displayMode.getWidth();
        double ratio = this.surfaceFactory.getWidth() / this.surfaceFactory.getHeight();
        int height = (int)Math.round((double)screenHeight * 0.8);
        int width = (int)Math.round((double)height * ratio);
        if (width > screenWidth) {
            width = (int)Math.round((double)screenWidth * 0.8);
            height = (int)Math.round((double)width / ratio);
        }
        return new Dimension(width, height);
    }
}

