/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.midi;

import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.reaper.communication.MessageSender;
import de.mossgrabers.reaper.framework.midi.MidiConnection;
import de.mossgrabers.reaper.framework.midi.MidiInputImpl;
import de.mossgrabers.reaper.framework.midi.MidiOutputImpl;
import de.mossgrabers.reaper.ui.utils.LogModel;
import javax.sound.midi.MidiDevice;

public class MidiAccessImpl
implements IMidiAccess {
    private final IHost host;
    private final MessageSender sender;
    private final MidiConnection[] midiConnections;
    private final MidiDevice[] inputs;
    private final MidiDevice[] outputs;

    public MidiAccessImpl(LogModel logModel, IHost host, MessageSender sender, MidiDevice[] inputs, MidiDevice[] outputs) {
        this.host = host;
        this.sender = sender;
        this.inputs = inputs;
        this.outputs = outputs;
        int midiConnectionSize = Math.max(inputs.length, outputs.length);
        this.midiConnections = new MidiConnection[midiConnectionSize];
        for (int i = 0; i < midiConnectionSize; ++i) {
            this.midiConnections[i] = new MidiConnection(logModel);
        }
    }

    public void cleanup() {
        for (MidiConnection midiConnection : this.midiConnections) {
            midiConnection.cleanup();
        }
    }

    @Override
    public IMidiOutput createOutput() {
        return this.createOutput(0);
    }

    @Override
    public IMidiOutput createOutput(int index) {
        this.midiConnections[index].setOutput(this.outputs[index]);
        return new MidiOutputImpl(this.midiConnections[index]);
    }

    @Override
    public IMidiInput createInput(String name, String ... filters) {
        return this.createInput(0, name, filters);
    }

    @Override
    public IMidiInput createInput(int index, String name, String ... filters) {
        return new MidiInputImpl(this.host, this.sender, this.midiConnections[index], this.inputs[index], filters);
    }
}

