/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.midi;

import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.reaper.framework.midi.RenamedMidiDevice;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceProvider;

public class Midi {
    private static final String CORE_MIDI4J = "CoreMIDI4J - ";
    private static final Map<String, MidiDevice> INPUTS = new TreeMap<String, MidiDevice>();
    private static final Map<String, MidiDevice> OUTPUTS = new TreeMap<String, MidiDevice>();

    private Midi() {
    }

    public static void readDeviceMetadata() throws MidiUnavailableException {
        MidiDevice.Info[] midiDeviceInfo;
        INPUTS.clear();
        OUTPUTS.clear();
        try {
            midiDeviceInfo = CoreMidiDeviceProvider.getMidiDeviceInfo();
        }
        catch (NoClassDefFoundError error) {
            midiDeviceInfo = MidiSystem.getMidiDeviceInfo();
        }
        TreeMap<CallSite, Integer> keyedNames = new TreeMap<CallSite, Integer>();
        for (MidiDevice.Info info : midiDeviceInfo) {
            boolean isOutput;
            MidiDevice device = MidiSystem.getMidiDevice(info);
            boolean isInput = device.getMaxTransmitters() != 0;
            boolean bl = isOutput = device.getMaxReceivers() != 0;
            if (!isInput && !isOutput) continue;
            String name = Midi.updateName(info.getName());
            String key = (isInput ? "I" : "O") + name;
            Integer count = (Integer)keyedNames.get(key);
            Integer newCount = count == null ? 1 : count + 1;
            keyedNames.put((CallSite)((Object)key), newCount);
            if (count != null) {
                name = String.format("%s (%d)", name, newCount);
            }
            device = new RenamedMidiDevice(name, device);
            if (isOutput) {
                OUTPUTS.put(name, device);
                continue;
            }
            INPUTS.put(name, device);
        }
    }

    public static Collection<MidiDevice> getOutputDevices() {
        return OUTPUTS.values();
    }

    public static Collection<MidiDevice> getInputDevices() {
        return INPUTS.values();
    }

    public static MidiDevice getOutputDevice(String name) {
        return OUTPUTS.get(name);
    }

    public static MidiDevice getInputDevice(String name) {
        return INPUTS.get(name);
    }

    private static String updateName(String name) {
        if (OperatingSystem.isMacOS() && name.startsWith(CORE_MIDI4J)) {
            return name.substring(CORE_MIDI4J.length());
        }
        return name;
    }
}

