/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.hardware;

import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwAbsoluteKnob;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.reaper.framework.daw.data.parameter.IParameterEx;
import de.mossgrabers.reaper.framework.graphics.GraphicsContextImpl;
import de.mossgrabers.reaper.framework.hardware.AbstractHwAbsoluteControl;
import de.mossgrabers.reaper.framework.hardware.Bounds;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;

public class HwAbsoluteKnobImpl
extends AbstractHwAbsoluteControl
implements IHwAbsoluteKnob {
    private double pressedX;
    private double pressedY;

    public HwAbsoluteKnobImpl(String id, IHost host, String label) {
        super(id, host, label);
    }

    @Override
    public void bindTouch(TriggerCommand command, IMidiInput input, BindType type, int channel, int control) {
    }

    @Override
    public void draw(IGraphicsContext gc, double scale) {
        Bounds bounds = this.layout.getBounds();
        if (bounds == null) {
            return;
        }
        double radius = Math.min(bounds.width(), bounds.height()) / 2.0;
        double centerX = (bounds.x() + radius) * scale;
        double centerY = (bounds.y() + radius) * scale;
        gc.fillCircle(centerX, centerY, radius, ColorEx.BLACK);
        int length = (int)Math.round((double)this.currentValue * 360.0 / 127.0);
        ((GraphicsContextImpl)gc).fillArc(centerX, centerY, radius, ColorEx.WHITE, 270 - length, length);
        gc.fillCircle(centerX, centerY, radius * 0.8, ColorEx.BLACK);
        IParameter iParameter = this.parameter;
        if (iParameter instanceof IParameterEx) {
            IParameterEx pi = (IParameterEx)iParameter;
            double paramValue = pi.getInternalValue();
            int l = (int)Math.round(paramValue * 360.0);
            ((GraphicsContextImpl)gc).fillArc(centerX, centerY, radius, ColorEx.RED, 270 - l - 5, 10);
        }
    }

    @Override
    public void mouse(int mouseEvent, double x, double y, double scale) {
        if (this.inputImpl == null) {
            return;
        }
        try {
            Bounds bounds = this.layout.getBounds();
            if (bounds == null) {
                return;
            }
            double scaleX = x / scale;
            double scaleY = y / scale;
            if (mouseEvent == 501 && bounds.contains(scaleX, scaleY)) {
                this.isPressed = true;
                this.pressedX = scaleX;
                this.pressedY = scaleY;
                return;
            }
            if (!this.isPressed) {
                return;
            }
            if (mouseEvent == 502) {
                this.isPressed = false;
                return;
            }
            if (mouseEvent == 506) {
                double offset = Math.min(3.0, Math.max(-3.0, this.pressedX - scaleX + (this.pressedY - scaleY)));
                this.pressedX = scaleX;
                this.pressedY = scaleY;
                if (this.type == BindType.CC) {
                    this.currentValue = (int)Math.max(0.0, Math.min(127.0, (double)this.currentValue + offset));
                    this.inputImpl.handleMidiMessage(new ShortMessage(176, this.channel, this.control, this.currentValue));
                }
            }
        }
        catch (InvalidMidiDataException ex) {
            this.host.error("Invalid MIDI message.", ex);
        }
    }
}

