/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.hardware;

import de.mossgrabers.framework.controller.hardware.AbstractHwContinuousControl;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwAbsoluteControl;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.reaper.framework.hardware.HwControlLayout;
import de.mossgrabers.reaper.framework.hardware.IReaperHwControl;
import de.mossgrabers.reaper.framework.midi.MidiInputImpl;

public abstract class AbstractHwAbsoluteControl
extends AbstractHwContinuousControl
implements IHwAbsoluteControl,
IReaperHwControl {
    protected final HwControlLayout layout;
    protected MidiInputImpl inputImpl;
    protected int control;
    protected IParameter parameter;
    protected boolean isPressed;
    protected int currentValue = 0;

    protected AbstractHwAbsoluteControl(String id, IHost host, String label) {
        super(host, label);
        this.layout = new HwControlLayout(id);
    }

    @Override
    public boolean isBound() {
        return this.parameter != null || super.isBound();
    }

    @Override
    public void bind(IParameter parameter) {
        this.parameter = parameter;
    }

    @Override
    public void bind(IMidiInput input, BindType type, int channel, int control) {
        this.inputImpl = (MidiInputImpl)input;
        this.type = type;
        this.channel = channel;
        this.control = control;
        input.bind(this, type, channel, control);
    }

    @Override
    public void unbind() {
        if (this.input != null) {
            this.input.unbind(this);
        }
    }

    @Override
    public void rebind() {
        if (this.input != null) {
            this.input.bind(this, this.type, this.channel, this.control);
        }
    }

    @Override
    public void handleValue(double value) {
        if (this.parameter != null) {
            this.parameter.setNormalizedValue(value);
        } else if (this.command != null) {
            this.command.execute((int)Math.round(value * 127.0));
        } else if (this.pitchbendCommand != null) {
            double v = value * 16383.0;
            int data1 = (int)Math.min(127L, Math.round(v % 128.0));
            int data2 = (int)Math.min(127L, Math.round(v / 128.0));
            this.pitchbendCommand.onPitchbend(data1, data2);
        }
    }

    @Override
    public void setBounds(double x, double y, double width, double height) {
        this.layout.setBounds(x, y, width, height);
    }

    @Override
    public void disableTakeOver() {
    }

    @Override
    public void setIndexInGroup(int index) {
    }
}

