/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.graphics;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IImage;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.reaper.framework.graphics.SVGImage;
import de.mossgrabers.reaper.ui.utils.FontCache;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;

public class GraphicsContextImpl
implements IGraphicsContext {
    private final FontCache fontCache;
    private final Graphics2D gc;

    public GraphicsContextImpl(Graphics2D gc, String fontFamily, boolean enableAntialias) {
        GraphicsContextImpl.configureGraphics(gc, enableAntialias);
        this.gc = gc;
        this.fontCache = new FontCache(fontFamily);
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2, ColorEx color) {
        this.setColor(color);
        this.gc.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
    }

    @Override
    public void fillRectangle(double x, double y, double width, double height, ColorEx color) {
        this.setColor(color);
        this.gc.fillRect((int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void strokeRectangle(double left, double top, double width, double height, ColorEx color) {
        this.strokeRectangle(left, top, width, height, color, 1.0);
    }

    @Override
    public void strokeRectangle(double left, double top, double width, double height, ColorEx color, double lineWidth) {
        Stroke oldStroke = this.gc.getStroke();
        this.setColor(color);
        this.gc.setStroke(new BasicStroke((float)lineWidth));
        this.gc.drawRect((int)left, (int)top, (int)width, (int)height);
        this.gc.setStroke(oldStroke);
    }

    @Override
    public void fillRoundedRectangle(double left, double top, double width, double height, double radius, ColorEx fillColor) {
        this.setColor(fillColor);
        int arcHeight = (int)(radius * 2.5);
        this.gc.fillRoundRect((int)left, (int)top, (int)width, (int)height, arcHeight, arcHeight);
    }

    @Override
    public void fillGradientRoundedRectangle(double left, double top, double width, double height, double radius, ColorEx color1, ColorEx color2) {
        Paint oldPaint = this.gc.getPaint();
        this.gc.setPaint(new GradientPaint((int)left, (int)(top + 1.0), GraphicsContextImpl.convertColor(color1), (int)left, (int)(top + height), GraphicsContextImpl.convertColor(color2)));
        int arcHeight = (int)(radius * 2.5);
        this.gc.fillRoundRect((int)left, (int)top, (int)width, (int)height, arcHeight, arcHeight);
        this.gc.setPaint(oldPaint);
    }

    @Override
    public void strokeTriangle(double x1, double y1, double x2, double y2, double x3, double y3, ColorEx lineColor) {
        this.setColor(lineColor);
        this.gc.drawPolygon(new int[]{(int)x1, (int)x2, (int)x3}, new int[]{(int)y1, (int)y2, (int)y3}, 3);
    }

    @Override
    public void fillTriangle(double x1, double y1, double x2, double y2, double x3, double y3, ColorEx lineColor) {
        this.setColor(lineColor);
        this.gc.fillPolygon(new int[]{(int)x1, (int)x2, (int)x3}, new int[]{(int)y1, (int)y2, (int)y3}, 3);
    }

    @Override
    public void fillCircle(double x, double y, double radius, ColorEx fillColor) {
        this.setColor(fillColor);
        int size = (int)(2.0 * radius);
        this.gc.fillOval((int)(x - radius), (int)(y - radius), size, size);
    }

    public void fillArc(double x, double y, double radius, ColorEx fillColor, int startAngle, int arcAngle) {
        this.setColor(fillColor);
        int size = (int)(2.0 * radius);
        this.gc.fillArc((int)(x - radius), (int)(y - radius), size, size, startAngle, arcAngle);
    }

    @Override
    public void drawTextInBounds(String text, double x, double y, double width, double height, Align alignment, ColorEx color, double fontSize) {
        this.drawTextInBounds(text, x, y, width, height, alignment, color, null, fontSize);
    }

    @Override
    public void drawTextInBounds(String text, double x, double y, double width, double height, Align alignment, ColorEx color, ColorEx backgroundColor, double fontSize) {
        if (text == null || text.length() == 0) {
            return;
        }
        String txt = StringUtils.fixFontCharacters(text);
        this.gc.setFont(this.fontCache.getFont((int)fontSize));
        Dimension dim = this.getTextDims(txt);
        this.gc.clipRect((int)x, (int)y, (int)width, (int)height);
        int posX = switch (alignment) {
            case Align.LEFT -> (int)x;
            default -> (int)(x + (width - (double)dim.width) / 2.0);
        };
        double textDescent = this.getTextDescent(txt);
        int posY = (int)(y + height - (height - (double)dim.height) / 2.0 - textDescent);
        if (backgroundColor != null) {
            double inset = 12.0;
            this.fillRoundedRectangle((double)posX - 12.0, (double)(posY - dim.height) - 12.0 + textDescent, (double)dim.width + 24.0, (double)dim.height + 24.0, 12.0, backgroundColor);
        }
        this.setColor(color);
        this.gc.drawString(txt, posX, posY);
        this.gc.setClip(null);
    }

    @Override
    public void drawTextInHeight(String text, double x, double y, double height, ColorEx color, double fontSize) {
        this.drawTextInHeight(text, x, y, height, color, null, fontSize);
    }

    @Override
    public void drawTextInHeight(String text, double x, double y, double height, ColorEx color, ColorEx backgroundColor, double fontSize) {
        if (text == null || text.length() == 0) {
            return;
        }
        String txt = StringUtils.fixFontCharacters(text);
        this.gc.setFont(this.fontCache.getFont((int)fontSize));
        Dimension dim = this.getTextDims(txt);
        double textDescent = this.getTextDescent(txt);
        int posY = (int)(y + height - (height - (double)dim.height) / 2.0 - textDescent);
        if (backgroundColor != null) {
            double inset = 12.0;
            this.fillRoundedRectangle(x - 12.0, (double)(posY - dim.height) - 12.0 + textDescent, (double)dim.width + 24.0, (double)dim.height + 24.0, 12.0, backgroundColor);
        }
        this.setColor(color);
        this.gc.drawString(txt, (int)x, (int)(y + height - (height - (double)dim.height) / 2.0 - (double)this.getTextDescent("Hg")));
    }

    @Override
    public void drawImage(IImage image, double x, double y) {
        this.gc.drawImage((Image)((SVGImage)image).getImage(), (int)x, (int)y, null);
    }

    @Override
    public void maskImage(IImage image, double x, double y, ColorEx maskColor) {
        SVGImage svgImage = SVGImage.getSVGImage(((SVGImage)image).getImageName(), GraphicsContextImpl.convertColor(maskColor));
        this.gc.drawImage((Image)svgImage.getImage(), (int)x, (int)y, null);
    }

    @Override
    public double calculateFontSize(String text, double maxHeight, double maxWidth, double minimumFontSize) {
        double fittingSize = minimumFontSize;
        for (double size = minimumFontSize; size < maxHeight; size += 1.0) {
            this.gc.setFont(this.fontCache.getFont((int)size));
            Dimension textDims = this.getTextDims(text);
            double width = textDims.getWidth();
            if (width > maxWidth) break;
            fittingSize = size;
        }
        return fittingSize;
    }

    private static void configureGraphics(Graphics2D gc, boolean enableAntialias) {
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, enableAntialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        gc.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        gc.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public Dimension getTextDims(String text) {
        FontMetrics fm = this.gc.getFontMetrics();
        Rectangle2D bounds = fm.getStringBounds(text, this.gc);
        LineMetrics lm = fm.getFont().getLineMetrics(text, this.gc.getFontRenderContext());
        double width = bounds.getWidth();
        bounds.setRect(bounds.getX(), bounds.getY(), width, lm.getHeight());
        return new Dimension((int)Math.round(width), (int)Math.round(bounds.getHeight()));
    }

    public int getTextDescent(String text) {
        return Math.round(this.gc.getFont().getLineMetrics(text, this.gc.getFontRenderContext()).getDescent());
    }

    public Graphics2D getGraphics() {
        return this.gc;
    }

    protected void setColor(ColorEx color) {
        this.gc.setColor(GraphicsContextImpl.convertColor(color));
    }

    private static Color convertColor(ColorEx color) {
        return new Color((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue());
    }
}

