/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.parameter;

import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.parameter.ParameterImpl;

public class PanoramaParameterImpl
extends ParameterImpl {
    private static final Object PANORAMA_UPDATE_LOCK = new Object();

    public PanoramaParameterImpl(DataSetupEx dataSetup, int index, double defaultValue) {
        super(dataSetup, index, defaultValue);
        this.setInternalName("Pan");
    }

    @Override
    public void touchValue(boolean isBeingTouched) {
        this.sender.processIntArg(Processor.TRACK, this.createCommand("pan/touch"), isBeingTouched ? 1 : 0);
        super.touchValue(isBeingTouched);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendValue() {
        Object object = PANORAMA_UPDATE_LOCK;
        synchronized (object) {
            if (this.isAutomationRecActive()) {
                this.sender.delayUpdates(Processor.TRACK);
            }
            this.sender.processDoubleArg(Processor.TRACK, this.createCommand("pan"), this.value);
        }
    }

    @Override
    protected String createCommand(String command) {
        return this.getIndex() + "/" + command;
    }
}

