/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.bank;

import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.daw.data.empty.EmptyParameterBank;
import de.mossgrabers.framework.observer.IBankPageObserver;
import de.mossgrabers.framework.observer.IItemSelectionObserver;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.reaper.framework.daw.data.CursorTrackImpl;
import de.mossgrabers.reaper.framework.daw.data.TrackImpl;
import java.util.List;
import java.util.Optional;

public class ParameterBankDelegator
implements IParameterBank {
    private final CursorTrackImpl cursorTrack;
    private final int numPageSize;

    public ParameterBankDelegator(CursorTrackImpl cursorTrack, int numPageSize) {
        this.cursorTrack = cursorTrack;
        this.numPageSize = numPageSize;
    }

    @Override
    public int getPageSize() {
        return this.getBank().getPageSize();
    }

    @Override
    public int getItemCount() {
        return this.getBank().getItemCount();
    }

    @Override
    public boolean hasExistingItems() {
        return this.getBank().hasExistingItems();
    }

    @Override
    public IParameter getItem(int index) {
        return (IParameter)this.getBank().getItem(index);
    }

    @Override
    public Optional<IParameter> getSelectedItem() {
        return this.getBank().getSelectedItem();
    }

    @Override
    public List<IParameter> getSelectedItems() {
        return this.getBank().getSelectedItems();
    }

    @Override
    public void addSelectionObserver(IItemSelectionObserver observer) {
        this.getBank().addSelectionObserver(observer);
    }

    @Override
    public void removeSelectionObserver(IItemSelectionObserver observer) {
        this.getBank().removeSelectionObserver(observer);
    }

    @Override
    public void addPageObserver(IBankPageObserver observer) {
        this.getBank().addPageObserver(observer);
    }

    @Override
    public void removePageObserver(IBankPageObserver observer) {
        this.getBank().removePageObserver(observer);
    }

    @Override
    public boolean canScrollBackwards() {
        return this.getBank().canScrollBackwards();
    }

    @Override
    public boolean canScrollForwards() {
        return this.getBank().canScrollForwards();
    }

    @Override
    public boolean canScrollPageBackwards() {
        return this.getBank().canScrollPageBackwards();
    }

    @Override
    public boolean canScrollPageForwards() {
        return this.getBank().canScrollPageForwards();
    }

    @Override
    public void scrollBackwards() {
        this.getBank().scrollBackwards();
    }

    @Override
    public void scrollForwards() {
        this.getBank().scrollForwards();
    }

    @Override
    public void scrollTo(int position) {
        this.getBank().scrollTo(position);
    }

    @Override
    public void scrollTo(int position, boolean adjustPage) {
        this.getBank().scrollTo(position, adjustPage);
    }

    @Override
    public int getScrollPosition() {
        return this.getBank().getScrollPosition();
    }

    @Override
    public int getPositionOfLastItem() {
        return this.getBank().getPositionOfLastItem();
    }

    @Override
    public void selectItemAtPosition(int position) {
        this.getBank().selectItemAtPosition(position);
    }

    @Override
    public void selectNextItem() {
        this.getBank().selectNextItem();
    }

    @Override
    public void selectPreviousItem() {
        this.getBank().selectPreviousItem();
    }

    @Override
    public void selectNextPage() {
        this.getBank().selectNextPage();
    }

    @Override
    public void selectPreviousPage() {
        this.getBank().selectPreviousPage();
    }

    @Override
    public void setSkipDisabledItems(boolean shouldSkip) {
        this.getBank().setSkipDisabledItems(shouldSkip);
    }

    @Override
    public void enableObservers(boolean enable) {
        this.getBank().enableObservers(enable);
    }

    @Override
    public IParameterPageBank getPageBank() {
        return this.getBank().getPageBank();
    }

    private IParameterBank getBank() {
        TrackImpl selectedTrack = (TrackImpl)this.cursorTrack.getPinnedOrSelectedTrack();
        return selectedTrack == null ? EmptyParameterBank.getInstance(this.numPageSize) : selectedTrack.getParameterBank();
    }
}

