/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.observer.IItemSelectionObserver;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.TrackImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.TrackBankImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.MasterPanoramaParameterImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.MasterVolumeParameterImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.ParameterImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.UserParameterImpl;
import java.util.ArrayList;
import java.util.List;

public class MasterTrackImpl
extends TrackImpl
implements IMasterTrack {
    private final List<IItemSelectionObserver> observers = new ArrayList<IItemSelectionObserver>();
    private final UserParameterImpl crossfaderParameter;

    public MasterTrackImpl(DataSetupEx dataSetup, TrackBankImpl trackBank, int numSends, int numParams) {
        super(dataSetup, trackBank, 0, 1, numSends, 0, numParams, new MasterVolumeParameterImpl(dataSetup, 0.716), new MasterPanoramaParameterImpl(dataSetup, 0.5));
        this.crossfaderParameter = new UserParameterImpl(dataSetup, 0, null){

            @Override
            protected void sendValue() {
                MasterTrackImpl.this.sendPositionedItemOSC("user/param/0/value", this.value);
            }
        };
        this.setExists(true);
        this.setInternalName("Master");
        this.setType(ChannelType.MASTER);
    }

    @Override
    public void enableObservers(boolean enable) {
        this.sender.enableUpdates(Processor.MASTER, enable);
    }

    @Override
    public int getIndex() {
        return (this.trackBank.getItemCount() - 1) % this.trackBank.getPageSize();
    }

    @Override
    public void enter() {
    }

    @Override
    public void addSelectionObserver(IItemSelectionObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void setSelected(boolean isSelected) {
        super.setSelected(isSelected);
        for (IItemSelectionObserver observer : this.observers) {
            observer.call(-1, isSelected);
        }
    }

    @Override
    public void setIsActivated(boolean value) {
    }

    @Override
    public void toggleIsActivated() {
    }

    @Override
    public void setRecArm(boolean value) {
    }

    @Override
    public void setMonitor(boolean value) {
    }

    @Override
    public void toggleMonitor() {
    }

    @Override
    public void setAutoMonitor(boolean value) {
    }

    @Override
    public void toggleAutoMonitor() {
    }

    @Override
    protected Processor getProcessor() {
        return Processor.MASTER;
    }

    @Override
    protected String createCommand(String command) {
        return command;
    }

    public ParameterImpl getCrossfaderParameter() {
        return this.crossfaderParameter;
    }
}

