/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IDevice;
import de.mossgrabers.framework.daw.data.bank.IDeviceBank;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.SpecificDeviceImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.DeviceBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.ParameterBankImpl;

public class CursorDeviceImpl
extends SpecificDeviceImpl
implements ICursorDevice {
    private int deviceCount = 0;
    private final IDeviceBank deviceBank;

    public CursorDeviceImpl(DataSetupEx dataSetup, int numSends, int numParams, int numDevicesInBank, int numDeviceLayers, int numDrumPadLayers) {
        super(dataSetup, numSends, numParams, numDevicesInBank, numDeviceLayers, numDrumPadLayers);
        int checkedNumDevices = numDevicesInBank >= 0 ? numDevicesInBank : 8;
        this.deviceBank = new DeviceBankImpl(dataSetup, checkedNumDevices);
    }

    @Override
    public int getIndex() {
        return this.getPosition() % this.deviceBank.getPageSize();
    }

    @Override
    public IDeviceBank getDeviceBank() {
        return this.deviceBank;
    }

    public void setDeviceCount(int deviceCount) {
        this.deviceCount = deviceCount;
        ((DeviceBankImpl)this.getDeviceBank()).setItemCount(deviceCount);
    }

    @Override
    public boolean canSelectPrevious() {
        return this.getPosition() > 0;
    }

    @Override
    public boolean canSelectNext() {
        return this.getPosition() < this.deviceCount - 1;
    }

    @Override
    public boolean isPinned() {
        return true;
    }

    @Override
    public void togglePinned() {
    }

    @Override
    public void setPinned(boolean isPinned) {
    }

    @Override
    public void selectPrevious() {
        if (!this.canSelectPrevious()) {
            return;
        }
        int index = this.getIndex();
        if (index > 0) {
            this.setName(((IDevice)this.deviceBank.getItem(index - 1)).getName());
        }
        this.sender.processNoArg(Processor.DEVICE, "-");
    }

    @Override
    public void selectNext() {
        if (!this.canSelectNext()) {
            return;
        }
        int index = this.getIndex();
        if (index < this.deviceBank.getPageSize() - 1) {
            IDevice item = (IDevice)this.deviceBank.getItem(index + 1);
            this.setName(item.getName());
        }
        this.sender.processNoArg(Processor.DEVICE, "+");
    }

    @Override
    public void selectParent() {
    }

    @Override
    public void selectChannel() {
    }

    @Override
    public void swapWithPrevious() {
        this.sendDeviceOSC("movePrev");
        ((IDevice)this.deviceBank.getItem(Math.max(0, this.getIndex() - 1))).select();
    }

    @Override
    public void swapWithNext() {
        this.sendDeviceOSC("moveNext");
        ((IDevice)this.deviceBank.getItem(Math.min(this.deviceBank.getPageSize() - 1, this.getIndex() + 1))).select();
    }

    @Override
    public String[] getSlotChains() {
        return new String[0];
    }

    @Override
    public void selectSlotChain(String slotChainName) {
    }

    public void refreshParameterMapping() {
        ((ParameterBankImpl)this.getParameterBank()).refreshParameterCache();
    }
}

