/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.reaper.AppCallback;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.utils.SafeRunLater;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class NotificationWindow {
    private static final int TIMEOUT = 2;
    private final AtomicInteger counter = new AtomicInteger();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final AppCallback callback;
    private final JFrame popupStage = new JFrame();
    private final JLabel label = new JLabel("");

    public NotificationWindow(LogModel logModel, AppCallback callback) {
        this.callback = callback;
        this.popupStage.setTitle("Notification");
        this.popupStage.setAlwaysOnTop(true);
        this.popupStage.setUndecorated(true);
        this.popupStage.setResizable(false);
        this.popupStage.setMinimumSize(new Dimension(800, 80));
        this.label.setFont(this.label.getFont().deriveFont(40.0f));
        JPanel root = new JPanel(new BorderLayout());
        root.setBorder(new EmptyBorder(14, 14, 14, 14));
        root.add((Component)this.label, "Center");
        this.popupStage.setContentPane(root);
        this.executor.scheduleAtFixedRate(() -> {
            int c = this.counter.get();
            if (c <= 0) {
                return;
            }
            if (this.counter.decrementAndGet() == 0) {
                SafeRunLater.execute(logModel, () -> this.popupStage.setVisible(false));
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public void shutdown() {
        this.executor.shutdown();
        if (this.popupStage.isShowing()) {
            this.popupStage.setVisible(false);
        }
    }

    public void displayMessage(String message) {
        if (this.executor.isShutdown() || !this.callback.getPopupWindowNotification()) {
            return;
        }
        this.counter.set(2);
        this.label.setText(message);
        Dimension preferredSize = this.label.getPreferredSize();
        preferredSize.width += 28;
        preferredSize.height += 28;
        this.popupStage.setMinimumSize(preferredSize);
        this.popupStage.setMaximumSize(preferredSize);
        this.popupStage.setPreferredSize(preferredSize);
        this.popupStage.setSize(preferredSize);
        this.popupStage.validate();
        this.popupStage.revalidate();
        if (this.popupStage.isShowing()) {
            return;
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.popupStage.setLocation(dim.width / 2 - preferredSize.width / 2, dim.height / 2 - preferredSize.height / 2);
        this.popupStage.setVisible(true);
    }
}

