/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.controller.hardware.IHwSurfaceFactory;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IMemoryBlock;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.data.IDeviceMetadata;
import de.mossgrabers.framework.graphics.IBitmap;
import de.mossgrabers.framework.graphics.IImage;
import de.mossgrabers.framework.osc.IOpenSoundControlCallback;
import de.mossgrabers.framework.osc.IOpenSoundControlClient;
import de.mossgrabers.framework.osc.IOpenSoundControlMessage;
import de.mossgrabers.framework.osc.IOpenSoundControlServer;
import de.mossgrabers.framework.parameter.NoteAttribute;
import de.mossgrabers.framework.usb.IUsbDevice;
import de.mossgrabers.framework.usb.UsbException;
import de.mossgrabers.framework.usb.UsbMatcher;
import de.mossgrabers.reaper.controller.IControllerInstance;
import de.mossgrabers.reaper.framework.daw.MemoryBlockImpl;
import de.mossgrabers.reaper.framework.daw.NotificationWindow;
import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.graphics.BitmapImpl;
import de.mossgrabers.reaper.framework.graphics.SVGImage;
import de.mossgrabers.reaper.framework.hardware.HwSurfaceFactoryImpl;
import de.mossgrabers.reaper.framework.osc.OpenSoundControlClientImpl;
import de.mossgrabers.reaper.framework.osc.OpenSoundControlMessageImpl;
import de.mossgrabers.reaper.framework.osc.OpenSoundControlServerImpl;
import de.mossgrabers.reaper.framework.usb.UsbDeviceImpl;
import de.mossgrabers.reaper.ui.WindowManager;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.utils.SafeRunLater;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class HostImpl
implements IHost {
    private static final Set<Capability> CAPABILITIES = new HashSet<Capability>();
    private static final Set<NoteAttribute> NOTE_ATTRIBUTES = EnumSet.of(NoteAttribute.PITCH, NoteAttribute.DURATION, NoteAttribute.MUTE, NoteAttribute.VELOCITY);
    private final WindowManager windowManager;
    private final LogModel logModel;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(10);
    private final List<UsbMatcher> usbDeviceInfos = new ArrayList<UsbMatcher>();
    private final List<IUsbDevice> usbDevices = new ArrayList<IUsbDevice>();
    private final List<OpenSoundControlClientImpl> oscSenders = new ArrayList<OpenSoundControlClientImpl>();
    private final List<OpenSoundControlServerImpl> oscReceivers = new ArrayList<OpenSoundControlServerImpl>();
    private final NotificationWindow notificationWindow;
    private final IControllerInstance controllerInstance;

    public HostImpl(LogModel logModel, WindowManager windowManager, IControllerInstance controllerInstance) {
        this.logModel = logModel;
        this.windowManager = windowManager;
        this.controllerInstance = controllerInstance;
        this.notificationWindow = new NotificationWindow(logModel, windowManager.getMainFrame().getCallback());
    }

    public void shutdown() {
        this.executor.shutdown();
        this.notificationWindow.shutdown();
    }

    @Override
    public String getName() {
        return "Reaper";
    }

    @Override
    public void restart() {
        this.controllerInstance.restart();
    }

    @Override
    public boolean supports(Capability capability) {
        return CAPABILITIES.contains((Object)capability);
    }

    @Override
    public boolean supports(NoteAttribute noteAttribute) {
        return NOTE_ATTRIBUTES.contains((Object)noteAttribute);
    }

    @Override
    public void scheduleTask(Runnable task, long delay) {
        try {
            if (!this.executor.isShutdown()) {
                this.executor.schedule(task, delay, TimeUnit.MILLISECONDS);
            }
        }
        catch (RejectedExecutionException ex) {
            this.error("Could not delay thread.", ex);
        }
    }

    @Override
    public void error(String text) {
        this.logModel.info(text);
    }

    @Override
    public void error(String text, Throwable ex) {
        this.logModel.error(text, ex);
    }

    @Override
    public void println(String text) {
        this.logModel.info(text);
    }

    @Override
    public void showNotification(String message) {
        SafeRunLater.execute(this.logModel, () -> this.notificationWindow.displayMessage(message));
    }

    @Override
    public IImage loadSVG(String imageName, int scale) {
        String filename = "/images/" + imageName;
        return SVGImage.getSVGImage(filename, Color.BLACK);
    }

    @Override
    public IBitmap createBitmap(int width, int height) {
        return new BitmapImpl(this.windowManager, width, height);
    }

    @Override
    public IMemoryBlock createMemoryBlock(int size) {
        return new MemoryBlockImpl(size);
    }

    @Override
    public IUsbDevice getUsbDevice(int index) throws UsbException {
        UsbDeviceImpl usbDevice = new UsbDeviceImpl(this, this.usbDeviceInfos.get(index));
        this.usbDevices.add(usbDevice);
        return usbDevice;
    }

    @Override
    public void releaseUsbDevices() {
        for (IUsbDevice usbDevice : this.usbDevices) {
            usbDevice.release();
        }
        this.usbDevices.clear();
    }

    public void addUSBDeviceInfo(UsbMatcher matcher) {
        this.usbDeviceInfos.add(matcher);
    }

    @Override
    public IOpenSoundControlClient connectToOSCServer(String serverAddress, int serverPort) {
        OpenSoundControlClientImpl client = new OpenSoundControlClientImpl(this, serverAddress, serverPort);
        this.oscSenders.add(client);
        return client;
    }

    @Override
    public IOpenSoundControlServer createOSCServer(IOpenSoundControlCallback callback) {
        OpenSoundControlServerImpl server = new OpenSoundControlServerImpl(callback, this.logModel);
        this.oscReceivers.add(server);
        return server;
    }

    @Override
    public IOpenSoundControlMessage createOSCMessage(String address, List<?> values) {
        return new OpenSoundControlMessageImpl(address, values);
    }

    @Override
    public void releaseOSC() {
        for (OpenSoundControlServerImpl receiver : this.oscReceivers) {
            receiver.close();
        }
        for (OpenSoundControlClientImpl sender : this.oscSenders) {
            sender.close();
        }
    }

    @Override
    public IHwSurfaceFactory createSurfaceFactory(double width, double height) {
        HwSurfaceFactoryImpl surfaceFactory = new HwSurfaceFactoryImpl(this);
        surfaceFactory.setDimension(width, height);
        return surfaceFactory;
    }

    @Override
    public List<IDeviceMetadata> getInstrumentMetadata() {
        return new ArrayList<IDeviceMetadata>(DeviceManager.get().getInstruments());
    }

    @Override
    public List<IDeviceMetadata> getAudioEffectMetadata() {
        return new ArrayList<IDeviceMetadata>(DeviceManager.get().getEffects());
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    static {
        CAPABILITIES.add(Capability.NOTE_REPEAT_LENGTH);
        CAPABILITIES.add(Capability.NOTE_REPEAT_USE_PRESSURE_TO_VELOCITY);
        CAPABILITIES.add(Capability.NOTE_REPEAT_MODE);
        CAPABILITIES.add(Capability.HAS_PINNING);
    }
}

