/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.configuration.IActionSetting;
import de.mossgrabers.framework.configuration.IBooleanSetting;
import de.mossgrabers.framework.configuration.IColorSetting;
import de.mossgrabers.framework.configuration.IDoubleSetting;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.IIntegerSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.configuration.ISignalSetting;
import de.mossgrabers.framework.configuration.IStringSetting;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.reaper.communication.MessageSender;
import de.mossgrabers.reaper.framework.configuration.ActionSettingImpl;
import de.mossgrabers.reaper.framework.configuration.BooleanSettingImpl;
import de.mossgrabers.reaper.framework.configuration.ColorSettingImpl;
import de.mossgrabers.reaper.framework.configuration.DoubleSettingImpl;
import de.mossgrabers.reaper.framework.configuration.EnumSettingImpl;
import de.mossgrabers.reaper.framework.configuration.IfxSetting;
import de.mossgrabers.reaper.framework.configuration.IntegerSettingImpl;
import de.mossgrabers.reaper.framework.configuration.SignalSettingImpl;
import de.mossgrabers.reaper.framework.configuration.StringSettingImpl;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.utils.PropertiesEx;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSettingsUI
implements ISettingsUI {
    protected final MessageSender sender;
    protected final PropertiesEx properties;
    protected final LogModel logModel;
    protected final List<IfxSetting> settings = new ArrayList<IfxSetting>();

    protected AbstractSettingsUI(LogModel logModel, PropertiesEx properties, MessageSender sender) {
        this.logModel = logModel;
        this.properties = properties;
        this.sender = sender;
    }

    public void flush() {
        this.settings.forEach(s -> {
            try {
                s.flush();
            }
            catch (RuntimeException ex) {
                this.logModel.error("Could not flush setting.", ex);
            }
        });
    }

    public void init() {
        this.settings.forEach(IfxSetting::init);
    }

    public List<IfxSetting> getSettings() {
        return this.settings;
    }

    @Override
    public IEnumSetting getEnumSetting(String label, String category, String[] options, String initialValue) {
        EnumSettingImpl setting = new EnumSettingImpl(this.logModel, this.properties, label, category, options, initialValue);
        this.settings.add(setting);
        return setting;
    }

    @Override
    public IStringSetting getStringSetting(String label, String category, int numChars, String initialText) {
        StringSettingImpl setting = new StringSettingImpl(this.logModel, this.properties, label, category, initialText);
        this.settings.add(setting);
        return setting;
    }

    @Override
    public IDoubleSetting getNumberSetting(String label, String category, double minValue, double maxValue, double stepResolution, String unit, double initialValue) {
        DoubleSettingImpl setting = new DoubleSettingImpl(this.logModel, this.properties, label, category, initialValue);
        this.settings.add(setting);
        return setting;
    }

    @Override
    public IIntegerSetting getRangeSetting(String label, String category, int minValue, int maxValue, int stepResolution, String unit, int initialValue) {
        IntegerSettingImpl setting = new IntegerSettingImpl(this.logModel, this.properties, label, category, initialValue, minValue, maxValue);
        this.settings.add(setting);
        return setting;
    }

    @Override
    public ISignalSetting getSignalSetting(String label, String category, String title) {
        SignalSettingImpl setting = new SignalSettingImpl(this.logModel, this.properties, label, category, title);
        this.settings.add(setting);
        return setting;
    }

    @Override
    public IColorSetting getColorSetting(String label, String category, ColorEx defaultColor) {
        ColorSettingImpl setting = new ColorSettingImpl(this.logModel, this.properties, label, category, defaultColor);
        this.settings.add(setting);
        return setting;
    }

    @Override
    public IBooleanSetting getBooleanSetting(String label, String category, boolean initialValue) {
        BooleanSettingImpl setting = new BooleanSettingImpl(this.logModel, this.properties, label, category, initialValue);
        this.settings.add(setting);
        return setting;
    }

    @Override
    public IActionSetting getActionSetting(String label, String category) {
        ActionSettingImpl setting = new ActionSettingImpl(this.sender, this.logModel, this.properties, label, category);
        this.settings.add(setting);
        return setting;
    }
}

