/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view.sequencer;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.INoteEditor;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class AbstractSequencerView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractView<S, C> {
    public static final String COLOR_STEP_HILITE_NO_CONTENT = "COLOR_STEP_HILITE_NO_CONTENT";
    public static final String COLOR_STEP_HILITE_CONTENT = "COLOR_STEP_HILITE_CONTENT";
    public static final String COLOR_STEP_MUTED = "COLOR_STEP_MUTED";
    public static final String COLOR_STEP_MUTED_CONT = "COLOR_STEP_MUTED_CONT";
    public static final String COLOR_STEP_SELECTED = "COLOR_STEP_SELECTED";
    public static final String COLOR_NO_CONTENT = "COLOR_NO_CONTENT";
    public static final String COLOR_NO_CONTENT_4 = "COLOR_NO_CONTENT_4";
    public static final String COLOR_CONTENT = "COLOR_CONTENT";
    public static final String COLOR_CONTENT_CONT = "COLOR_CONTENT_CONT";
    public static final String COLOR_PAGE = "COLOR_PAGE";
    public static final String COLOR_ACTIVE_PAGE = "COLOR_ACTIVE_PAGE";
    public static final String COLOR_SELECTED_PAGE = "COLOR_SELECTED_PAGE";
    public static final String COLOR_RESOLUTION_OFF = "COLOR_RESOLUTION_OFF";
    public static final String COLOR_RESOLUTION = "COLOR_RESOLUTION";
    public static final String COLOR_RESOLUTION_SELECTED = "COLOR_RESOLUTION_SELECTED";
    public static final String COLOR_TRANSPOSE = "COLOR_TRANSPOSE";
    public static final String COLOR_TRANSPOSE_SELECTED = "COLOR_TRANSPOSE_SELECTED";
    protected final int clipRows;
    protected final int clipCols;
    protected final boolean useDawColors;
    protected int numSequencerRows;
    protected final Configuration configuration;
    protected boolean isNoteEdited = false;
    private boolean isSequencerActive;

    protected AbstractSequencerView(String name, S surface, IModel model, int clipRows, int clipCols, boolean useDawColors) {
        this(name, surface, model, clipRows, clipCols, clipRows, useDawColors);
    }

    protected AbstractSequencerView(String name, S surface, IModel model, int clipRows, int clipCols, int numSequencerRows, boolean useDawColors) {
        super(name, surface, model);
        this.clipRows = clipRows;
        this.clipCols = clipCols;
        this.useDawColors = useDawColors;
        this.numSequencerRows = numSequencerRows;
        this.configuration = this.surface.getConfiguration();
        this.getClip();
    }

    @Override
    public void updateControlSurface() {
        this.setSequencerActive(this.model.canSelectedTrackHoldNotes() && this.getClip().doesExist());
        super.updateControlSurface();
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN || !this.isActive()) {
            return;
        }
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        this.setResolutionIndex(7 - index);
    }

    public void onLeft(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        INoteClip clip = this.getClip();
        clip.scrollStepsPageBackwards();
        this.mvHelper.notifyEditPage(clip);
        this.clearEditNotes();
    }

    public void onRight(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        INoteClip clip = this.getClip();
        clip.scrollStepsPageForward();
        this.mvHelper.notifyEditPage(clip);
        this.clearEditNotes();
    }

    public final INoteClip getClip() {
        return this.model.getNoteClip(this.clipCols, this.clipRows);
    }

    public void setResolutionIndex(int selectedResolutionIndex) {
        int resolutionIndex = Math.min(Math.max(0, selectedResolutionIndex), 7);
        Resolution resolution = Resolution.values()[resolutionIndex];
        this.getClip().setStepLength(resolution.getValue());
        this.surface.getDisplay().notify("Grid res.: " + resolution.getName());
    }

    public int getResolutionIndex() {
        return Resolution.getMatch(this.getClip().getStepLength());
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        if (!this.isActive()) {
            return COLOR_RESOLUTION_OFF;
        }
        if (!ButtonID.isSceneButton(buttonID)) {
            return "BUTTON_COLOR_OFF";
        }
        return buttonID == ButtonID.get(ButtonID.SCENE1, 7 - this.getResolutionIndex()) ? COLOR_RESOLUTION_SELECTED : COLOR_RESOLUTION;
    }

    public void setNoteEdited() {
        this.isNoteEdited = true;
    }

    protected boolean isInXRange(int x) {
        INoteClip clip = this.getClip();
        int stepSize = clip.getNumSteps();
        int start = clip.getEditPage() * stepSize;
        return x >= start && x < start + stepSize;
    }

    protected int getLengthOfOnePage(int numOfSteps) {
        return (int)Math.floor((double)numOfSteps * Resolution.getValueAt(this.getResolutionIndex()));
    }

    protected String getPageColor(int loopStartPage, int loopEndPage, int playPage, int selectedPage, int page) {
        if (page == playPage) {
            return COLOR_ACTIVE_PAGE;
        }
        if (page == selectedPage) {
            return COLOR_SELECTED_PAGE;
        }
        if (page < loopStartPage || page >= loopEndPage) {
            return COLOR_NO_CONTENT;
        }
        return COLOR_PAGE;
    }

    protected void handleSequencerAreaRepeatOperator(INoteClip clip, NotePosition notePosition, int velocity, boolean increase) {
        boolean isOff;
        IStepInfo stepInfo = clip.getStep(notePosition);
        if (stepInfo.getState() == StepState.OFF) {
            clip.toggleStep(notePosition, velocity);
        }
        boolean bl = isOff = !stepInfo.isRepeatEnabled();
        if (isOff) {
            clip.updateStepIsRepeatEnabled(notePosition, true);
        }
        int repeatCount = stepInfo.getRepeatCount();
        repeatCount = increase ? Math.min(127, repeatCount + 1) : Math.max(-127, repeatCount - 1);
        clip.updateStepRepeatCount(notePosition, repeatCount);
        Object repeatCountStr = repeatCount > 0 ? Integer.toString(repeatCount + 1) : (repeatCount == 0 ? "Off" : "1/" + Integer.toString(1 - repeatCount));
        this.surface.getDisplay().notify("Note repeat: " + (String)repeatCountStr);
    }

    public boolean isActive() {
        return this.isSequencerActive;
    }

    public void setSequencerActive(boolean isSequencerActive) {
        this.isSequencerActive = isSequencerActive;
    }

    public void editNote(NotePosition notePosition, boolean addNote) {
        this.editNote(this.getClip(), notePosition, addNote);
    }

    protected void editNote(INoteClip clip, NotePosition notePosition, boolean addNote) {
        StepState state = clip.getStep(notePosition).getState();
        if (state != StepState.START) {
            return;
        }
        Optional<INoteEditor> noteEditorOpt = this.getNoteEditor();
        if (noteEditorOpt.isEmpty()) {
            return;
        }
        INoteEditor noteEditor = noteEditorOpt.get();
        if (noteEditor.isNoteEdited(clip, notePosition)) {
            noteEditor.removeNote(clip, notePosition);
            if (noteEditor.getNotes().isEmpty()) {
                this.surface.getModeManager().restore();
                this.surface.consumePads();
            }
            return;
        }
        if (addNote) {
            noteEditor.addNote(clip, notePosition);
        } else {
            noteEditor.setNote(clip, notePosition);
        }
    }

    protected Optional<INoteEditor> getNoteEditor() {
        ModeManager modeManager = this.surface.getModeManager();
        IMode mode = (IMode)modeManager.get(Modes.NOTE);
        if (mode instanceof INoteEditorMode) {
            INoteEditorMode noteMode = (INoteEditorMode)((Object)mode);
            if (!modeManager.isActive(new Modes[]{Modes.NOTE})) {
                modeManager.setActive(Modes.NOTE);
            }
            return Optional.ofNullable(noteMode.getNoteEditor());
        }
        ViewManager viewManager = this.surface.getViewManager();
        IView view = (IView)viewManager.get(Views.NOTE_EDIT_VIEW);
        if (view instanceof INoteEditorMode) {
            INoteEditorMode noteMode = (INoteEditorMode)((Object)view);
            if (!viewManager.isActive(new Views[]{Views.NOTE_EDIT_VIEW})) {
                viewManager.setTemporary(Views.NOTE_EDIT_VIEW);
            }
            return Optional.ofNullable(noteMode.getNoteEditor());
        }
        if (view instanceof INoteEditor) {
            INoteEditor noteEditor = (INoteEditor)((Object)view);
            if (!viewManager.isActive(new Views[]{Views.NOTE_EDIT_VIEW})) {
                viewManager.setTemporary(Views.NOTE_EDIT_VIEW);
            }
            return Optional.of(noteEditor);
        }
        return Optional.empty();
    }

    protected void clearEditNotes() {
        INoteEditor noteMode = null;
        Object f = this.surface.getModeManager().get(Modes.NOTE);
        if (f instanceof INoteEditorMode) {
            INoteEditorMode noteMode1 = (INoteEditorMode)f;
            noteMode = noteMode1.getNoteEditor();
        } else {
            IView view = (IView)this.surface.getViewManager().get(Views.NOTE_EDIT_VIEW);
            if (view instanceof INoteEditorMode) {
                INoteEditorMode noteMode2 = (INoteEditorMode)((Object)view);
                noteMode = noteMode2.getNoteEditor();
            } else if (view instanceof INoteEditor) {
                INoteEditor noteEditor;
                noteMode = noteEditor = (INoteEditor)((Object)view);
            }
        }
        if (noteMode != null) {
            noteMode.clearNotes();
        }
    }

    protected List<NotePosition> getEditNotes() {
        ModeManager modeManager = this.surface.getModeManager();
        IMode mode = (IMode)modeManager.get(Modes.NOTE);
        if (mode instanceof INoteEditorMode) {
            INoteEditorMode noteMode = (INoteEditorMode)((Object)mode);
            return noteMode.getNoteEditor().getNotes();
        }
        IView view = (IView)this.surface.getViewManager().get(Views.NOTE_EDIT_VIEW);
        if (view instanceof INoteEditorMode) {
            INoteEditorMode noteMode2 = (INoteEditorMode)((Object)view);
            return noteMode2.getNoteEditor().getNotes();
        }
        if (view instanceof INoteEditor) {
            INoteEditor noteEditor = (INoteEditor)((Object)view);
            return noteEditor.getNotes();
        }
        return Collections.emptyList();
    }

    protected static boolean isEdit(int channel, int step, int note, List<NotePosition> editNotes) {
        for (NotePosition editNote : editNotes) {
            if (editNote.getChannel() != channel || editNote.getStep() != step || editNote.getNote() != note) continue;
            return true;
        }
        return false;
    }

    protected String getStepColor(IStepInfo stepInfo, boolean highlight, int channel, int step, int pad, int note, List<NotePosition> editNotes) {
        if (stepInfo == null || stepInfo.getState() == StepState.OFF) {
            if (highlight) {
                return COLOR_STEP_HILITE_NO_CONTENT;
            }
            String padColor = this.getPadColor(pad, this.useDawColors ? this.model.getCursorTrack() : null);
            if (this.configuration.isTurnOffScalePads() && "SCALE_COLOR_NOTE".equals(padColor)) {
                return "SCALE_COLOR_OFF";
            }
            return padColor;
        }
        return this.getStepColor(stepInfo, highlight, Optional.empty(), channel, step, note, editNotes);
    }

    protected String getStepColor(IStepInfo stepInfo, boolean highlight, Optional<ColorEx> rowColor, int channel, int step, int note, List<NotePosition> editNotes) {
        StepState state = stepInfo == null ? StepState.OFF : stepInfo.getState();
        switch (state) {
            case START: {
                if (highlight) {
                    return COLOR_STEP_HILITE_CONTENT;
                }
                if (AbstractSequencerView.isEdit(channel, step, note, editNotes)) {
                    return COLOR_STEP_SELECTED;
                }
                if (stepInfo != null && stepInfo.isMuted()) {
                    return COLOR_STEP_MUTED;
                }
                return rowColor.isPresent() && this.useDawColors ? DAWColor.getColorID(rowColor.get()) : COLOR_CONTENT;
            }
            case CONTINUE: {
                if (highlight) {
                    return COLOR_STEP_HILITE_CONTENT;
                }
                if (AbstractSequencerView.isEdit(channel, step, note, editNotes)) {
                    return COLOR_STEP_SELECTED;
                }
                if (stepInfo != null && stepInfo.isMuted()) {
                    return COLOR_STEP_MUTED_CONT;
                }
                return rowColor.isPresent() && this.useDawColors ? DAWColor.getColorID(ColorEx.darker(rowColor.get())) : COLOR_CONTENT_CONT;
            }
        }
        if (highlight) {
            return COLOR_STEP_HILITE_NO_CONTENT;
        }
        return step / 4 % 2 == 1 ? COLOR_NO_CONTENT_4 : COLOR_NO_CONTENT;
    }

    protected boolean handleNoteEditor(INoteClip clip, NotePosition notePosition, int velocity) {
        ModeManager modeManager = this.surface.getModeManager();
        if (velocity > 0) {
            IMode activeMode = (IMode)modeManager.getActive();
            if (activeMode instanceof INoteEditorMode) {
                INoteEditorMode noteMode = (INoteEditorMode)((Object)activeMode);
                StepState state = clip.getStep(notePosition).getState();
                if (state == StepState.START) {
                    this.editNote(clip, notePosition, true);
                    if (noteMode.getNoteEditor().getNotes().isEmpty()) {
                        this.surface.getDisplay().notify("Edit Notes: Off");
                        this.isNoteEdited = false;
                    }
                }
                return true;
            }
        } else {
            if (this.isNoteEdited) {
                this.isNoteEdited = false;
            }
            if (modeManager.isActive(new Modes[]{Modes.NOTE})) {
                return true;
            }
        }
        return false;
    }
}

