/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view.sequencer;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.TransposeView;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;

public abstract class AbstractRaindropsView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractSequencerView<S, C>
implements TransposeView {
    protected static final int NUM_DISPLAY_COLS = 8;
    protected static final int NUM_OCTAVE = 12;
    protected static final int START_KEY = 36;
    protected static final int MAX_STEPS = (int)Math.floor(128.0 / Resolution.RES_1_32T.getValue());
    protected int numDisplayRows = 8;
    protected boolean ongoingResolutionChange = false;
    protected int offsetY = 36;

    protected AbstractRaindropsView(String name, S surface, IModel model, boolean useDawColors) {
        super(name, surface, model, 128, MAX_STEPS, useDawColors);
    }

    @Override
    public void onActivate() {
        this.updateScale();
        super.onActivate();
    }

    @Override
    public void updateNoteMapping() {
        super.updateNoteMapping();
        this.updateScale();
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.isActive() || velocity == 0) {
            return;
        }
        int index = note - 36;
        int x = index % 8;
        int y = index / 8;
        int stepSize = y == 0 ? 1 : 2 * y;
        INoteClip clip = this.getClip();
        double resolutionLength = Resolution.getValueAt(this.getResolutionIndex());
        int length = (int)Math.floor(clip.getLoopLength() / resolutionLength);
        int distance = this.getNoteDistance(this.keyManager.map(x), length);
        int editMidiChannel = this.configuration.getMidiEditChannel();
        clip.clearRow(editMidiChannel, this.keyManager.map(x));
        NotePosition notePosition = new NotePosition(editMidiChannel, 0, 0);
        if (distance == -1 || distance != (y == 0 ? 1 : y * 2)) {
            int offset = clip.getCurrentStep() % stepSize;
            if (offset < 0) {
                return;
            }
            for (int i = offset; i < length; i += stepSize) {
                if (i >= MAX_STEPS) continue;
                notePosition.setStep(i);
                notePosition.setNote(this.keyManager.map(x));
                clip.setStep(notePosition, this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : velocity, resolutionLength);
            }
        }
    }

    @Override
    public void drawGrid() {
        IPadGrid padGrid = this.surface.getPadGrid();
        if (!this.isActive()) {
            padGrid.turnOff();
            return;
        }
        if (this.ongoingResolutionChange) {
            return;
        }
        ICursorTrack cursorTrack = this.useDawColors ? this.model.getCursorTrack() : null;
        INoteClip clip = this.getClip();
        int length = (int)Math.floor(clip.getLoopLength() / Resolution.getValueAt(this.getResolutionIndex()));
        int step = clip.getCurrentStep();
        for (int x = 0; x < 8; ++x) {
            int mappedKey = this.keyManager.map(x);
            if (mappedKey == -1) continue;
            int left = this.getNoteDistanceToTheLeft(mappedKey, step, length);
            int right = this.getNoteDistanceToTheRight(mappedKey, step, length);
            boolean isOn = left >= 0 && right >= 0;
            int sum = left + right;
            int distance = sum == 0 ? 0 : (sum + 1) / 2;
            for (int y = 0; y < this.numDisplayRows; ++y) {
                String colorID;
                String string = colorID = y == 0 ? this.getPadColor(x, cursorTrack) : "COLOR_NO_CONTENT";
                if (isOn) {
                    if (y == distance) {
                        colorID = "COLOR_CONTENT";
                    }
                    if (left <= distance && y == left || left > distance && y == sum - left) {
                        colorID = "COLOR_STEP_HILITE_NO_CONTENT";
                    }
                } else if (this.configuration.isTurnOffScalePads() && "SCALE_COLOR_NOTE".equals(colorID)) {
                    colorID = "SCALE_COLOR_OFF";
                }
                padGrid.lightEx(x, this.numDisplayRows - 1 - y, colorID);
            }
        }
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        this.ongoingResolutionChange = true;
        super.onButton(buttonID, event, velocity);
        this.ongoingResolutionChange = false;
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (event != ButtonEvent.DOWN || !this.isActive()) {
            return;
        }
        if (this.surface.isShiftPressed()) {
            this.getClip().transpose(-1);
            return;
        }
        if (this.surface.isSelectPressed()) {
            this.getClip().transpose(-12);
            return;
        }
        this.offsetY = Math.max(0, this.offsetY - 12);
        this.updateScale();
        this.surface.scheduleTask(() -> this.surface.getDisplay().notify(Scales.getSequencerRangeText(this.keyManager.map(0), this.keyManager.map(7))), 10L);
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (event != ButtonEvent.DOWN || !this.isActive()) {
            return;
        }
        if (this.surface.isShiftPressed()) {
            this.getClip().transpose(1);
            return;
        }
        if (this.surface.isSelectPressed()) {
            this.getClip().transpose(12);
            return;
        }
        int numRows = this.getClip().getNumRows();
        this.offsetY = Math.min(numRows - 12, this.offsetY + 12);
        this.updateScale();
        this.surface.scheduleTask(() -> this.surface.getDisplay().notify(Scales.getSequencerRangeText(this.keyManager.map(0), this.keyManager.map(7))), 10L);
    }

    @Override
    public void resetOctave() {
    }

    @Override
    public boolean isOctaveUpButtonOn() {
        return this.isActive();
    }

    @Override
    public boolean isOctaveDownButtonOn() {
        return this.isActive();
    }

    protected int getNoteDistance(int row, int length) {
        int step;
        if (row < 0) {
            return -1;
        }
        INoteClip clip = this.getClip();
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), 0, row);
        for (step = 0; step < length; ++step) {
            notePosition.setStep(step);
            if (clip.getStep(notePosition).getState() != StepState.OFF) break;
        }
        if (step >= length) {
            return -1;
        }
        for (int step2 = step + 1; step2 < length; ++step2) {
            notePosition.setStep(step2);
            if (clip.getStep(notePosition).getState() == StepState.OFF) continue;
            return step2 - step;
        }
        return -1;
    }

    protected int getNoteDistanceToTheRight(int row, int start, int length) {
        if (row < 0 || start < 0 || start >= length) {
            return -1;
        }
        int step = start;
        int counter = 0;
        INoteClip clip = this.getClip();
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), 0, row);
        do {
            notePosition.setStep(step);
            if (clip.getStep(notePosition).getState() != StepState.OFF) {
                return counter;
            }
            ++counter;
            if (++step < length) continue;
            step = 0;
        } while (step != start);
        return -1;
    }

    protected int getNoteDistanceToTheLeft(int row, int start, int length) {
        int s;
        if (row < 0 || start < 0 || start >= length) {
            return -1;
        }
        int step = s = start == 0 ? length - 1 : start - 1;
        int counter = 0;
        INoteClip clip = this.getClip();
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), 0, row);
        do {
            notePosition.setStep(step);
            if (clip.getStep(notePosition).getState() != StepState.OFF) {
                return counter;
            }
            ++counter;
            if (--step >= 0) continue;
            step = length - 1;
        } while (step != s);
        return -1;
    }

    protected void updateScale() {
        this.delayedUpdateNoteMapping(this.model.canSelectedTrackHoldNotes() ? this.scales.getSequencerMatrix(8, this.offsetY) : EMPTY_TABLE);
    }
}

