/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view.sequencer;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.scale.Scale;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.TransposeView;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;
import java.util.List;

public abstract class AbstractNoteSequencerView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractSequencerView<S, C>
implements TransposeView {
    private static final int OCTAVE = 12;
    protected int numDisplayRows = 8;
    protected int numDisplayCols;
    protected int startKey = 36;
    protected int loopPadPressed = -1;
    protected int offsetY;
    protected IStepInfo copyNote;

    protected AbstractNoteSequencerView(String name, S surface, IModel model, boolean useDawColors) {
        this(name, surface, model, 8, useDawColors);
    }

    protected AbstractNoteSequencerView(String name, S surface, IModel model, int numDisplayCols, boolean useDawColors) {
        this(name, surface, model, numDisplayCols, 7, useDawColors);
    }

    protected AbstractNoteSequencerView(String name, S surface, IModel model, int numDisplayCols, int numSequencerRows, boolean useDawColors) {
        super(name, surface, model, 128, numDisplayCols, numSequencerRows, useDawColors);
        this.numDisplayCols = numDisplayCols;
        this.offsetY = this.startKey;
    }

    @Override
    public void onActivate() {
        this.updateScale();
        super.onActivate();
    }

    @Override
    public void updateNoteMapping() {
        super.updateNoteMapping();
        this.updateScale();
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.isActive()) {
            return;
        }
        int index = note - this.surface.getPadGrid().getStartNote();
        int x = index % this.numDisplayCols;
        int y = index / this.numDisplayCols;
        if (y < this.numSequencerRows) {
            this.handleSequencerArea(index, x, y, velocity);
            return;
        }
        this.handleLoopArea(x, velocity);
    }

    protected void handleSequencerArea(int index, int x, int y, int velocity) {
        int vel;
        if (velocity != 0) {
            return;
        }
        INoteClip clip = this.getClip();
        int mappedY = this.keyManager.map(y);
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), x, mappedY);
        int n = vel = this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : this.surface.getButton(ButtonID.get(ButtonID.PAD1, index)).getPressedVelocity();
        if (this.handleSequencerAreaButtonCombinations(clip, notePosition, y, vel)) {
            return;
        }
        if (mappedY >= 0) {
            clip.toggleStep(notePosition, vel);
        }
    }

    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int row, int velocity) {
        if (this.isButtonCombination(ButtonID.DUPLICATE)) {
            IStepInfo noteStep = clip.getStep(notePosition);
            if (noteStep.getState() == StepState.START) {
                this.copyNote = noteStep;
            } else if (this.copyNote != null) {
                clip.setStep(notePosition, this.copyNote);
            }
            return true;
        }
        if (this.isButtonCombination(ButtonID.MUTE)) {
            IStepInfo stepInfo = clip.getStep(notePosition);
            StepState isSet = stepInfo.getState();
            if (isSet == StepState.START) {
                clip.updateStepMuteState(notePosition, !stepInfo.isMuted());
            }
            return true;
        }
        int offset = row * clip.getNumSteps();
        NotePosition np = new NotePosition(notePosition);
        int step = np.getStep();
        int note = np.getNote();
        for (int s = 0; s < step; ++s) {
            StepState state;
            IHwButton button = this.surface.getButton(ButtonID.get(ButtonID.PAD1, offset + s));
            if (!button.isLongPressed()) continue;
            np.setStep(s);
            button.setConsumed();
            int length = step - s + 1;
            double duration = (double)length * Resolution.getValueAt(this.getResolutionIndex());
            StepState stepState = state = note < 0 ? StepState.OFF : clip.getStep(np).getState();
            if (state == StepState.START) {
                clip.updateStepDuration(np, duration);
            } else {
                clip.setStep(np, velocity, duration);
            }
            return true;
        }
        return false;
    }

    protected void handleLoopArea(int pad, int velocity) {
        if (velocity > 0) {
            if (this.loopPadPressed == -1) {
                this.loopPadPressed = pad;
            }
            return;
        }
        if (this.loopPadPressed == -1) {
            return;
        }
        INoteClip clip = this.getClip();
        if (pad == this.loopPadPressed && pad != clip.getEditPage()) {
            clip.scrollToPage(pad);
        } else {
            int start = this.loopPadPressed < pad ? this.loopPadPressed : pad;
            int end = (this.loopPadPressed < pad ? pad : this.loopPadPressed) + 1;
            int lengthOfOnePad = this.getLengthOfOnePage(this.numDisplayCols);
            double newStart = (double)start * (double)lengthOfOnePad;
            clip.setLoopStart(newStart);
            clip.setLoopLength((end - start) * lengthOfOnePad);
            clip.setPlayRange(newStart, (double)end * (double)lengthOfOnePad);
        }
        this.loopPadPressed = -1;
    }

    @Override
    public void drawGrid() {
        IPadGrid gridPad = this.surface.getPadGrid();
        if (!this.isActive()) {
            gridPad.turnOff();
            return;
        }
        INoteClip clip = this.getClip();
        int step = clip.getCurrentStep();
        int hiStep = this.isInXRange(step) ? step % this.numDisplayCols : -1;
        List<NotePosition> editNotes = this.getEditNotes();
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), 0, 0);
        for (int x = 0; x < this.numDisplayCols; ++x) {
            notePosition.setStep(x);
            for (int y = 0; y < this.numSequencerRows; ++y) {
                int map = this.keyManager.map(y);
                notePosition.setNote(map);
                IStepInfo stepInfo = map < 0 ? null : clip.getStep(notePosition);
                gridPad.lightEx(x, this.numDisplayRows - 1 - y, this.getStepColor(stepInfo, x == hiStep, notePosition.getChannel(), x, y, map, editNotes));
            }
        }
        if (this.numDisplayRows - this.numSequencerRows <= 0) {
            return;
        }
        int lengthOfOnePad = this.getLengthOfOnePage(this.numDisplayCols);
        double loopStart = clip.getLoopStart();
        int loopStartPad = (int)Math.ceil(loopStart / (double)lengthOfOnePad);
        int loopEndPad = (int)Math.ceil((loopStart + clip.getLoopLength()) / (double)lengthOfOnePad);
        int currentPage = step / this.numDisplayCols;
        for (int pad = 0; pad < this.numDisplayCols; ++pad) {
            gridPad.lightEx(pad, 0, this.getPageColor(loopStartPad, loopEndPad, currentPage, clip.getEditPage(), pad));
        }
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (!this.isActive() || event != ButtonEvent.DOWN) {
            return;
        }
        if (this.surface.isShiftPressed()) {
            this.getClip().transpose(-1);
            return;
        }
        if (this.surface.isSelectPressed()) {
            this.getClip().transpose(-12);
            return;
        }
        this.updateOctave(Math.max(0, this.offsetY - this.getScrollOffset()));
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (!this.isActive() || event != ButtonEvent.DOWN) {
            return;
        }
        if (this.surface.isShiftPressed()) {
            this.getClip().transpose(1);
            return;
        }
        if (this.surface.isSelectPressed()) {
            this.getClip().transpose(12);
            return;
        }
        int offset = this.getScrollOffset();
        if (this.offsetY + offset < this.getClip().getNumRows()) {
            this.updateOctave(this.offsetY + offset);
        }
    }

    @Override
    public void resetOctave() {
        this.updateOctave(this.offsetY);
    }

    protected int getScrollOffset() {
        if (this.scales.isChromatic()) {
            return this.numSequencerRows;
        }
        Scale scale = this.scales.getScale();
        int lower = scale.getIndexInScale(this.offsetY);
        if (lower < 0) {
            lower = 0;
        }
        int upper = lower + this.numSequencerRows;
        int[] intervals = scale.getIntervals();
        int lowerNote = intervals[lower];
        int upperNote = upper / intervals.length * 12 + intervals[upper % intervals.length];
        return upperNote - lowerNote;
    }

    @Override
    public boolean isOctaveUpButtonOn() {
        return this.isActive();
    }

    @Override
    public boolean isOctaveDownButtonOn() {
        return this.isActive();
    }

    protected void updateScale() {
        this.delayedUpdateNoteMapping(this.model.canSelectedTrackHoldNotes() ? this.scales.getSequencerMatrix(this.numSequencerRows + 1, this.offsetY) : EMPTY_TABLE);
    }

    protected void updateOctave(int value) {
        this.offsetY = value;
        this.updateScale();
        this.clearEditNotes();
        this.surface.scheduleTask(() -> this.surface.getDisplay().notify(Scales.getSequencerRangeText(this.keyManager.map(0), this.keyManager.map(this.numSequencerRows - 1))), 10L);
    }
}

