/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view.sequencer;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.ISessionAlternative;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractSessionView;
import de.mossgrabers.framework.view.Views;
import de.mossgrabers.framework.view.sequencer.AbstractDrumView;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractDrumXoXView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractDrumView<S, C>
implements ISessionAlternative {
    protected static final int[] DRUM_MATRIX = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    protected static final Map<Resolution, Resolution> PREV_RESOLUTION = new EnumMap<Resolution, Resolution>(Resolution.class);
    protected static final Map<Resolution, Resolution> NEXT_RESOLUTION = new EnumMap<Resolution, Resolution>(Resolution.class);
    protected static final int NUM_CLIPS = 16;
    protected ButtonID deleteButton = ButtonID.DELETE;
    protected ButtonID stopButton = ButtonID.STOP;
    protected ButtonID browseButton = ButtonID.BROWSE;
    protected final ISlotBank slotBank;
    protected ISlot sourceSlot = null;
    protected final List<IStepInfo> sourceNotes = new ArrayList<IStepInfo>();
    protected boolean blockSelectKnob = false;
    protected int numStepRows;
    protected int numDrumPadRows;
    protected int numClipsRows;
    protected int sequencerOffset;
    protected int clipsOffset;
    protected ButtonID editLoopTriggerButton = ButtonID.FIXED_LENGTH;
    private boolean wasAlternateInteractionUsed = false;

    public AbstractDrumXoXView(String name, S surface, IModel model, int numColumns) {
        super(name, surface, model, 32 / numColumns, 1, numColumns, 128, 32, true, true);
        this.playColumns = 16;
        this.allRows = this.sequencerLines;
        this.numClipsRows = 16 / this.numColumns;
        this.numDrumPadRows = this.playColumns / this.numColumns;
        this.numStepRows = this.clipCols / this.numColumns;
        this.sequencerOffset = this.numClipsRows + this.numDrumPadRows;
        this.clipsOffset = this.numStepRows + this.numDrumPadRows;
        this.slotBank = this.model.getSlotBank(16);
    }

    @Override
    protected void drawPages(INoteClip clip, boolean isActive) {
        AbstractSessionView view = (AbstractSessionView)AbstractSessionView.class.cast(this.surface.getViewManager().get(Views.SESSION));
        IPadGrid padGrid = this.surface.getPadGrid();
        boolean isRecArmed = this.model.getCursorTrack().isRecArm();
        for (int x = 0; x < this.slotBank.getPageSize(); ++x) {
            ISlot slot = (ISlot)this.slotBank.getItem(x);
            LightInfo color = view.getPadColor(slot, isRecArmed);
            padGrid.lightEx(x % this.numColumns, x / this.numColumns, color.getColor(), color.getBlinkColor(), color.isFast());
        }
    }

    @Override
    protected void drawDrumPads(IPadGrid padGrid, IDrumPadBank drumPadBank) {
        IDrumPadBank drumPadBank2 = this.getDrumDevice().getDrumPadBank();
        boolean isRecording = this.model.hasRecordingState();
        for (int x = 0; x < this.playColumns; ++x) {
            padGrid.lightEx(x % this.numColumns, this.numClipsRows + this.numDrumPadRows - 1 - x / this.numColumns, this.getDrumPadColor(x, drumPadBank2, isRecording));
        }
    }

    @Override
    protected void drawSequencerSteps(INoteClip clip, boolean isActive, int noteRow, Optional<ColorEx> rowColor) {
        if (this.isEditLoopRange()) {
            int numberOfActiveSteps = (int)Math.floor(clip.getLoopLength() / Resolution.getValueAt(this.getResolutionIndex()));
            numberOfActiveSteps -= clip.getEditPage() * this.sequencerSteps;
            IPadGrid padGrid = this.surface.getPadGrid();
            for (int col = 0; col < this.sequencerSteps; ++col) {
                boolean isFourth;
                boolean bl = isFourth = (col + 1) % 4 == 0;
                String color = col < numberOfActiveSteps ? (isFourth ? "COLOR_ACTIVE_PAGE" : "COLOR_PAGE") : (isFourth ? "COLOR_SELECTED_PAGE" : "COLOR_NO_CONTENT");
                padGrid.lightEx(col % this.numColumns, this.sequencerOffset + col / this.numColumns, color);
            }
            return;
        }
        super.drawSequencerSteps(clip, isActive, noteRow, rowColor, y -> this.sequencerOffset + y);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int index = note - 36;
        int x = index % this.numColumns;
        int y = index / this.numColumns;
        int offsetY = this.scales.getDrumOffset();
        if (y < this.numStepRows) {
            if (this.isActive()) {
                this.handleSequencerArea(index, x, y, offsetY, velocity);
            }
            return;
        }
        if (y >= this.numStepRows && y < this.clipsOffset) {
            this.handleNoteArea((y - this.numStepRows) * this.numColumns + x, 0, offsetY, velocity);
            return;
        }
        int row = this.surface.getPadGrid().getRows() - y - 1;
        this.handleClipRow(index, row * this.numColumns + x, velocity != 0);
    }

    @Override
    protected void handleNoteAreaButtonCombinations(int playedPad) {
        if (this.isDuplicateTrigger()) {
            this.duplicateSteps();
            return;
        }
        super.handleNoteAreaButtonCombinations(playedPad);
    }

    protected void handleClipRow(int padIndex, int clipIndex, boolean isPressed) {
        boolean isAlternateFunction = this.isAlternateFunction();
        if (isAlternateFunction) {
            this.setAlternateInteractionUsed(true);
        }
        ISlot slot = (ISlot)this.slotBank.getItem(clipIndex);
        ICursorTrack track = this.model.getCursorTrack();
        if (isPressed) {
            if (this.handleClipRowButtonCombinations(track, slot)) {
                this.surface.setTriggerConsumed(ButtonID.get(ButtonID.PAD1, padIndex));
                return;
            }
            if (this.configuration.isSelectClipOnLaunch()) {
                slot.select();
            }
        }
        if (!track.isRecArm() || slot.hasContent()) {
            this.handleClipLaunch(slot, isPressed);
            return;
        }
        switch (this.configuration.getActionForRecArmedPad()) {
            case 0: {
                this.model.recordNoteClip(track, slot);
                break;
            }
            case 1: {
                int lengthInBeats = this.configuration.getNewClipLenghthInBeats(this.model.getTransport().getQuartersPerMeasure());
                this.model.createNoteClip(track, slot, lengthInBeats, true);
                break;
            }
        }
    }

    protected void handleClipLaunch(ISlot slot, boolean isPressed) {
        if (this.surface.isPressed(this.buttonSelect)) {
            slot.select();
        } else {
            slot.launch(isPressed, this.isAlternateFunction());
        }
    }

    @Override
    protected void handleSequencerArea(int index, int x, int y, int offsetY, int velocity) {
        if (this.isEditLoopRange()) {
            if (velocity > 0) {
                return;
            }
            this.surface.setTriggerConsumed(this.editLoopTriggerButton);
            int steps = (this.numStepRows - 1 - y) * this.numColumns + x + 1;
            INoteClip clip = this.getClip();
            clip.setLoopLength((double)(steps += clip.getEditPage() * this.sequencerSteps) * Resolution.getValueAt(this.getResolutionIndex()));
            return;
        }
        if (this.handleNoteEditorMode(x, y, offsetY, velocity)) {
            return;
        }
        super.handleSequencerArea(index, x, y, offsetY, velocity);
    }

    protected boolean handleNoteEditorMode(int x, int y, int offsetY, int velocity) {
        return false;
    }

    protected boolean handleClipRowButtonCombinations(ITrack track, ISlot slot) {
        if (!track.doesExist()) {
            return true;
        }
        if (this.isDeleteTrigger()) {
            if (slot.doesExist()) {
                slot.remove();
            }
            return true;
        }
        if (this.isDuplicateTrigger()) {
            if (this.sourceSlot != null) {
                slot.paste(this.sourceSlot);
                this.sourceSlot = null;
            } else if (slot.doesExist() && slot.hasContent()) {
                this.sourceSlot = slot;
            }
            this.sourceNotes.clear();
            return true;
        }
        if (this.isButtonCombination(this.stopButton)) {
            track.stop(false);
            return true;
        }
        if (this.isButtonCombination(this.browseButton)) {
            this.model.getBrowser().replace(slot);
            return true;
        }
        return false;
    }

    protected void duplicateSteps() {
        this.sourceSlot = null;
        INoteClip clip = this.getClip();
        if (!clip.doesExist()) {
            return;
        }
        int drumPad = this.scales.getDrumOffset() + this.selectedPad;
        if (drumPad == -1) {
            return;
        }
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), 0, drumPad);
        if (this.sourceNotes.isEmpty()) {
            for (int step = 0; step < this.sequencerSteps; ++step) {
                notePosition.setStep(step);
                this.sourceNotes.add(clip.getStep(notePosition).createCopy());
            }
            return;
        }
        for (int step = 0; step < this.sourceNotes.size(); ++step) {
            notePosition.setStep(step);
            IStepInfo noteStep = this.sourceNotes.get(step);
            if (noteStep.getVelocity() == 0.0) {
                clip.clearStep(notePosition);
                continue;
            }
            clip.setStep(notePosition, noteStep);
        }
        this.sourceNotes.clear();
    }

    protected boolean isDuplicateTrigger() {
        return this.isButtonCombination(ButtonID.DUPLICATE);
    }

    @Override
    protected int[] getDrumMatrix() {
        int[] noteMap = Scales.getEmptyMatrix();
        int drumOffset = this.scales.getDrumOffset();
        for (int note = 36; note < 100; ++note) {
            int ns = DRUM_MATRIX[note - 36];
            int n = ns == -1 ? -1 : ns + drumOffset;
            noteMap[note] = n < 0 || n > 127 ? -1 : n;
        }
        return noteMap;
    }

    protected void adjustPage(boolean isUp, int selection) {
        this.blockSelectKnob = true;
        this.changeOctave(ButtonEvent.DOWN, isUp, 16, true, true);
        this.surface.scheduleTask(() -> {
            this.selectDrumPad(selection);
            this.blockSelectKnob = false;
        }, 100L);
    }

    protected void selectDrumPad(int index) {
        this.getDrumDevice().getDrumPadBank().getItem(index).select();
    }

    protected boolean isEditLoopRange() {
        return this.surface.isPressed(this.editLoopTriggerButton);
    }

    @Override
    public boolean wasAlternateInteractionUsed() {
        return this.wasAlternateInteractionUsed;
    }

    @Override
    public void setAlternateInteractionUsed(boolean wasUsed) {
        this.wasAlternateInteractionUsed = wasUsed;
    }

    protected boolean isAlternateFunction() {
        return this.surface.isShiftPressed();
    }

    protected void rotateStepsLeft(INoteClip clip) {
        int drumPad = this.scales.getDrumOffset() + this.selectedPad;
        if (drumPad == -1) {
            return;
        }
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), 0, drumPad);
        IStepInfo firstStep = clip.getStep(notePosition).createCopy();
        for (int step = 1; step < this.sequencerSteps; ++step) {
            notePosition.setStep(step);
            IStepInfo noteStep = clip.getStep(notePosition);
            notePosition.setStep(step - 1);
            if (noteStep.getVelocity() == 0.0) {
                clip.clearStep(notePosition);
                continue;
            }
            clip.setStep(notePosition, noteStep);
        }
        notePosition.setStep(this.sequencerSteps - 1);
        if (firstStep.getVelocity() == 0.0) {
            clip.clearStep(notePosition);
        } else {
            clip.setStep(notePosition, firstStep);
        }
    }

    protected void rotateStepsRight(INoteClip clip) {
        int drumPad = this.scales.getDrumOffset() + this.selectedPad;
        if (drumPad == -1) {
            return;
        }
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), this.sequencerSteps - 1, drumPad);
        IStepInfo lastStep = clip.getStep(notePosition).createCopy();
        for (int step = 0; step < this.sequencerSteps - 1; ++step) {
            notePosition.setStep(step);
            IStepInfo noteStep = clip.getStep(notePosition);
            notePosition.setStep(step + 1);
            if (noteStep.getVelocity() == 0.0) {
                clip.clearStep(notePosition);
                continue;
            }
            clip.setStep(notePosition, noteStep);
        }
        notePosition.setStep(0);
        if (lastStep.getVelocity() == 0.0) {
            clip.clearStep(notePosition);
        } else {
            clip.setStep(notePosition, lastStep);
        }
    }

    static {
        PREV_RESOLUTION.put(Resolution.RES_1_4, Resolution.RES_1_4);
        PREV_RESOLUTION.put(Resolution.RES_1_4T, Resolution.RES_1_4);
        PREV_RESOLUTION.put(Resolution.RES_1_8, Resolution.RES_1_4);
        PREV_RESOLUTION.put(Resolution.RES_1_8T, Resolution.RES_1_4);
        PREV_RESOLUTION.put(Resolution.RES_1_16, Resolution.RES_1_8);
        PREV_RESOLUTION.put(Resolution.RES_1_16T, Resolution.RES_1_8);
        PREV_RESOLUTION.put(Resolution.RES_1_32, Resolution.RES_1_16);
        PREV_RESOLUTION.put(Resolution.RES_1_32T, Resolution.RES_1_16);
        NEXT_RESOLUTION.put(Resolution.RES_1_4, Resolution.RES_1_8);
        NEXT_RESOLUTION.put(Resolution.RES_1_4T, Resolution.RES_1_8);
        NEXT_RESOLUTION.put(Resolution.RES_1_8, Resolution.RES_1_16);
        NEXT_RESOLUTION.put(Resolution.RES_1_8T, Resolution.RES_1_16);
        NEXT_RESOLUTION.put(Resolution.RES_1_16, Resolution.RES_1_32);
        NEXT_RESOLUTION.put(Resolution.RES_1_16T, Resolution.RES_1_32);
        NEXT_RESOLUTION.put(Resolution.RES_1_32, Resolution.RES_1_32);
        NEXT_RESOLUTION.put(Resolution.RES_1_32T, Resolution.RES_1_32);
    }
}

