/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view.sequencer;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.hardware.ButtonEventHandler;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.TransposeView;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;
import java.util.List;
import java.util.Optional;
import java.util.function.IntUnaryOperator;

public abstract class AbstractDrumView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractSequencerView<S, C>
implements TransposeView,
ButtonEventHandler {
    public static final String COLOR_PAD_RECORD = "COLOR_PAD_RECORD";
    public static final String COLOR_PAD_PLAY = "COLOR_PAD_PLAY";
    public static final String COLOR_PAD_SELECTED = "COLOR_PAD_SELECTED";
    public static final String COLOR_PAD_MUTED = "COLOR_PAD_MUTED";
    public static final String COLOR_PAD_HAS_CONTENT = "COLOR_PAD_HAS_CONTENT";
    public static final String COLOR_PAD_NO_CONTENT = "COLOR_PAD_NO_CONTENT";
    public static final String COLOR_PAD_OFF = "COLOR_PAD_OFF";
    protected static final int DRUM_START_KEY = 36;
    protected static final int GRID_COLUMNS = 8;
    protected int loopPadPressed = -1;
    protected int sequencerLines;
    protected int playRows;
    protected int numColumns;
    protected int allRows;
    protected int sequencerSteps;
    protected int playColumns;
    protected IStepInfo copyNote;
    protected int selectedPad;
    protected int scrollPosition = -1;
    protected ButtonID firstPad = ButtonID.PAD1;
    protected ButtonID buttonSelect = ButtonID.SELECT;
    protected ButtonID buttonBrowse = ButtonID.BROWSE;
    protected ButtonID buttonSolo = ButtonID.SOLO;
    protected ButtonID buttonMute = ButtonID.MUTE;
    protected ButtonID buttonDelete = ButtonID.DELETE;

    protected AbstractDrumView(String name, S surface, IModel model, int numSequencerLines, int numPlayLines, boolean useDawColors) {
        this(name, surface, model, numSequencerLines, numPlayLines, 8, 128, numSequencerLines * 8, true, useDawColors);
    }

    protected AbstractDrumView(String name, S surface, IModel model, int numSequencerLines, int numPlayRows, int numColumns, int clipRows, int clipCols, boolean followSelection, boolean useDawColors) {
        super(name, surface, model, clipRows, clipCols, useDawColors);
        this.sequencerLines = numSequencerLines;
        this.playRows = numPlayRows;
        this.allRows = this.sequencerLines + this.playRows;
        this.numColumns = numColumns;
        this.sequencerSteps = numSequencerLines * this.numColumns;
        this.playColumns = 4;
        ITrackBank tb = model.getTrackBank();
        tb.addSelectionObserver((index, isSelected) -> this.keyManager.clearPressedKeys());
        tb.addNoteObserver(this::updateNote);
        if (followSelection) {
            model.getDrumDevice().getDrumPadBank().addSelectionObserver((index, isSelected) -> {
                if (isSelected) {
                    this.selectedPad = index;
                }
            });
        }
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.getDrumDevice().getDrumPadBank().setIndication(true);
        this.registerButtonMonitors(this.buttonSelect);
        this.registerButtonMonitors(this.buttonSolo);
        this.registerButtonMonitors(this.buttonMute);
        this.registerButtonMonitors(this.buttonDelete);
        this.registerButtonMonitors(this.buttonBrowse);
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        this.getDrumDevice().getDrumPadBank().setIndication(false);
        this.unregisterButtonMonitors(this.buttonSelect);
        this.unregisterButtonMonitors(this.buttonSolo);
        this.unregisterButtonMonitors(this.buttonMute);
        this.unregisterButtonMonitors(this.buttonDelete);
        this.unregisterButtonMonitors(this.buttonBrowse);
    }

    private void registerButtonMonitors(ButtonID buttonID) {
        IHwButton button = this.surface.getButton(buttonID);
        if (button == null) {
            return;
        }
        button.addEventHandler(ButtonEvent.DOWN, this);
        button.addEventHandler(ButtonEvent.UP, this);
    }

    private void unregisterButtonMonitors(ButtonID buttonID) {
        IHwButton button = this.surface.getButton(buttonID);
        if (button == null) {
            return;
        }
        button.removeEventHandler(ButtonEvent.DOWN, this);
        button.removeEventHandler(ButtonEvent.UP, this);
    }

    @Override
    public void handle(ButtonEvent event) {
        this.updateNoteMapping();
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int index = note - 36;
        int x = index % this.numColumns;
        int y = index / this.numColumns;
        int offsetY = this.scales.getDrumOffset();
        if (y >= this.playRows) {
            if (this.isActive()) {
                this.handleSequencerArea(index, x, y, offsetY, velocity);
            }
            return;
        }
        if (x < this.playColumns) {
            this.handleNoteArea(x, y, offsetY, velocity);
            return;
        }
        if (!this.isActive()) {
            return;
        }
        int pad = (this.playRows - 1 - y) * this.playColumns + x - this.playColumns;
        this.handleLoopArea(pad, velocity);
    }

    protected void handleNoteArea(int x, int y, int offsetY, int velocity) {
        int playedPad;
        this.setSelectedPad(this.playColumns * y + x, velocity);
        this.keyManager.setKeyPressed(offsetY + this.selectedPad, velocity);
        this.playNote(offsetY + this.selectedPad, velocity);
        int n = playedPad = velocity == 0 ? -1 : this.selectedPad;
        if (playedPad < 0) {
            return;
        }
        this.handleNoteAreaButtonCombinations(playedPad);
    }

    protected void handleSequencerArea(int index, int x, int y, int offsetY, int velocity) {
        int vel;
        NotePosition notePosition;
        if (velocity != 0) {
            return;
        }
        INoteClip clip = this.getClip();
        if (this.handleSequencerAreaButtonCombinations(clip, notePosition = new NotePosition(this.configuration.getMidiEditChannel(), this.numColumns * (this.allRows - 1 - y) + x, offsetY + this.selectedPad), vel = this.getVelocity(index))) {
            return;
        }
        clip.toggleStep(notePosition, vel);
    }

    protected int getVelocity(int index) {
        if (this.configuration.isAccentActive()) {
            return this.configuration.getFixedAccentValue();
        }
        IHwButton button = this.surface.getButton(ButtonID.get(this.firstPad, index));
        return button.getPressedVelocity();
    }

    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int velocity) {
        if (this.isButtonCombination(ButtonID.DUPLICATE)) {
            IStepInfo noteStep = clip.getStep(notePosition);
            if (noteStep.getState() == StepState.START) {
                this.copyNote = noteStep;
            } else if (this.copyNote != null) {
                clip.setStep(notePosition, this.copyNote);
            }
            return true;
        }
        if (this.isButtonCombination(ButtonID.MUTE)) {
            IStepInfo stepInfo = clip.getStep(notePosition);
            StepState isSet = stepInfo.getState();
            if (isSet == StepState.START) {
                this.getClip().updateStepMuteState(notePosition, !stepInfo.isMuted());
            }
            return true;
        }
        NotePosition np = new NotePosition(notePosition);
        int step = np.getStep();
        int note = np.getNote();
        for (int s = 0; s < step; ++s) {
            StepState state;
            int pad = this.getPadIndex(s);
            IHwButton button = this.surface.getButton(ButtonID.get(this.firstPad, pad));
            if (!button.isLongPressed()) continue;
            button.setConsumed();
            int length = step - s + 1;
            double duration = (double)length * Resolution.getValueAt(this.getResolutionIndex());
            np.setStep(s);
            StepState stepState = state = note < 0 ? StepState.OFF : clip.getStep(np).getState();
            if (state == StepState.START) {
                clip.updateStepDuration(np, duration);
            } else {
                clip.setStep(np, velocity, duration);
            }
            return true;
        }
        return false;
    }

    protected int getPadIndex(int step) {
        int x = step % this.numColumns;
        int y = this.allRows - 1 - step / this.numColumns;
        return y * this.numColumns + x;
    }

    protected void handleLoopArea(int pad, int velocity) {
        boolean isAccentActive = this.configuration.isAccentActive();
        if (isAccentActive) {
            if (velocity == 0) {
                return;
            }
            int selPad = (3 - pad / 4) * 4 + pad % 4;
            this.configuration.setFixedAccentValue((selPad + 1) * 8 - 1);
            return;
        }
        if (velocity > 0) {
            if (this.loopPadPressed == -1) {
                this.loopPadPressed = pad;
            }
            return;
        }
        if (this.loopPadPressed == -1) {
            return;
        }
        INoteClip clip = this.getClip();
        if (pad == this.loopPadPressed && pad != clip.getEditPage()) {
            clip.scrollToPage(pad);
        } else {
            int start = this.loopPadPressed < pad ? this.loopPadPressed : pad;
            int end = (this.loopPadPressed < pad ? pad : this.loopPadPressed) + 1;
            int lengthOfOnePad = this.getLengthOfOnePage(this.sequencerSteps);
            int newStart = start * lengthOfOnePad;
            clip.setLoopStart(newStart);
            clip.setLoopLength((end - start) * lengthOfOnePad);
            clip.setPlayRange(newStart, (double)end * (double)lengthOfOnePad);
        }
        this.loopPadPressed = -1;
    }

    @Override
    public void drawGrid() {
        IPadGrid padGrid = this.surface.getPadGrid();
        if (!this.model.canSelectedTrackHoldNotes()) {
            padGrid.turnOff();
            return;
        }
        IDrumDevice primary = this.getDrumDevice();
        this.drawDrumPads(padGrid, primary.getDrumPadBank());
        if (this.sequencerLines > 0) {
            INoteClip clip = this.getClip();
            boolean isActive = this.isActive();
            this.drawPages(clip, isActive);
            this.drawSequencerSteps(clip, isActive, this.scales.getDrumOffset() + this.selectedPad, this.getPadColor(primary, this.selectedPad));
        }
    }

    protected void drawDrumPads(IPadGrid padGrid, IDrumPadBank drumPadBank) {
        boolean isRecording = this.model.hasRecordingState();
        for (int y = 0; y < this.playRows; ++y) {
            for (int x = 0; x < this.playColumns; ++x) {
                int index = this.playColumns * y + x;
                padGrid.lightEx(x, this.allRows - 1 - y, this.getDrumPadColor(index, drumPadBank, isRecording));
            }
        }
    }

    protected Optional<ColorEx> getPadColor(IDrumDevice primary, int drumPadIndex) {
        if (!primary.hasDrumPads()) {
            return Optional.empty();
        }
        IDrumPad item = primary.getDrumPadBank().getItem(drumPadIndex);
        return item.doesExist() ? Optional.of(item.getColor()) : Optional.empty();
    }

    protected String getDrumPadColor(int index, IDrumPadBank drumPadBank, boolean isRecording) {
        int offsetY = this.scales.getDrumOffset();
        if (this.keyManager.isKeyPressed(offsetY + index)) {
            return isRecording ? COLOR_PAD_RECORD : COLOR_PAD_PLAY;
        }
        if (this.selectedPad == index) {
            return COLOR_PAD_SELECTED;
        }
        IDrumPad drumPad = drumPadBank.getItem(index);
        if (!drumPad.doesExist() || !drumPad.isActivated()) {
            return this.surface.getConfiguration().isTurnOffEmptyDrumPads() ? COLOR_PAD_OFF : COLOR_PAD_NO_CONTENT;
        }
        if (drumPad.isMute() || drumPadBank.hasSoloedPads() && !drumPad.isSolo()) {
            return COLOR_PAD_MUTED;
        }
        return this.getPadContentColor(drumPad);
    }

    protected String getPadContentColor(IChannel drumPad) {
        return this.useDawColors ? DAWColor.getColorID(drumPad.getColor()) : COLOR_PAD_HAS_CONTENT;
    }

    @Override
    public void updateNoteMapping() {
        this.delayedUpdateNoteMapping(this.canPadsBeTurnedOn() ? this.getDrumMatrix() : EMPTY_TABLE);
    }

    protected int[] getDrumMatrix() {
        return this.scales.getDrumMatrix();
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        this.changeOctave(event, false, this.surface.isShiftPressed() ? 4 : this.scales.getDrumDefaultOffset());
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        this.changeOctave(event, true, this.surface.isShiftPressed() ? 4 : this.scales.getDrumDefaultOffset());
    }

    @Override
    public boolean isOctaveUpButtonOn() {
        return this.scales.canScrollDrumOctaveUp();
    }

    @Override
    public boolean isOctaveDownButtonOn() {
        return this.scales.canScrollDrumOctaveDown();
    }

    protected void changeOctave(ButtonEvent event, boolean isUp, int offset) {
        this.changeOctave(event, isUp, offset, false, true);
    }

    public void changeOctave(ButtonEvent event, boolean isUp, int offset, boolean adjustPage, boolean notify) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.keyManager.clearPressedKeys();
        if (isUp) {
            this.scales.incDrumOffset(offset);
        } else {
            this.scales.decDrumOffset(offset);
        }
        this.updateNoteMapping();
        if (notify) {
            this.surface.getDisplay().notify(this.scales.getDrumRangeText());
        }
        this.getDrumDevice().getDrumPadBank().scrollTo(this.scales.getDrumOffset(), adjustPage);
        this.clearEditNotes();
    }

    @Override
    public void resetOctave() {
        this.keyManager.clearPressedKeys();
        this.scales.resetDrumOctave();
        this.updateNoteMapping();
        this.getDrumDevice().getDrumPadBank().scrollTo(this.scales.getDrumOffset(), true);
    }

    protected void playNote(int drumPad, int velocity) {
    }

    protected void handleNoteAreaButtonCombinations(int playedPad) {
        if (this.isDeleteTrigger()) {
            this.handleDeleteButton(playedPad);
            return;
        }
        if (this.isMuteTrigger()) {
            this.handleMuteButton(playedPad);
            return;
        }
        if (this.isSoloTrigger()) {
            this.handleSoloButton(playedPad);
            return;
        }
        if (this.isBrowseTrigger()) {
            this.surface.setTriggerConsumed(this.buttonBrowse);
            IDrumDevice primary = this.getDrumDevice();
            if (!primary.hasDrumPads()) {
                return;
            }
            IDrumPadBank drumPadBank = primary.getDrumPadBank();
            this.scrollPosition = drumPadBank.getScrollPosition();
            this.model.getBrowser().replace(drumPadBank.getItem(playedPad));
            return;
        }
        if (this.isSelectTrigger() || this.configuration.isAutoSelectDrum()) {
            this.handleSelectButton(playedPad);
        }
    }

    protected boolean isSelectTrigger() {
        boolean pressed = this.surface.isPressed(this.buttonSelect);
        if (this.configuration.isCombinationButtonToSoundDrumPads()) {
            return !pressed;
        }
        return pressed;
    }

    protected boolean isBrowseTrigger() {
        return this.surface.isPressed(this.buttonBrowse);
    }

    protected boolean isSoloTrigger() {
        return this.surface.isPressed(this.buttonSolo);
    }

    protected boolean isMuteTrigger() {
        return this.surface.isPressed(this.buttonMute);
    }

    protected boolean isDeleteTrigger() {
        return this.isButtonCombination(this.buttonDelete);
    }

    protected void handleDeleteButton(int playedPad) {
        this.surface.setTriggerConsumed(this.buttonDelete);
        int editMidiChannel = this.configuration.getMidiEditChannel();
        this.getClip().clearRow(editMidiChannel, this.scales.getDrumOffset() + playedPad);
    }

    protected void handleMuteButton(int playedPad) {
        this.surface.setTriggerConsumed(this.buttonMute);
        this.getDrumDevice().getDrumPadBank().getItem(playedPad).toggleMute();
    }

    protected void handleSoloButton(int playedPad) {
        this.surface.setTriggerConsumed(this.buttonSolo);
        this.getDrumDevice().getDrumPadBank().getItem(playedPad).toggleSolo();
    }

    protected void handleSelectButton(int playedPad) {
        this.surface.setTriggerConsumed(this.buttonSelect);
        this.getDrumDevice().getDrumPadBank().getItem(playedPad).select();
    }

    private boolean canPadsBeTurnedOn() {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return false;
        }
        return !this.isSelectTrigger() && !this.isDeleteTrigger() && !this.isMuteTrigger() && !this.isSoloTrigger() && !this.isBrowseTrigger();
    }

    protected void drawSequencerSteps(INoteClip clip, boolean isActive, int noteRow, Optional<ColorEx> rowColor) {
        this.drawSequencerSteps(clip, isActive, noteRow, rowColor, null);
    }

    protected void drawSequencerSteps(INoteClip clip, boolean isActive, int noteRow, Optional<ColorEx> rowColor, IntUnaryOperator yModifier) {
        int step = clip.getCurrentStep();
        int hiStep = this.isInXRange(step) ? step % this.sequencerSteps : -1;
        IPadGrid padGrid = this.surface.getPadGrid();
        List<NotePosition> editNotes = this.getEditNotes();
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), 0, noteRow);
        for (int col = 0; col < this.sequencerSteps; ++col) {
            notePosition.setStep(col);
            IStepInfo stepInfo = clip.getStep(notePosition);
            boolean hilite = col == hiStep;
            int x = col % this.numColumns;
            int y = col / this.numColumns;
            if (yModifier != null) {
                y = yModifier.applyAsInt(y);
            }
            padGrid.lightEx(x, y, isActive ? this.getStepColor(stepInfo, hilite, rowColor, notePosition.getChannel(), col, noteRow, editNotes) : "COLOR_NO_CONTENT");
        }
    }

    protected void drawPages(INoteClip clip, boolean isActive) {
        boolean isAccentActive = this.configuration.isAccentActive();
        if (isAccentActive) {
            int selectedVelocityPad = 15 - this.configuration.getFixedAccentValue() / 8;
            int selY = selectedVelocityPad / 4;
            int selX = selectedVelocityPad % 4;
            selectedVelocityPad = selY * 4 + 3 - selX;
            IPadGrid padGrid = this.surface.getPadGrid();
            for (int pad = 0; pad < 16; ++pad) {
                int x = this.playColumns + pad % this.playColumns;
                int y = this.sequencerLines + pad / this.playColumns;
                padGrid.lightEx(x, y, pad == selectedVelocityPad ? 30 : 33);
            }
            return;
        }
        int step = clip.getCurrentStep();
        int lengthOfOnePad = this.getLengthOfOnePage(this.sequencerSteps);
        double loopStart = clip.getLoopStart();
        int loopStartPad = (int)Math.ceil(loopStart / (double)lengthOfOnePad);
        int loopEndPad = (int)Math.ceil((loopStart + clip.getLoopLength()) / (double)lengthOfOnePad);
        int currentPage = step / this.sequencerSteps;
        int numOfPages = this.getNumberOfAvailablePages();
        IPadGrid padGrid = this.surface.getPadGrid();
        for (int pad = 0; pad < numOfPages; ++pad) {
            int x = this.playColumns + pad % this.playColumns;
            int y = this.sequencerLines + pad / this.playColumns;
            padGrid.lightEx(x, y, isActive ? this.getPageColor(loopStartPad, loopEndPad, currentPage, clip.getEditPage(), pad) : "COLOR_NO_CONTENT");
        }
    }

    protected int getNumberOfAvailablePages() {
        return this.playColumns * this.playRows;
    }

    private void updateNote(int trackIndex, int note, int velocity) {
        Optional sel = this.model.getCurrentTrackBank().getSelectedItem();
        if (sel.isPresent() && ((ITrack)sel.get()).getIndex() == trackIndex) {
            this.keyManager.setKeyPressed(note, velocity);
        }
    }

    public void setSelectedPad(int selectedPad) {
        this.setSelectedPad(selectedPad, 127);
    }

    protected void setSelectedPad(int selectedPad, int velocity) {
        if (this.selectedPad == selectedPad) {
            return;
        }
        this.selectedPad = selectedPad;
        this.clearEditNotes();
        if (velocity > 0) {
            this.getDrumDevice().getDrumPadBank().getItem(selectedPad).select();
        }
    }

    public int getSelectedPad() {
        return this.selectedPad;
    }

    public void repositionBankPage() {
        if (this.scrollPosition >= 0) {
            this.getDrumDevice().getDrumPadBank().scrollTo(this.scrollPosition);
        }
    }

    protected IDrumDevice getDrumDevice() {
        return this.model.getDrumDevice();
    }
}

