/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view.sequencer;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractDrumView;
import java.util.List;
import java.util.Optional;

public abstract class AbstractDrumLaneView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractDrumView<S, C> {
    protected final IDrumDevice primary;
    protected final int lanes;

    protected AbstractDrumLaneView(String name, S surface, IModel model, int lanes, int clipCols, boolean useDawColors) {
        this(name, surface, model, lanes, 8, 8, clipCols, true, useDawColors);
    }

    protected AbstractDrumLaneView(String name, S surface, IModel model, int lanes, int numRows, int numColumns, int clipCols, boolean followSelection, boolean useDawColors) {
        super(name, surface, model, 1, 0, numColumns, 128, clipCols, followSelection, useDawColors);
        this.lanes = lanes;
        this.allRows = numRows;
        this.primary = this.model.getDrumDevice();
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.isActive()) {
            return;
        }
        int index = note - this.surface.getPadGrid().getStartNote();
        int x = index % this.numColumns;
        int y = index / this.numColumns;
        int sound = y % this.lanes + this.scales.getDrumOffset();
        int vel = this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : this.surface.getButton(ButtonID.get(ButtonID.PAD1, index)).getPressedVelocity();
        int step = (this.allRows - 1 - y) / this.lanes * this.numColumns + x;
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), step, sound);
        INoteClip clip = this.getClip();
        if (this.handleSequencerAreaButtonCombinations(clip, notePosition, y, velocity, vel) || this.handleNoteEditor(clip, notePosition, velocity)) {
            return;
        }
        this.handleSequencerArea(velocity, vel, notePosition);
    }

    protected void handleSequencerArea(int velocity, int downVelocity, NotePosition notePosition) {
        if (velocity == 0) {
            this.getClip().toggleStep(notePosition, downVelocity);
        }
    }

    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int row, int velocity, int accentVelocity) {
        if (this.isButtonCombination(ButtonID.DUPLICATE)) {
            if (velocity == 0) {
                IStepInfo noteStep = clip.getStep(notePosition);
                if (noteStep.getState() == StepState.START) {
                    this.copyNote = noteStep;
                } else if (this.copyNote != null) {
                    clip.setStep(notePosition, this.copyNote);
                }
            }
            return true;
        }
        if (this.isButtonCombination(ButtonID.MUTE)) {
            IStepInfo stepInfo;
            StepState isSet;
            if (velocity == 0 && (isSet = (stepInfo = clip.getStep(notePosition)).getState()) == StepState.START) {
                clip.updateStepMuteState(notePosition, !stepInfo.isMuted());
            }
            return true;
        }
        int laneOffset = (this.allRows - row - 1) / this.lanes * this.numColumns;
        int offset = row * this.numColumns;
        NotePosition np = new NotePosition(notePosition);
        int step = np.getStep();
        int note = np.getNote();
        for (int s = 0; s < step; ++s) {
            StepState state;
            IHwButton button = this.surface.getButton(ButtonID.get(ButtonID.PAD1, offset + s));
            if (!button.isLongPressed()) continue;
            int start = s + laneOffset;
            button.setConsumed();
            int length = step - start + 1;
            double duration = (double)length * Resolution.getValueAt(this.getResolutionIndex());
            np.setStep(start);
            StepState stepState = state = note < 0 ? StepState.OFF : clip.getStep(np).getState();
            if (state == StepState.START) {
                clip.updateStepDuration(np, duration);
            } else {
                clip.setStep(np, accentVelocity, duration);
            }
            return true;
        }
        return false;
    }

    @Override
    public void drawGrid() {
        IPadGrid padGrid = this.surface.getPadGrid();
        if (!this.isActive()) {
            padGrid.turnOff();
            return;
        }
        INoteClip clip = this.getClip();
        int step = clip.getCurrentStep();
        int hiStep = this.isInXRange(step) ? step % this.clipCols : -1;
        int offsetY = this.scales.getDrumOffset();
        List<NotePosition> editNotes = this.getEditNotes();
        NotePosition position = new NotePosition(this.configuration.getMidiEditChannel(), 0, 0);
        for (int sound = 0; sound < this.lanes; ++sound) {
            position.setNote(offsetY + sound);
            Optional<ColorEx> drumPadColor = this.getPadColor(this.primary, sound);
            for (int col = 0; col < this.clipCols; ++col) {
                position.setStep(col);
                IStepInfo stepInfo = clip.getStep(position);
                boolean hilite = col == hiStep;
                int x = col % this.numColumns;
                int y = this.lanes - 1 - sound;
                if (col >= this.numColumns) {
                    y += this.lanes;
                }
                padGrid.lightEx(x, y, this.getStepColor(stepInfo, hilite, drumPadColor, position.getChannel(), col, position.getNote(), editNotes));
            }
        }
    }

    @Override
    public void updateNoteMapping() {
        this.surface.setKeyTranslationTable(this.scales.translateMatrixToGrid(EMPTY_TABLE));
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        this.changeOctave(event, false, this.lanes, true, true);
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        this.changeOctave(event, true, this.lanes, true, true);
    }
}

