/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.grid.ILightGuide;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.TransposeView;
import java.util.Arrays;

public abstract class AbstractPlayView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractView<S, C>
implements TransposeView {
    public static final String COLOR_PLAY = "PLAY_VIEW_COLOR_PLAY";
    public static final String COLOR_RECORD = "PLAY_VIEW_COLOR_RECORD";
    public static final String COLOR_OFF = "PLAY_VIEW_COLOR_OFF";
    protected final int[] defaultVelocity;
    protected final boolean useTrackColor;
    private int blockNotes = 0;

    protected AbstractPlayView(S surface, IModel model, boolean useTrackColor) {
        this("Play", surface, model, useTrackColor);
    }

    protected AbstractPlayView(String name, S surface, IModel model, boolean useTrackColor) {
        super(name, surface, model);
        this.useTrackColor = useTrackColor;
        this.defaultVelocity = new int[128];
        for (int i = 0; i < 128; ++i) {
            this.defaultVelocity[i] = i;
        }
        ITrackBank tb = model.getTrackBank();
        tb.addSelectionObserver((index, isSelected) -> this.keyManager.clearPressedKeys());
        tb.addNoteObserver(this.keyManager::call);
    }

    public void setBlockedNotes(int blockNotes) {
        this.blockNotes = blockNotes;
    }

    @Override
    public void drawGrid() {
        this.drawLightGuide(this.surface.getPadGrid());
    }

    protected void drawLightGuide(ILightGuide lightGuide) {
        boolean isKeyboardEnabled = this.model.canSelectedTrackHoldNotes();
        boolean isRecording = this.model.hasRecordingState();
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        int startNote = this.scales.getStartNote();
        int endNote = this.scales.getEndNote();
        for (int i = startNote; i < endNote; ++i) {
            lightGuide.light(i, this.getGridColor(isKeyboardEnabled, isRecording, cursorTrack, i));
        }
    }

    @Override
    public void onGridNote(int key, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int note = this.keyManager.map(key);
        if (note != -1) {
            this.keyManager.setAllKeysPressed(note, velocity);
        }
        this.playNote(note, velocity);
    }

    protected void playNote(int note, int velocity) {
    }

    protected String getGridColor(boolean isKeyboardEnabled, boolean isRecording, ITrack track, int note) {
        if (isKeyboardEnabled) {
            if (this.keyManager.isKeyPressed(note)) {
                return isRecording ? COLOR_RECORD : COLOR_PLAY;
            }
            if (this.surface.getConfiguration().isTurnOffScalePads() && "SCALE_COLOR_NOTE".equals(this.keyManager.getColor(note))) {
                return "SCALE_COLOR_OFF";
            }
            return this.getPadColor(note, this.useTrackColor ? track : null);
        }
        return COLOR_OFF;
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.keyManager.clearPressedKeys();
        this.scales.decOctave();
        this.updateNoteMapping();
        this.surface.getDisplay().notify(this.scales.getRangeText());
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.keyManager.clearPressedKeys();
        this.scales.incOctave();
        this.updateNoteMapping();
        this.surface.getDisplay().notify(this.scales.getRangeText());
    }

    @Override
    public void resetOctave() {
        this.keyManager.clearPressedKeys();
        this.scales.resetOctave();
        this.updateNoteMapping();
    }

    @Override
    public boolean isOctaveDownButtonOn() {
        return this.scales.getOctave() > -4;
    }

    @Override
    public boolean isOctaveUpButtonOn() {
        return this.scales.getOctave() < 4;
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.initMaxVelocity();
    }

    @Override
    public void updateNoteMapping() {
        this.surface.scheduleTask(() -> this.delayedUpdateNoteMapping(this.getMapping()), 100L);
    }

    protected int[] getMapping() {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return EMPTY_TABLE;
        }
        int[] noteMatrix = this.getScaleMatrix();
        if (this.blockNotes > 0) {
            int startNote = this.scales.getStartNote();
            int endNote = this.scales.getEndNote();
            int length = endNote - startNote - this.blockNotes;
            System.arraycopy(noteMatrix, startNote, noteMatrix, startNote + this.blockNotes, length);
            Arrays.fill(noteMatrix, startNote, startNote + 8, -1);
        }
        return noteMatrix;
    }

    protected int[] getScaleMatrix() {
        return this.scales.getNoteMatrix();
    }

    protected void initMaxVelocity() {
        int[] maxVelocity = new int[128];
        Object config = this.surface.getConfiguration();
        Arrays.fill(maxVelocity, Math.min(127, Math.max(0, config.getFixedAccentValue())));
        maxVelocity[0] = 0;
        this.surface.setVelocityTranslationTable(config.isAccentActive() ? maxVelocity : this.defaultVelocity);
    }

    protected void updateScale() {
        this.updateNoteMapping();
        this.scales.updateScaleProperties((Configuration)this.surface.getConfiguration());
    }
}

