/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.scale;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.scale.ChordGrid;
import de.mossgrabers.framework.scale.Scale;
import de.mossgrabers.framework.scale.ScaleGrid;
import de.mossgrabers.framework.scale.ScaleLayout;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class Scales {
    public static final int DRUM_NOTE_LOWER = 4;
    public static final int DRUM_NOTE_UPPER = 100;
    private static final int DRUM_DEFAULT_OFFSET = 16;
    public static final List<String> NOTE_NAMES = List.of("C", "Db", "D", "Eb", "E", "F", "Gb", "G", "Ab", "A", "Bb", "B");
    public static final List<String> BASES = List.of("C", "G", "D", "A", "E", "B", "F", "Bb", "Eb", "Ab", "Db", "Gb");
    private static final int[] OFFSETS = new int[]{0, 7, 2, 9, 4, 11, 5, 10, 3, 8, 1, 6};
    public static final int DRUM_NOTE_START = 36;
    public static final int DRUM_NOTE_END = 100;
    private static final int[] DRUM_MATRIX = new int[]{0, 1, 2, 3, -1, -1, -1, -1, 4, 5, 6, 7, -1, -1, -1, -1, 8, 9, 10, 11, -1, -1, -1, -1, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final int[][] PIANO_MATRIX = new int[][]{{0, 2, 4, 5, 7, 9, 11}, {-1, 1, 3, -1, 6, 8, 10}};
    public static final String SCALE_COLOR_OFF = "SCALE_COLOR_OFF";
    public static final String SCALE_COLOR_OCTAVE = "SCALE_COLOR_OCTAVE";
    public static final String SCALE_COLOR_NOTE = "SCALE_COLOR_NOTE";
    public static final String SCALE_COLOR_OUT_OF_SCALE = "SCALE_COLOR_OUT_OF_SCALE";
    public static final int OCTAVE_RANGE = 4;
    public static final int PIANO_OCTAVE_RANGE = 3;
    public static final int DRUM_OCTAVE_UPPER = 4;
    public static final int DRUM_OCTAVE_LOWER = -2;
    private Scale selectedScale = Scale.MAJOR;
    private int scaleOffset = 0;
    private ScaleLayout scaleLayout = ScaleLayout.FOURTH_UP;
    private ScaleGrid.Orientation orientation = ScaleGrid.Orientation.ORIENT_UP;
    private boolean chromaticOn = false;
    private int scaleShift = 3;
    private int semitoneShift = 5;
    private int octave = 0;
    private final int defaultOctave;
    private int drumOffset;
    private int drumDefaultOffset;
    private int pianoOctave = 0;
    private int startNote;
    private int endNote;
    private final int numColumns;
    private final int numRows;
    private int[] drumMatrix = DRUM_MATRIX;
    private int drumNoteStart = 36;
    private int drumNoteEnd = 100;
    private final Map<Scale, ScaleGrid> scaleGrids = new EnumMap<Scale, ScaleGrid>(Scale.class);
    private final Map<Scale, ChordGrid> chordGrids = new EnumMap<Scale, ChordGrid>(Scale.class);
    private final IValueChanger valueChanger;

    public Scales(IValueChanger valueChanger, int startNote, int endNote, int numColumns, int numRows) {
        this(valueChanger, startNote, endNote, numColumns, numRows, 0);
    }

    public Scales(IValueChanger valueChanger, int startNote, int endNote, int numColumns, int numRows, int defaultOctave) {
        this.valueChanger = valueChanger;
        this.startNote = startNote;
        this.endNote = endNote;
        this.numColumns = numColumns;
        this.numRows = numRows;
        this.octave = this.defaultOctave = defaultOctave;
        this.drumOffset = this.drumNoteStart;
        this.drumDefaultOffset = 16;
        this.generateMatrices();
    }

    public Scale getScale() {
        return this.selectedScale;
    }

    public void setScale(Scale scale) {
        this.selectedScale = scale;
    }

    public void setScaleByName(String scaleName) {
        this.selectedScale = Scale.getByName(scaleName);
    }

    public void changeScale(int control) {
        Scale[] values = Scale.values();
        int index = this.valueChanger.changeValue(control, this.selectedScale.ordinal(), -100.0, values.length);
        this.selectedScale = values[index];
    }

    public boolean hasPrevScale() {
        return this.selectedScale.ordinal() > 0;
    }

    public boolean hasNextScale() {
        return this.selectedScale.ordinal() < Scale.values().length - 1;
    }

    public void prevScale() {
        Scale[] values = Scale.values();
        this.selectedScale = values[Math.max(0, this.selectedScale.ordinal() - 1)];
    }

    public void nextScale() {
        Scale[] values = Scale.values();
        this.selectedScale = values[Math.min(values.length - 1, this.selectedScale.ordinal() + 1)];
    }

    public boolean hasPrevScaleOffset() {
        return this.scaleOffset > 0;
    }

    public boolean hasNextScaleOffset() {
        return this.scaleOffset < OFFSETS.length - 1;
    }

    public void prevScaleOffset() {
        this.setScaleOffsetByIndex(this.scaleOffset - 1);
    }

    public void nextScaleOffset() {
        this.setScaleOffsetByIndex(this.scaleOffset + 1);
    }

    public int getScaleOffset() {
        return OFFSETS[this.scaleOffset];
    }

    public int getScaleOffsetIndex() {
        return this.scaleOffset;
    }

    public void setScaleOffsetByIndex(int scaleOffsetIndex) {
        this.scaleOffset = Math.max(0, Math.min(scaleOffsetIndex, OFFSETS.length - 1));
    }

    public void setScaleOffsetByName(String scaleOffsetName) {
        int index = BASES.indexOf(scaleOffsetName);
        if (index >= 0) {
            this.scaleOffset = index;
        }
    }

    public ScaleLayout getScaleLayout() {
        return this.scaleLayout;
    }

    public void setScaleLayout(ScaleLayout scaleLayout) {
        this.scaleLayout = scaleLayout;
        this.orientation = this.scaleLayout.ordinal() % 2 == 0 ? ScaleGrid.Orientation.ORIENT_UP : ScaleGrid.Orientation.ORIENT_RIGHT;
        switch (this.scaleLayout) {
            case FOURTH_UP: 
            case FOURTH_RIGHT: {
                this.setPlayShift(3, 5);
                break;
            }
            case THIRD_UP: 
            case THIRD_RIGHT: {
                this.setPlayShift(2, 4);
                break;
            }
            case SEQUENT_UP: {
                this.setPlayShift(this.numRows, this.numRows);
                break;
            }
            case SEQUENT_RIGHT: {
                this.setPlayShift(this.numColumns, this.numColumns);
                break;
            }
            case EIGHT_UP: 
            case EIGHT_RIGHT: 
            case EIGHT_UP_CENTER: 
            case EIGHT_RIGHT_CENTER: {
                this.setPlayShift(7, 12);
                break;
            }
            case STAGGERED_UP: 
            case STAGGERED_RIGHT: {
                this.setPlayShift(0, 5);
            }
        }
    }

    public void setScaleLayoutByName(String scaleLayoutName) {
        this.setScaleLayout(ScaleLayout.getByName(scaleLayoutName));
    }

    public boolean hasPrevScaleLayout() {
        return this.scaleLayout.ordinal() > 0;
    }

    public boolean hasNextScaleLayout() {
        return this.scaleLayout.ordinal() < ScaleLayout.values().length - 1;
    }

    public void prevScaleLayout() {
        ScaleLayout[] values = ScaleLayout.values();
        this.scaleLayout = values[Math.max(0, this.scaleLayout.ordinal() - 1)];
    }

    public void nextScaleLayout() {
        ScaleLayout[] values = ScaleLayout.values();
        this.scaleLayout = values[Math.min(values.length - 1, this.scaleLayout.ordinal() + 1)];
    }

    public void setChromatic(boolean enable) {
        this.chromaticOn = enable;
    }

    public void toggleChromatic() {
        this.chromaticOn = !this.chromaticOn;
    }

    public boolean isChromatic() {
        return this.chromaticOn;
    }

    public void setOctave(int octave) {
        this.octave = Math.max(-4, Math.min(octave, 4));
    }

    public int getOctave() {
        return this.octave;
    }

    public void incOctave() {
        this.setOctave(this.octave + 1);
    }

    public void decOctave() {
        this.setOctave(this.octave - 1);
    }

    public void resetOctave() {
        this.setOctave(this.defaultOctave);
    }

    public int getDrumOffset() {
        return this.drumOffset;
    }

    public boolean canScrollDrumOctaveDown() {
        return this.drumOffset - this.drumDefaultOffset >= 4;
    }

    public boolean canScrollDrumOctaveUp() {
        return this.drumOffset + this.drumDefaultOffset <= 100;
    }

    public void incDrumOctave() {
        this.incDrumOffset(this.drumDefaultOffset);
    }

    public void decDrumOctave() {
        this.decDrumOffset(this.drumDefaultOffset);
    }

    public void resetDrumOctave() {
        this.drumOffset = this.drumNoteStart;
    }

    public void incDrumOffset(int offset) {
        this.drumOffset = Math.min(100, this.drumOffset + offset);
    }

    public void decDrumOffset(int offset) {
        this.drumOffset = Math.max(4, this.drumOffset - offset);
    }

    public void setDrumDefaultOffset(int drumDefaultOffset) {
        this.drumDefaultOffset = drumDefaultOffset;
    }

    public int getDrumDefaultOffset() {
        return this.drumDefaultOffset;
    }

    public void setPianoOctave(int octave) {
        this.pianoOctave = Math.max(-3, Math.min(octave, 3));
    }

    public int getPianoOctave() {
        return this.pianoOctave;
    }

    public void incPianoOctave() {
        this.setPianoOctave(this.pianoOctave + 1);
    }

    public void decPianoOctave() {
        this.setPianoOctave(this.pianoOctave - 1);
    }

    public void setPlayShift(int scaleShift, int semitoneShift) {
        this.scaleShift = scaleShift;
        this.semitoneShift = semitoneShift;
        this.generateMatrices();
    }

    public int getScaleShift() {
        return this.scaleShift;
    }

    public int getSemitoneShift() {
        return this.semitoneShift;
    }

    public String getColor(int[] noteMap, int note) {
        if (note == -1) {
            return SCALE_COLOR_OFF;
        }
        int midiNote = noteMap[note];
        if (midiNote == -1) {
            return SCALE_COLOR_OFF;
        }
        int noteInOctave = this.toNoteInOctave(midiNote);
        if (noteInOctave == 0) {
            return SCALE_COLOR_OCTAVE;
        }
        if (!this.isChromatic()) {
            return SCALE_COLOR_NOTE;
        }
        return this.isInScale(noteInOctave) ? SCALE_COLOR_NOTE : SCALE_COLOR_OUT_OF_SCALE;
    }

    public int toNoteInOctave(int midiNote) {
        return (12 + midiNote - OFFSETS[this.scaleOffset]) % 12;
    }

    public boolean isInScale(int noteInOctave) {
        for (int interval : this.selectedScale.getIntervals()) {
            if (interval != noteInOctave) continue;
            return true;
        }
        return false;
    }

    public int getNearestNoteInScale(int midiNote) {
        int noteInOctave = this.toNoteInOctave(midiNote);
        int diff = 12;
        int resultNoteInOctave = 0;
        for (int interval : this.selectedScale.getIntervals()) {
            int newDiff = Math.abs(interval - noteInOctave);
            if (Math.abs(interval - noteInOctave) < diff) {
                diff = newDiff;
                resultNoteInOctave = interval;
            }
            if (diff == 0) break;
        }
        int octaves = midiNote / 12 * 12;
        return octaves + (resultNoteInOctave + OFFSETS[this.scaleOffset]) % 12;
    }

    public int getScaleIndex(int midiNote) {
        int noteInOctave = this.toNoteInOctave(midiNote);
        int[] intervals = this.selectedScale.getIntervals();
        for (int i = 0; i < intervals.length; ++i) {
            if (intervals[i] != noteInOctave) continue;
            return i;
        }
        return -1;
    }

    public int[] getThirdChord(int baseNote) {
        return this.getChord(baseNote, 3, 5);
    }

    public int[] getChord(int baseNote, int ... addedIntervals) {
        int scaleIndex = this.getScaleIndex(baseNote);
        if (scaleIndex < 0) {
            return new int[0];
        }
        int[] intervals = this.selectedScale.getIntervals();
        int[] result = new int[addedIntervals.length];
        int baseOffset = this.startNote + OFFSETS[this.scaleOffset];
        for (int i = 0; i < addedIntervals.length; ++i) {
            int noteIndex = scaleIndex + addedIntervals[i] - 1;
            int octaveNote = intervals[noteIndex % intervals.length];
            result[i] = baseOffset + (this.octave + noteIndex / intervals.length) * 12 + octaveNote;
        }
        return result;
    }

    public int[] getNoteMatrix() {
        return this.getNoteMatrix(this.getActiveMatrix());
    }

    public int[] getNoteMatrix(int[] matrix) {
        int[] noteMap = Scales.getEmptyMatrix();
        for (int note = this.startNote; note < this.endNote; ++note) {
            int n = matrix[note - this.startNote] + OFFSETS[this.scaleOffset] + this.startNote + this.octave * 12;
            noteMap[note] = n < 0 || n > 127 ? -1 : n;
        }
        return noteMap;
    }

    public int[] getSequencerMatrix(int length, int noteOffset) {
        int[] noteMap = new int[length];
        if (this.isChromatic()) {
            for (int note = 0; note < length; ++note) {
                noteMap[note] = noteOffset + note;
            }
            return noteMap;
        }
        int[] intervals = this.selectedScale.getIntervals();
        Arrays.fill(noteMap, -1);
        int noteInOctave = noteOffset % 12;
        Scale scale = this.getScale();
        int so = scale.getIndexInScale(noteInOctave);
        if (so < 0) {
            so = 0;
        }
        int no = noteOffset / 12 * 12;
        for (int note = 0; note < length; ++note) {
            int index = so + note;
            int oct = index / intervals.length * 12;
            int n = OFFSETS[this.scaleOffset] + intervals[index % intervals.length] + no + oct;
            noteMap[note] = n < 0 || n > 127 ? -1 : n;
        }
        return noteMap;
    }

    public int[] getPianoMatrix(int rows, int columns) {
        int octaveOffset = 3 + this.pianoOctave;
        int counter = this.startNote;
        int rowOffset = columns / 7;
        int[] noteMap = Scales.getEmptyMatrix();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                int ns = PIANO_MATRIX[row % 2][col % 7];
                if (ns >= 0 && counter < 128) {
                    noteMap[counter] = Math.min(ns + (octaveOffset + col / 7) * 12, 127);
                }
                ++counter;
            }
            if (row % 2 != 1) continue;
            octaveOffset += rowOffset;
        }
        return noteMap;
    }

    public static int[] getEmptyMatrix() {
        int[] emptyMatrix = new int[128];
        Arrays.fill(emptyMatrix, -1);
        return emptyMatrix;
    }

    public static int[] getIdentityMatrix() {
        int[] identityMatrix = new int[128];
        for (int i = 0; i < 128; ++i) {
            identityMatrix[i] = i;
        }
        return identityMatrix;
    }

    public int[] getDrumMatrix() {
        int[] noteMap = Scales.getEmptyMatrix();
        for (int note = this.drumNoteStart; note < this.drumNoteEnd; ++note) {
            int ns = this.drumMatrix[note - this.drumNoteStart];
            int n = ns == -1 ? -1 : ns + this.drumOffset;
            noteMap[note] = n < 0 || n > 127 ? -1 : n;
        }
        return noteMap;
    }

    public void setDrumMatrix(int[] matrix) {
        this.drumMatrix = matrix;
    }

    public void setDrumNoteStart(int drumNoteStart) {
        this.drumNoteStart = drumNoteStart;
    }

    public void setDrumNoteEnd(int drumNoteEnd) {
        this.drumNoteEnd = drumNoteEnd;
    }

    public String getRangeText() {
        int[] matrix = this.getActiveMatrix();
        int offset = OFFSETS[this.scaleOffset];
        return this.formatNote(offset + matrix[0]) + " to " + this.formatNote(offset + matrix[matrix.length - 1]);
    }

    public static String getSequencerRangeText(int from, int to) {
        return Scales.formatNoteAndOctave(from, -3) + " to " + Scales.formatNoteAndOctave(to, -3);
    }

    public String getDrumRangeText() {
        int s = this.getDrumOffset();
        return "Offset: " + (s - this.drumNoteStart) + " (" + Scales.formatDrumNote(s) + ")";
    }

    public String getPianoRangeText() {
        return this.formatNote(this.pianoOctave * 12) + " to " + this.formatNote((this.pianoOctave + 4) * 12);
    }

    public String formatNote(int note) {
        return Scales.formatNoteAndOctave(note, this.octave);
    }

    public static String formatDrumNote(int note) {
        return Scales.formatNoteAndOctave(note, -3);
    }

    public static String formatNoteAndOctave(int note, int octaveOffset) {
        return NOTE_NAMES.get(Math.abs(note % 12)) + Integer.toString(note / 12 + octaveOffset + 1);
    }

    public int[] getActiveMatrix() {
        ScaleGrid scaleGrid = this.scaleGrids.get((Object)this.selectedScale);
        return this.isChromatic() ? scaleGrid.getChromatic() : scaleGrid.getMatrix();
    }

    public int[] getActiveChordMatrix() {
        return this.chordGrids.get((Object)this.selectedScale).getMatrix();
    }

    public int[] translateMatrixToGrid(int[] matrix) {
        return matrix;
    }

    private void generateMatrices() {
        this.scaleGrids.clear();
        this.chordGrids.clear();
        for (Scale scale : Scale.values()) {
            this.scaleGrids.put(scale, new ScaleGrid(scale, this.scaleLayout, this.orientation, this.numRows, this.numColumns, this.scaleShift, this.semitoneShift));
            this.chordGrids.put(scale, new ChordGrid(scale, this.numRows, this.numColumns));
        }
    }

    public int getStartNote() {
        return this.startNote;
    }

    public void setStartNote(int startNote) {
        this.startNote = startNote;
    }

    public int getEndNote() {
        return this.endNote;
    }

    public void setEndNote(int endNote) {
        this.endNote = endNote;
    }

    public void updateScaleProperties(Configuration configuration) {
        String name = this.getScale().getName();
        if (!configuration.getScale().equals(name)) {
            configuration.setScale(name);
        }
        String scaleBase = BASES.get(this.getScaleOffsetIndex());
        if (!configuration.getScaleBase().equals(scaleBase)) {
            configuration.setScaleBase(scaleBase);
        }
        boolean isChromatic = this.isChromatic();
        if (configuration.isScaleInKey() == isChromatic) {
            configuration.setScaleInKey(!isChromatic);
        }
        String scaleLayoutName = this.getScaleLayout().getName();
        if (!configuration.getScaleLayout().equals(scaleLayoutName)) {
            configuration.setScaleLayout(scaleLayoutName);
        }
    }

    public int getDefaultOctave() {
        return this.defaultOctave;
    }
}

