/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameterprovider.track;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.data.empty.EmptyParameter;
import de.mossgrabers.framework.daw.data.empty.EmptySend;
import de.mossgrabers.framework.observer.IItemSelectionObserver;
import de.mossgrabers.framework.observer.IParametersAdjustObserver;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.track.AbstractTrackParameterProvider;
import java.util.Optional;

public class SelectedTrackParameterProvider
extends AbstractTrackParameterProvider
implements IItemSelectionObserver {
    public SelectedTrackParameterProvider(ITrackBank bank) {
        super(bank);
    }

    public SelectedTrackParameterProvider(IModel model) {
        super(model);
    }

    @Override
    public IParameter get(int index) {
        Optional selectedTrack = this.bank.getSelectedItem();
        return selectedTrack.isEmpty() ? EmptyParameter.INSTANCE : this.getInternal(index, (IChannel)selectedTrack.get());
    }

    @Override
    public Optional<ColorEx> getColor(int index) {
        Optional selectedTrack = this.bank.getSelectedItem();
        if (selectedTrack.isEmpty()) {
            return Optional.empty();
        }
        ITrack channel = (ITrack)selectedTrack.get();
        if (index < 2) {
            return Optional.of(channel.getColor());
        }
        return Optional.ofNullable(this.getSend(index - 2, channel).getColor());
    }

    @Override
    public void addParametersObserver(IParametersAdjustObserver observer) {
        super.addParametersObserver(observer);
        if (this.model == null) {
            this.bank.addSelectionObserver(this);
            return;
        }
        this.model.getTrackBank().addSelectionObserver(this);
        ITrackBank effectTrackBank = this.model.getEffectTrackBank();
        if (effectTrackBank != null) {
            effectTrackBank.addSelectionObserver(this);
        }
    }

    @Override
    public void removeParametersObserver(IParametersAdjustObserver observer) {
        super.removeParametersObserver(observer);
        if (this.hasObservers()) {
            return;
        }
        if (this.model == null) {
            this.bank.removeSelectionObserver(this);
            return;
        }
        this.model.getTrackBank().removeSelectionObserver(this);
        ITrackBank effectTrackBank = this.model.getEffectTrackBank();
        if (effectTrackBank != null) {
            effectTrackBank.removeSelectionObserver(this);
        }
    }

    @Override
    public void call(int index, boolean isSelected) {
        this.notifyParametersObservers();
    }

    protected IParameter getInternal(int index, IChannel selectedChannel) {
        switch (index) {
            case 0: {
                return selectedChannel.getVolumeParameter();
            }
            case 1: {
                return selectedChannel.getPanParameter();
            }
        }
        return this.getSend(index - 2, selectedChannel);
    }

    protected ISend getSend(int sendIndex, IChannel selectedChannel) {
        try {
            return this.getSend(sendIndex, selectedChannel.getSendBank());
        }
        catch (IndexOutOfBoundsException ex) {
            return EmptySend.INSTANCE;
        }
    }

    protected ISend getSend(int sendIndex, ISendBank sendBank) {
        return (ISend)sendBank.getItem(sendIndex);
    }
}

