/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameterprovider.device;

import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.bank.IChannelBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.empty.EmptyParameter;
import de.mossgrabers.framework.observer.IItemSelectionObserver;
import de.mossgrabers.framework.observer.IParametersAdjustObserver;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.AbstractChannelParameterProvider;
import java.util.Optional;

public class AbstractSelectedChannelParameterProvider<B extends IChannelBank<C>, C extends IChannel>
extends AbstractChannelParameterProvider<B, C>
implements IItemSelectionObserver {
    public AbstractSelectedChannelParameterProvider(B bank) {
        super(bank);
    }

    @Override
    public IParameter get(int index) {
        Optional selectedTrack = this.bank.getSelectedItem();
        return selectedTrack.isEmpty() ? EmptyParameter.INSTANCE : this.getInternal(index, (IChannel)selectedTrack.get());
    }

    @Override
    public void addParametersObserver(IParametersAdjustObserver observer) {
        super.addParametersObserver(observer);
        this.bank.addSelectionObserver(this);
    }

    @Override
    public void removeParametersObserver(IParametersAdjustObserver observer) {
        super.removeParametersObserver(observer);
        if (!this.hasObservers()) {
            this.bank.removeSelectionObserver(this);
        }
    }

    @Override
    public void call(int index, boolean isSelected) {
        this.notifyParametersObservers();
    }

    protected IParameter getInternal(int index, IChannel selectedChannel) {
        switch (index) {
            case 0: {
                return selectedChannel.getVolumeParameter();
            }
            case 1: {
                return selectedChannel.getPanParameter();
            }
        }
        return this.handleSends(index - 2, selectedChannel);
    }

    protected IParameter handleSends(int sendIndex, IChannel selectedChannel) {
        try {
            return this.getSend(sendIndex, selectedChannel.getSendBank());
        }
        catch (IndexOutOfBoundsException ex) {
            return EmptyParameter.INSTANCE;
        }
    }

    protected ISend getSend(int sendIndex, ISendBank sendBank) {
        return (ISend)sendBank.getItem(sendIndex);
    }
}

