/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameter;

import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.observer.IValueObserver;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.StringUtils;

public class ResetParameter
implements IParameter {
    private final IParameter parameter;

    public ResetParameter(IParameter parameter) {
        this.parameter = parameter;
    }

    @Override
    public void setValue(int value) {
        this.parameter.resetValue();
    }

    @Override
    public void setValue(IValueChanger valueChanger, int value) {
        this.parameter.resetValue();
    }

    @Override
    public int getValue() {
        return this.parameter.getValue();
    }

    @Override
    public void setNormalizedValue(double value) {
        this.parameter.resetValue();
    }

    @Override
    public void setValueImmediatly(int value) {
        this.parameter.resetValue();
    }

    @Override
    public void changeValue(int control) {
        this.parameter.resetValue();
    }

    @Override
    public void changeValue(IValueChanger valueChanger, int control) {
        this.parameter.resetValue();
    }

    @Override
    public void resetValue() {
        this.parameter.resetValue();
    }

    @Override
    public String getName() {
        return "Reset " + this.parameter.getName();
    }

    @Override
    public void setName(String name) {
        this.parameter.setName(name);
    }

    @Override
    public boolean doesExist() {
        return this.parameter.doesExist();
    }

    @Override
    public int getIndex() {
        return this.parameter.getIndex();
    }

    @Override
    public int getPosition() {
        return this.parameter.getPosition();
    }

    @Override
    public boolean isSelected() {
        return this.parameter.isSelected();
    }

    @Override
    public void setSelected(boolean isSelected) {
        this.parameter.setSelected(isSelected);
    }

    @Override
    public void select() {
        this.parameter.select();
    }

    @Override
    public void toggleMultiSelect() {
        this.parameter.toggleMultiSelect();
    }

    @Override
    public String getName(int limit) {
        return StringUtils.optimizeName(this.getName(), limit);
    }

    @Override
    public void addNameObserver(IValueObserver<String> observer) {
        this.parameter.addNameObserver(observer);
    }

    @Override
    public void enableObservers(boolean enable) {
        this.parameter.enableObservers(enable);
    }

    @Override
    public void inc(double increment) {
        this.parameter.resetValue();
    }

    @Override
    public String getDisplayedValue() {
        return this.parameter.getDisplayedValue();
    }

    @Override
    public String getDisplayedValue(int limit) {
        return this.parameter.getDisplayedValue(limit);
    }

    @Override
    public void touchValue(boolean isBeingTouched) {
        this.parameter.touchValue(isBeingTouched);
    }

    @Override
    public int getModulatedValue() {
        return this.parameter.getModulatedValue();
    }

    @Override
    public void setIndication(boolean enable) {
        this.parameter.setIndication(enable);
    }
}

