/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameter;

import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NoteOccurrenceType;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.mode.INoteEditor;
import de.mossgrabers.framework.parameter.AbstractParameterImpl;
import de.mossgrabers.framework.parameter.NoteAttribute;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class NoteParameter
extends AbstractParameterImpl {
    private final IHost host;
    private final ITransport transport;
    private final INoteEditor callback;
    private final IDisplay display;
    private final Scales scales;
    private final NoteAttribute noteAttribute;
    private final int parameterIndex;
    private static final Map<NoteAttribute, String> ATTRIBUTE_NAMES = new EnumMap<NoteAttribute, String>(NoteAttribute.class);

    public NoteParameter(NoteAttribute noteAttribute, IDisplay display, IModel model, INoteEditor callback, IValueChanger valueChanger) {
        this(-1, noteAttribute, display, model, callback, valueChanger);
    }

    public NoteParameter(int parameterIndex, NoteAttribute noteAttribute, IDisplay display, IModel model, INoteEditor callback, IValueChanger valueChanger) {
        super(valueChanger, 0);
        this.parameterIndex = parameterIndex;
        this.noteAttribute = noteAttribute;
        this.display = display;
        this.host = model.getHost();
        this.transport = model.getTransport();
        this.scales = model.getScales();
        this.callback = callback;
    }

    @Override
    public int getValue() {
        INoteClip clip = this.callback.getClip();
        List<NotePosition> notePositions = this.callback.getNotePosition(this.parameterIndex);
        if (notePositions.isEmpty()) {
            return 0;
        }
        NotePosition notePosition = notePositions.get(0);
        if (notePosition.getNote() == -1) {
            return 0;
        }
        IStepInfo stepInfo = clip.getStep(notePosition);
        if (stepInfo.getState() == StepState.OFF || !this.host.supports(this.noteAttribute)) {
            return 0;
        }
        double normalizedValue = 0.0;
        switch (this.noteAttribute) {
            case PITCH: {
                normalizedValue = (double)notePosition.getNote() / 127.0;
                break;
            }
            case GAIN: {
                normalizedValue = stepInfo.getGain();
                break;
            }
            case PANORAMA: {
                normalizedValue = (stepInfo.getPan() + 1.0) / 2.0;
                break;
            }
            case DURATION: {
                normalizedValue = stepInfo.getDuration();
                break;
            }
            case VELOCITY: {
                normalizedValue = stepInfo.getVelocity();
                break;
            }
            case RELEASE_VELOCITY: {
                normalizedValue = stepInfo.getReleaseVelocity();
                break;
            }
            case VELOCITY_SPREAD: {
                normalizedValue = stepInfo.getVelocitySpread();
                break;
            }
            case MUTE: {
                normalizedValue = stepInfo.isMuted() ? 1.0 : 0.0;
                break;
            }
            case PRESSURE: {
                normalizedValue = stepInfo.getPressure();
                break;
            }
            case TIMBRE: {
                normalizedValue = stepInfo.getTimbre();
                break;
            }
            case TRANSPOSE: {
                double transposeRange = clip.getStepTransposeRange();
                normalizedValue = (stepInfo.getTranspose() + transposeRange) / (2.0 * transposeRange);
                break;
            }
            case CHANCE: {
                normalizedValue = stepInfo.getChance();
                break;
            }
            case REPEAT: {
                normalizedValue = ((double)stepInfo.getRepeatCount() + 127.0) / 254.0;
                break;
            }
            case REPEAT_CURVE: {
                normalizedValue = stepInfo.getRepeatCurve();
                break;
            }
            case REPEAT_VELOCITY_CURVE: {
                normalizedValue = stepInfo.getRepeatVelocityCurve();
                break;
            }
            case REPEAT_VELOCITY_END: {
                normalizedValue = (stepInfo.getRepeatVelocityEnd() + 1.0) / 2.0;
                break;
            }
            case OCCURRENCE: {
                int occurrence = stepInfo.getOccurrence().ordinal();
                normalizedValue = (double)occurrence / (double)NoteOccurrenceType.values().length;
                break;
            }
            case RECURRENCE_LENGTH: {
                int recurrence = stepInfo.getRecurrenceLength() - 1;
                normalizedValue = (double)recurrence / 7.0;
                break;
            }
        }
        return this.valueChanger.fromNormalizedValue(normalizedValue);
    }

    @Override
    public void setValue(IValueChanger valueChanger, int value) {
        this.setNormalizedValue(valueChanger.toNormalizedValue(value));
    }

    @Override
    public void setNormalizedValue(double normalizedValue) {
        if (!this.host.supports(this.noteAttribute)) {
            return;
        }
        INoteClip clip = this.callback.getClip();
        for (NotePosition notePosition : this.callback.getNotePosition(this.parameterIndex)) {
            IStepInfo stepInfo = clip.getStep(notePosition);
            if (stepInfo.getState() == StepState.OFF) {
                return;
            }
            switch (this.noteAttribute) {
                case PITCH: {
                    int newNote = (int)Math.round(normalizedValue * 126.0);
                    if (!this.scales.isChromatic()) {
                        newNote = this.scales.getNearestNoteInScale(newNote);
                    }
                    clip.moveStepY(notePosition, newNote);
                    this.notify("Note: %s", Scales.formatNoteAndOctave(newNote, -3));
                    break;
                }
                case GAIN: {
                    clip.updateStepGain(notePosition, normalizedValue);
                    this.notify("Gain: %s", StringUtils.formatPercentage(normalizedValue));
                    break;
                }
                case PANORAMA: {
                    double pan = normalizedValue * 2.0 - 1.0;
                    clip.updateStepPan(notePosition, pan);
                    this.notify("Panorama: %s", StringUtils.formatPercentage(pan));
                    break;
                }
                case DURATION: {
                    double duration = (double)Math.round(normalizedValue * 16.0 / 0.125) * 0.125;
                    clip.updateStepDuration(notePosition, duration);
                    this.notify("Duration: %s", this.formatLength(duration));
                    break;
                }
                case VELOCITY: {
                    clip.updateStepVelocity(notePosition, normalizedValue);
                    this.notify("Velocity: %s", StringUtils.formatPercentage(normalizedValue));
                    break;
                }
                case RELEASE_VELOCITY: {
                    clip.updateStepReleaseVelocity(notePosition, normalizedValue);
                    this.notify("Release Velocity: %s", StringUtils.formatPercentage(normalizedValue));
                    break;
                }
                case VELOCITY_SPREAD: {
                    clip.updateStepVelocitySpread(notePosition, normalizedValue);
                    this.notify("Velocity Spread: %d%%", (int)Math.round(normalizedValue * 100.0));
                    break;
                }
                case MUTE: {
                    boolean isMuted = normalizedValue > 0.5;
                    clip.updateStepMuteState(notePosition, isMuted);
                    this.notify("Muted: %s", isMuted ? "Yes" : "No");
                    break;
                }
                case PRESSURE: {
                    clip.updateStepPressure(notePosition, normalizedValue);
                    this.notify("Pressure: %s", StringUtils.formatPercentage(normalizedValue));
                    break;
                }
                case TIMBRE: {
                    clip.updateStepTimbre(notePosition, normalizedValue);
                    this.notify("Timbre: %s", StringUtils.formatPercentage(normalizedValue));
                    break;
                }
                case TRANSPOSE: {
                    double transposeRange = clip.getStepTransposeRange();
                    double v = normalizedValue * 2.0 * transposeRange - transposeRange;
                    clip.updateStepTranspose(notePosition, v);
                    this.delayedNotify("Pitch: %s", () -> String.format("%.1f", v));
                    break;
                }
                case CHANCE: {
                    clip.updateStepChance(notePosition, normalizedValue);
                    this.notify("Chance: %s", StringUtils.formatPercentage(stepInfo.getChance()));
                    break;
                }
                case REPEAT: {
                    clip.updateStepRepeatCount(notePosition, (int)Math.round((normalizedValue - 0.5) * 30.0));
                    this.notify("Repeat: %s", stepInfo.getFormattedRepeatCount());
                    break;
                }
                case REPEAT_CURVE: {
                    throw new UnsupportedOperationException();
                }
                case REPEAT_VELOCITY_CURVE: {
                    throw new UnsupportedOperationException();
                }
                case REPEAT_VELOCITY_END: {
                    throw new UnsupportedOperationException();
                }
                case OCCURRENCE: {
                    throw new UnsupportedOperationException();
                }
                case RECURRENCE_LENGTH: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    @Override
    public void changeValue(IValueChanger valueChanger, int value) {
        if (!this.host.supports(this.noteAttribute)) {
            return;
        }
        INoteClip clip = this.callback.getClip();
        for (NotePosition notePosition : this.callback.getNotePosition(this.parameterIndex)) {
            IStepInfo stepInfo = clip.getStep(notePosition);
            if (stepInfo.getState() == StepState.OFF) {
                return;
            }
            switch (this.noteAttribute) {
                case PITCH: {
                    int offset = this.valueChanger.isIncrease(value) ? 1 : -1;
                    int newNote = notePosition.getNote();
                    boolean isChromatic = this.scales.isChromatic();
                    do {
                        if ((newNote += offset) >= 0 && newNote <= 127) continue;
                        return;
                    } while (!isChromatic && !this.scales.isInScale(this.scales.toNoteInOctave(newNote)));
                    clip.moveStepY(notePosition, newNote);
                    this.notify("Note: %s", Scales.formatNoteAndOctave(newNote, -3));
                    break;
                }
                case GAIN: {
                    clip.changeStepGain(notePosition, value);
                    this.delayedNotify("Gain: %s", () -> StringUtils.formatPercentage(stepInfo.getGain()));
                    break;
                }
                case PANORAMA: {
                    clip.changeStepPan(notePosition, value);
                    this.delayedNotify("Pan: %s", () -> StringUtils.formatPercentage(stepInfo.getPan()));
                    break;
                }
                case DURATION: {
                    clip.changeStepDuration(notePosition, value);
                    this.delayedNotify("Duration: %s", () -> this.formatLength(stepInfo.getDuration()));
                    break;
                }
                case VELOCITY: {
                    clip.changeStepVelocity(notePosition, value);
                    this.delayedNotify("Velocity: %s", () -> StringUtils.formatPercentage(stepInfo.getVelocity()));
                    break;
                }
                case RELEASE_VELOCITY: {
                    clip.changeStepReleaseVelocity(notePosition, value);
                    this.delayedNotify("Release Velocity: %s", () -> StringUtils.formatPercentage(stepInfo.getReleaseVelocity()));
                    break;
                }
                case VELOCITY_SPREAD: {
                    clip.changeStepVelocitySpread(notePosition, value);
                    this.delayedNotify("Vel. Spread: %s", () -> StringUtils.formatPercentage(stepInfo.getVelocitySpread()));
                    break;
                }
                case MUTE: {
                    clip.changeStepMuteState(notePosition, value);
                    this.delayedNotify("Mute: %s", () -> stepInfo.isMuted() ? "Yes" : "No");
                    break;
                }
                case PRESSURE: {
                    clip.changeStepPressure(notePosition, value);
                    this.delayedNotify("Pressure: %s", () -> StringUtils.formatPercentage(stepInfo.getPressure()));
                    break;
                }
                case TIMBRE: {
                    clip.changeStepTimbre(notePosition, value);
                    this.delayedNotify("Timbre: %s", () -> StringUtils.formatPercentage(stepInfo.getTimbre()));
                    break;
                }
                case TRANSPOSE: {
                    clip.changeStepTranspose(notePosition, value);
                    this.delayedNotify("Pitch: %s", () -> String.format("%.1f", stepInfo.getTranspose()));
                    break;
                }
                case CHANCE: {
                    clip.changeStepChance(notePosition, value);
                    this.delayedNotify("Chance: %s", () -> StringUtils.formatPercentage(stepInfo.getChance()));
                    break;
                }
                case REPEAT: {
                    clip.changeStepRepeatCount(notePosition, value);
                    this.delayedNotify("Repeat: %s", stepInfo::getFormattedRepeatCount);
                    break;
                }
                case REPEAT_CURVE: {
                    clip.changeStepRepeatCurve(notePosition, value);
                    this.delayedNotify("Curve: %s", () -> StringUtils.formatPercentage(stepInfo.getRepeatCurve()));
                    break;
                }
                case REPEAT_VELOCITY_CURVE: {
                    clip.changeStepRepeatVelocityCurve(notePosition, value);
                    this.delayedNotify("Vel-Crve: %s", () -> StringUtils.formatPercentage(stepInfo.getRepeatVelocityCurve()));
                    break;
                }
                case REPEAT_VELOCITY_END: {
                    clip.changeStepRepeatVelocityEnd(notePosition, value);
                    this.delayedNotify("Vel. End: %s", () -> StringUtils.formatPercentage(stepInfo.getRepeatVelocityEnd()));
                    break;
                }
                case OCCURRENCE: {
                    boolean increase = this.valueChanger.isIncrease(value);
                    clip.setStepPrevNextOccurrence(notePosition, increase);
                    this.delayedNotify("Occurrence: %s", () -> stepInfo.getOccurrence().getName());
                    break;
                }
                case RECURRENCE_LENGTH: {
                    clip.changeStepRecurrenceLength(notePosition, value);
                    int recurrence = stepInfo.getRecurrenceLength();
                    this.delayedNotify("Recurrence: %s", () -> recurrence < 2 ? "Off" : Integer.toString(recurrence));
                }
            }
        }
    }

    @Override
    public void setValueImmediatly(int value) {
        this.setValue(value);
    }

    @Override
    public void inc(double increment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetValue() {
        if (!this.host.supports(this.noteAttribute)) {
            return;
        }
        INoteClip clip = this.callback.getClip();
        for (NotePosition notePosition : this.callback.getNotePosition(this.parameterIndex)) {
            IStepInfo stepInfo = clip.getStep(notePosition);
            if (stepInfo.getState() == StepState.OFF) {
                return;
            }
            switch (this.noteAttribute) {
                case PITCH: {
                    int newNote = 60 + this.scales.getScaleOffset();
                    clip.moveStepY(notePosition, newNote);
                    this.notify("Note: %s", Scales.formatNoteAndOctave(newNote, -3));
                    break;
                }
                case GAIN: {
                    clip.updateStepGain(notePosition, 0.5);
                    break;
                }
                case PANORAMA: {
                    clip.updateStepPan(notePosition, 0.0);
                    break;
                }
                case DURATION: {
                    clip.updateStepDuration(notePosition, 1.0);
                    break;
                }
                case VELOCITY: {
                    clip.updateStepVelocity(notePosition, 1.0);
                    break;
                }
                case RELEASE_VELOCITY: {
                    clip.updateStepReleaseVelocity(notePosition, 1.0);
                    break;
                }
                case VELOCITY_SPREAD: {
                    clip.updateStepVelocitySpread(notePosition, 0.0);
                    break;
                }
                case MUTE: {
                    clip.updateStepMuteState(notePosition, false);
                    break;
                }
                case PRESSURE: {
                    clip.updateStepPressure(notePosition, 0.0);
                    break;
                }
                case TIMBRE: {
                    clip.updateStepTimbre(notePosition, 0.0);
                    break;
                }
                case TRANSPOSE: {
                    clip.updateStepTranspose(notePosition, 0.0);
                    break;
                }
                case CHANCE: {
                    clip.updateStepChance(notePosition, 1.0);
                    break;
                }
                case REPEAT: {
                    clip.updateStepRepeatCount(notePosition, 0);
                    break;
                }
                case REPEAT_CURVE: {
                    clip.updateStepRepeatCurve(notePosition, 0.0);
                    break;
                }
                case REPEAT_VELOCITY_CURVE: {
                    clip.updateStepRepeatVelocityCurve(notePosition, 0.0);
                    break;
                }
                case REPEAT_VELOCITY_END: {
                    clip.updateStepRepeatVelocityEnd(notePosition, 0.0);
                    break;
                }
                case OCCURRENCE: {
                    clip.setStepOccurrence(notePosition, NoteOccurrenceType.ALWAYS);
                    break;
                }
                case RECURRENCE_LENGTH: {
                    clip.updateStepRecurrenceLength(notePosition, 1);
                }
            }
        }
    }

    @Override
    public String getDisplayedValue() {
        if (!this.host.supports(this.noteAttribute)) {
            return "";
        }
        INoteClip clip = this.callback.getClip();
        List<NotePosition> notePositions = this.callback.getNotePosition(this.parameterIndex);
        if (notePositions.isEmpty()) {
            return "";
        }
        NotePosition notePosition = notePositions.get(0);
        IStepInfo stepInfo = clip.getStep(notePosition);
        if (stepInfo.getState() == StepState.OFF) {
            return "";
        }
        switch (this.noteAttribute) {
            case PITCH: {
                return Scales.formatNoteAndOctave(notePosition.getNote(), -3);
            }
            case GAIN: {
                return StringUtils.formatPercentage(stepInfo.getGain());
            }
            case PANORAMA: {
                return StringUtils.formatPercentage(stepInfo.getPan());
            }
            case DURATION: {
                return this.formatLength(stepInfo.getDuration());
            }
            case VELOCITY: {
                return StringUtils.formatPercentage(stepInfo.getVelocity());
            }
            case RELEASE_VELOCITY: {
                return StringUtils.formatPercentage(stepInfo.getReleaseVelocity());
            }
            case VELOCITY_SPREAD: {
                return StringUtils.formatPercentage(stepInfo.getVelocitySpread());
            }
            case MUTE: {
                return String.format("Mute: %s", stepInfo.isMuted() ? "Yes" : "No");
            }
            case PRESSURE: {
                return StringUtils.formatPercentage(stepInfo.getPressure());
            }
            case TIMBRE: {
                return StringUtils.formatPercentage(stepInfo.getTimbre());
            }
            case TRANSPOSE: {
                return String.format("%.1f", stepInfo.getTranspose());
            }
            case CHANCE: {
                return StringUtils.formatPercentage(stepInfo.getChance());
            }
            case REPEAT: {
                return stepInfo.getFormattedRepeatCount();
            }
            case REPEAT_CURVE: {
                return StringUtils.formatPercentage(stepInfo.getRepeatCurve());
            }
            case REPEAT_VELOCITY_CURVE: {
                return StringUtils.formatPercentage(stepInfo.getRepeatVelocityCurve());
            }
            case REPEAT_VELOCITY_END: {
                return StringUtils.formatPercentage(stepInfo.getRepeatVelocityEnd());
            }
            case OCCURRENCE: {
                return stepInfo.getOccurrence().getName();
            }
            case RECURRENCE_LENGTH: {
                int recurrence = stepInfo.getRecurrenceLength();
                return recurrence < 2 ? "Off" : Integer.toString(recurrence);
            }
        }
        return "";
    }

    @Override
    public boolean doesExist() {
        return !this.callback.getNotePosition(this.parameterIndex).isEmpty();
    }

    @Override
    public String getName() {
        return ATTRIBUTE_NAMES.get((Object)this.noteAttribute);
    }

    private void notify(String format, Object ... args) {
        if (this.display != null) {
            this.display.notify(String.format(format, args));
        }
    }

    private void delayedNotify(String format, Supplier<String> supplier) {
        if (this.display != null) {
            this.host.scheduleTask(() -> this.display.notify(String.format(format, supplier.get())), 10L);
        }
    }

    private String formatLength(double duration) {
        return StringUtils.formatMeasures(this.transport.getQuartersPerMeasure(), duration, 0, true);
    }

    static {
        ATTRIBUTE_NAMES.put(NoteAttribute.PITCH, "Pitch");
        ATTRIBUTE_NAMES.put(NoteAttribute.GAIN, "Gain");
        ATTRIBUTE_NAMES.put(NoteAttribute.PANORAMA, "Panorama");
        ATTRIBUTE_NAMES.put(NoteAttribute.DURATION, "Duration");
        ATTRIBUTE_NAMES.put(NoteAttribute.VELOCITY, "Velocity");
        ATTRIBUTE_NAMES.put(NoteAttribute.RELEASE_VELOCITY, "Release Velocity");
        ATTRIBUTE_NAMES.put(NoteAttribute.VELOCITY_SPREAD, "Velocity Spread");
        ATTRIBUTE_NAMES.put(NoteAttribute.MUTE, "Mute");
        ATTRIBUTE_NAMES.put(NoteAttribute.PRESSURE, "Pressure");
        ATTRIBUTE_NAMES.put(NoteAttribute.TIMBRE, "Timbre");
        ATTRIBUTE_NAMES.put(NoteAttribute.TRANSPOSE, "Transpose");
        ATTRIBUTE_NAMES.put(NoteAttribute.CHANCE, "Chance");
        ATTRIBUTE_NAMES.put(NoteAttribute.REPEAT, "Repeat");
        ATTRIBUTE_NAMES.put(NoteAttribute.REPEAT_CURVE, "Repeat Curve");
        ATTRIBUTE_NAMES.put(NoteAttribute.REPEAT_VELOCITY_CURVE, "Repeat Velocity Curve");
        ATTRIBUTE_NAMES.put(NoteAttribute.REPEAT_VELOCITY_END, "Repeat Velocity End");
        ATTRIBUTE_NAMES.put(NoteAttribute.OCCURRENCE, "Occurrence");
        ATTRIBUTE_NAMES.put(NoteAttribute.RECURRENCE_LENGTH, "Recurrence");
    }
}

