/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.mode.track;

import de.mossgrabers.framework.command.trigger.clip.TemporaryNewCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IClipLauncherNavigator;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;

public abstract class DefaultTrackMode<S extends IControlSurface<C>, C extends Configuration>
extends AbstractParameterMode<S, C, ITrack> {
    protected final IClipLauncherNavigator clipLauncherNavigator;

    protected DefaultTrackMode(String name, S surface, IModel model, boolean isAbsolute) {
        this(name, surface, model, isAbsolute, (List<ContinuousID>)null);
    }

    protected DefaultTrackMode(String name, S surface, IModel model, boolean isAbsolute, List<ContinuousID> controls) {
        this(name, surface, model, isAbsolute, controls, () -> surface.isShiftPressed());
    }

    protected DefaultTrackMode(String name, S surface, IModel model, boolean isAbsolute, List<ContinuousID> controls, BooleanSupplier isAlternativeFunction) {
        super(name, surface, model, isAbsolute, model.getCurrentTrackBank(), controls, isAlternativeFunction);
        this.clipLauncherNavigator = this.model.getClipLauncherNavigator();
        model.addTrackBankObserver(x$0 -> this.switchBanks(x$0));
    }

    @Override
    public Optional<String> getSelectedItemName() {
        Optional selectedItem = this.model.getCurrentTrackBank().getSelectedItem();
        if (selectedItem.isEmpty()) {
            return Optional.empty();
        }
        ITrack track = (ITrack)selectedItem.get();
        return track.doesExist() ? Optional.of(track.getPosition() + 1 + ": " + track.getName()) : Optional.empty();
    }

    protected Optional<ITrack> getTrack(int index) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        return index < 0 ? tb.getSelectedItem() : Optional.of((ITrack)tb.getItem(index));
    }

    protected boolean isButtonCombination(ITrack track) {
        if (this.isButtonCombination(ButtonID.DELETE)) {
            track.remove();
            return true;
        }
        if (this.isButtonCombination(ButtonID.DUPLICATE)) {
            track.duplicate();
            return true;
        }
        if (this.isButtonCombination(ButtonID.NEW)) {
            new TemporaryNewCommand(track.getIndex(), this.model, this.surface).execute();
            return true;
        }
        return false;
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN || row != 0) {
            return;
        }
        Optional<ITrack> trackOpt = this.getTrack(index);
        if (trackOpt.isEmpty()) {
            return;
        }
        ITrack track = trackOpt.get();
        if (!this.isButtonCombination(track)) {
            this.executeMethod(track);
        }
    }

    protected void executeMethod(ITrack track) {
        track.selectOrExpandGroup();
    }

    @Override
    public void selectItem(int index) {
        if (this.clipLauncherNavigator == null) {
            super.selectItem(index);
            return;
        }
        this.clipLauncherNavigator.selectTrack(index);
        this.mvHelper.notifySelectedTrack();
    }

    @Override
    public void selectPreviousItem() {
        if (this.clipLauncherNavigator == null) {
            super.selectPreviousItem();
            return;
        }
        if (this.isAlternativeFunction.getAsBoolean()) {
            super.selectPreviousItem();
        } else {
            this.clipLauncherNavigator.navigateTracks(true);
        }
    }

    @Override
    public void selectNextItem() {
        if (this.clipLauncherNavigator == null) {
            super.selectNextItem();
            return;
        }
        if (this.isAlternativeFunction.getAsBoolean()) {
            super.selectNextItem();
        } else {
            this.clipLauncherNavigator.navigateTracks(false);
        }
    }
}

