/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.mode.layer;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;

public abstract class DefaultLayerMode<S extends IControlSurface<C>, C extends Configuration>
extends AbstractParameterMode<S, C, ILayer> {
    private final ISpecificDevice firstInstrument;

    protected DefaultLayerMode(String name, S surface, IModel model, boolean isAbsolute) {
        this(name, surface, model, isAbsolute, (List<ContinuousID>)null);
    }

    protected DefaultLayerMode(String name, S surface, IModel model, boolean isAbsolute, List<ContinuousID> controls) {
        this(name, surface, model, isAbsolute, controls, () -> surface.isShiftPressed());
    }

    protected DefaultLayerMode(String name, S surface, IModel model, boolean isAbsolute, List<ContinuousID> controls, BooleanSupplier isAlternativeFunction) {
        super(name, surface, model, isAbsolute, model.getCursorDevice().getLayerBank(), controls, isAlternativeFunction);
        this.firstInstrument = model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT);
        this.firstInstrument.addHasDrumPadsObserver(hasDrumPads -> this.parametersAdjusted());
    }

    @Override
    public Optional<String> getSelectedItemName() {
        Optional selectedItem = this.bank.getSelectedItem();
        if (selectedItem.isEmpty()) {
            return Optional.empty();
        }
        ILayer layer = (ILayer)selectedItem.get();
        return layer.doesExist() ? Optional.of(layer.getPosition() + 1 + ": " + layer.getName()) : Optional.empty();
    }

    protected Optional<ILayer> getLayer(int index) {
        return index < 0 ? this.bank.getSelectedItem() : Optional.of((ILayer)this.bank.getItem(index));
    }

    protected boolean isButtonCombination(ILayer layer) {
        if (this.isButtonCombination(ButtonID.DELETE)) {
            layer.remove();
            return true;
        }
        if (this.isButtonCombination(ButtonID.DUPLICATE)) {
            layer.duplicate();
            return true;
        }
        return false;
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN || row != 0) {
            return;
        }
        Optional<ILayer> layerOpt = this.getLayer(index);
        if (layerOpt.isEmpty()) {
            return;
        }
        ILayer layer = layerOpt.get();
        if (!this.isButtonCombination(layer)) {
            this.executeMethod(layer);
        }
    }

    @Override
    public void parametersAdjusted() {
        this.switchBanks(this.firstInstrument.hasDrumPads() ? this.firstInstrument.getDrumPadBank() : this.firstInstrument.getLayerBank());
        super.parametersAdjusted();
    }

    protected abstract void executeMethod(ILayer var1);
}

