/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics.canvas.component.simple;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsConfiguration;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IGraphicsInfo;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleValueComponent;
import java.util.Arrays;

public class TitleValueMenuComponent
extends TitleValueComponent {
    private final String[] menu;

    public TitleValueMenuComponent(String label1, String label2, String[] menu, int value, boolean isPan) {
        this(label1, label2, menu, value, -1, -1, isPan);
    }

    public TitleValueMenuComponent(String label1, String label2, String[] menu, int value, int vuLeft, int vuRight, boolean isPan) {
        super(label1, label2, value, vuLeft, vuRight, isPan);
        this.menu = menu;
        this.rowHeight = 14;
    }

    @Override
    public void draw(IGraphicsInfo info) {
        IGraphicsConfiguration configuration = info.getConfiguration();
        ColorEx colorText = configuration.getColorText();
        ColorEx colorFader = configuration.getColorFader();
        IGraphicsContext gc = info.getContext();
        this.draw(gc, 2 * this.rowHeight + 4, this.rowHeight - 4, colorText, colorFader);
        this.drawMenu(gc);
    }

    private void drawMenu(IGraphicsContext gc) {
        int menuHeight = this.rowHeight - 4;
        int menuTop = 64 - menuHeight;
        int itemWidth = 32;
        gc.fillRectangle(0.0, menuTop, 128.0, menuHeight, ColorEx.WHITE);
        gc.drawTextInBounds(this.menu[0], 0.0, menuTop, 32.0, menuHeight, Align.CENTER, ColorEx.BLACK, menuHeight + 2);
        gc.drawTextInBounds(this.menu[1], 32.0, menuTop, 32.0, menuHeight, Align.CENTER, ColorEx.BLACK, menuHeight + 2);
        gc.drawTextInBounds(this.menu[2], 64.0, menuTop, 32.0, menuHeight, Align.CENTER, ColorEx.BLACK, menuHeight + 2);
        gc.drawTextInBounds(this.menu[3], 96.0, menuTop, 32.0, menuHeight, Align.CENTER, ColorEx.BLACK, menuHeight + 2);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.menu);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        TitleValueMenuComponent other = (TitleValueMenuComponent)obj;
        return Arrays.equals(this.menu, other.menu);
    }
}

