/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw.midi;

import de.mossgrabers.framework.daw.midi.IMidiOutput;

public abstract class AbstractMidiOutput
implements IMidiOutput {
    public static final int ZONE_1 = 176;
    public static final int ZONE_2 = 191;
    protected static final int REGISTERED_PARAMETER_NUMBER_MSB = 101;
    protected static final int REGISTERED_PARAMETER_NUMBER_LSB = 100;
    protected static final int DATA_ENTRY_MPE = 6;
    protected static final int PARAMETER_MPE_CONFIG_MSB = 0;
    protected static final int PARAMETER_MPE_CONFIG_LSB = 6;
    protected static final int PARAMETER_MPE_PITCHBEND_SENSITIVITY_MSB = 0;
    protected static final int PARAMETER_MPE_PITCHBEND_SENSITIVITY_LSB = 0;

    @Override
    public void sendCC(int cc, int value) {
        this.sendMidiShort(176, cc, value);
    }

    @Override
    public void sendCCEx(int channel, int cc, int value) {
        this.sendMidiShort(176 + channel, cc, value);
    }

    @Override
    public void sendNote(int note, int velocity) {
        this.sendMidiShort(144, note, velocity);
    }

    @Override
    public void sendNoteEx(int channel, int note, int velocity) {
        this.sendMidiShort(144 + channel, note, velocity);
    }

    @Override
    public void sendPolyphonicAftertouch(int data1, int data2) {
        this.sendMidiShort(160, data1, data2);
    }

    @Override
    public void sendPolyphonicAftertouch(int channel, int data1, int data2) {
        this.sendMidiShort(160 + channel, data1, data2);
    }

    @Override
    public void sendChannelAftertouch(int data1, int data2) {
        this.sendMidiShort(208, data1, data2);
    }

    @Override
    public void sendChannelAftertouch(int channel, int data1, int data2) {
        this.sendMidiShort(208 + channel, data1, data2);
    }

    @Override
    public void sendPitchbend(int data1, int data2) {
        this.sendMidiShort(224, data1, data2);
    }

    @Override
    public void sendPitchbend(int channel, int data1, int data2) {
        this.sendMidiShort(224 + channel, data1, data2);
    }

    @Override
    public void sendProgramChange(int bankMSB, int bankLSB, int value) {
        this.sendProgramChange(0, bankMSB, bankLSB, value);
    }

    @Override
    public void sendProgramChange(int channel, int bankMSB, int bankLSB, int value) {
        this.sendCCEx(channel, 0, bankMSB);
        this.sendCCEx(channel, 32, bankLSB);
        this.sendMidiShort(192 + channel, value, 0);
    }

    @Override
    public void configureMPE(int zone, int numberOfChannels) {
        this.sendMidiShort(zone, 79, 0);
        this.sendMidiShort(zone, 101, 0);
        this.sendMidiShort(zone, 100, 6);
        this.sendMidiShort(zone, 6, numberOfChannels);
    }

    @Override
    public void sendMPEPitchbendRange(int zone, int range) {
        this.sendMidiShort(zone, 101, 0);
        this.sendMidiShort(zone, 100, 0);
        this.sendMidiShort(zone, 6, range);
    }

    protected abstract void sendMidiShort(int var1, int var2, int var3);
}

