/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw.constants;

import java.util.Locale;

public enum PostRecordingAction {
    OFF("Off"),
    PLAY_RECORDED("Read"),
    RECORD_NEXT_FREE_SLOT("Record into next free slot"),
    STOP("Stop"),
    RETURN_TO_ARRANGEMENT("Return to arrangement"),
    RETURN_TO_PREVIOUS_CLIP("Return to last clip"),
    PLAY_RANDOM("Play random");

    private final String label;

    private PostRecordingAction(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getIdentifier() {
        return this.name().toLowerCase(Locale.US);
    }

    public static PostRecordingAction lookup(String identifier) {
        for (PostRecordingAction mode : PostRecordingAction.values()) {
            if (!mode.name().equalsIgnoreCase(identifier)) continue;
            return mode;
        }
        return OFF;
    }
}

