/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw.constants;

import java.util.HashMap;
import java.util.Map;

public enum LaunchQuantization {
    RES_NONE("None", "none"),
    RES_8("8", "8"),
    RES_4("4", "4"),
    RES_2("2", "2"),
    RES_1("1", "1"),
    RES_1_2("1/2", "1/2"),
    RES_1_4("1/4", "1/4"),
    RES_1_8("1/8", "1/8"),
    RES_1_16("1/16", "1/16");

    private static final Map<String, LaunchQuantization> QUANTIZATION_VALUES;
    private final String name;
    private final String value;

    private LaunchQuantization(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static LaunchQuantization lookup(String value) {
        return QUANTIZATION_VALUES.getOrDefault(value, RES_NONE);
    }

    static {
        QUANTIZATION_VALUES = new HashMap<String, LaunchQuantization>();
        for (LaunchQuantization value : LaunchQuantization.values()) {
            QUANTIZATION_VALUES.put(value.getValue(), value);
        }
    }
}

