/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw.clip;

import de.mossgrabers.framework.daw.clip.IClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NoteOccurrenceType;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.data.IPinnable;
import java.util.List;

public interface INoteClip
extends IClip,
IPinnable {
    public int getNumRows();

    public int getCurrentStep();

    public void setStepLength(double var1);

    public double getStepLength();

    public IStepInfo getStep(NotePosition var1);

    public void toggleStep(NotePosition var1, int var2);

    public void setStep(NotePosition var1, int var2, double var3);

    public void setStep(NotePosition var1, IStepInfo var2);

    public void clearStep(NotePosition var1);

    public void moveStepY(NotePosition var1, int var2);

    public void updateStepMuteState(NotePosition var1, boolean var2);

    public void changeStepMuteState(NotePosition var1, int var2);

    public void updateStepDuration(NotePosition var1, double var2);

    public void changeStepDuration(NotePosition var1, int var2);

    public void updateStepVelocity(NotePosition var1, double var2);

    public void changeStepVelocity(NotePosition var1, int var2);

    public void updateStepVelocitySpread(NotePosition var1, double var2);

    public void changeStepVelocitySpread(NotePosition var1, int var2);

    public void updateStepReleaseVelocity(NotePosition var1, double var2);

    public void changeStepReleaseVelocity(NotePosition var1, int var2);

    public void updateStepPressure(NotePosition var1, double var2);

    public void changeStepPressure(NotePosition var1, int var2);

    public void updateStepTimbre(NotePosition var1, double var2);

    public void changeStepTimbre(NotePosition var1, int var2);

    public void updateStepPan(NotePosition var1, double var2);

    public void changeStepPan(NotePosition var1, int var2);

    public void updateStepTranspose(NotePosition var1, double var2);

    public void changeStepTranspose(NotePosition var1, int var2);

    public void updateStepGain(NotePosition var1, double var2);

    public void changeStepGain(NotePosition var1, int var2);

    public void updateStepIsChanceEnabled(NotePosition var1, boolean var2);

    public void updateStepChance(NotePosition var1, double var2);

    public void changeStepChance(NotePosition var1, int var2);

    public void updateStepIsOccurrenceEnabled(NotePosition var1, boolean var2);

    public void setStepPrevNextOccurrence(NotePosition var1, boolean var2);

    public void setStepOccurrence(NotePosition var1, NoteOccurrenceType var2);

    public void updateStepIsRecurrenceEnabled(NotePosition var1, boolean var2);

    public void updateStepRecurrenceLength(NotePosition var1, int var2);

    public void updateStepRecurrenceMask(NotePosition var1, int var2);

    default public void updateStepRecurrenceMaskToggleBit(NotePosition position, int step) {
        int bitVal;
        IStepInfo stepInfo = this.getStep(position);
        if (stepInfo.getState() == StepState.OFF) {
            return;
        }
        int mask = stepInfo.getRecurrenceMask();
        mask = (mask & (bitVal = 1 << step)) > 0 ? (mask &= ~bitVal) : (mask |= bitVal);
        this.updateStepRecurrenceMask(position, mask);
    }

    public void changeStepRecurrenceLength(NotePosition var1, int var2);

    public void updateStepIsRepeatEnabled(NotePosition var1, boolean var2);

    public void updateStepRepeatCount(NotePosition var1, int var2);

    public void changeStepRepeatCount(NotePosition var1, int var2);

    public void updateStepRepeatCurve(NotePosition var1, double var2);

    public void changeStepRepeatCurve(NotePosition var1, int var2);

    public void updateStepRepeatVelocityCurve(NotePosition var1, double var2);

    public void changeStepRepeatVelocityCurve(NotePosition var1, int var2);

    public void updateStepRepeatVelocityEnd(NotePosition var1, double var2);

    public void changeStepRepeatVelocityEnd(NotePosition var1, int var2);

    public void startEdit(List<NotePosition> var1);

    public void stopEdit();

    public void clearAll();

    public void clearRow(int var1, int var2);

    public boolean hasRowData(int var1, int var2);

    public int getLowestRowWithData();

    public int getHighestRowWithData();

    public int getLowestRowWithData(int var1);

    public int getHighestRowWithData(int var1);

    public int getHighestRow(int var1, int var2);

    public void scrollToPage(int var1);

    public int getEditPage();

    public void scrollStepsPageBackwards();

    public void scrollStepsPageForward();

    public boolean canScrollStepsBackwards();

    public boolean canScrollStepsForwards();

    public double getStepTransposeRange();

    public NotePosition getNextNote(NotePosition var1, boolean var2);

    public NotePosition getPreviousNote(NotePosition var1, boolean var2);
}

