/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw;

import de.mossgrabers.framework.daw.constants.DeviceID;
import java.util.ArrayList;
import java.util.List;

public class ModelSetup {
    private boolean hasFlatTrackList = true;
    private boolean hasFullFlatTrackList = false;
    private int numTracks = 8;
    private int numFxTracks = -1;
    private int numScenes = 8;
    private int numSends = 8;
    private boolean wantsClipLauncherNavigator = false;
    private boolean wantsDrumDevice = true;
    private int[] additionalDrumDevices = new int[0];
    private int numDevicesInBank = 8;
    private int numDeviceLayers = 8;
    private int numParamPages = 8;
    private int numParams = 8;
    private int numDrumPadLayers = 16;
    private int numFilterColumnEntries = 16;
    private int numResults = 16;
    private int numMarkers = 0;
    private final List<DeviceID> deviceIDs = new ArrayList<DeviceID>();

    public void enableMainDrumDevice(boolean wantsDrumDevice) {
        this.wantsDrumDevice = wantsDrumDevice;
    }

    public void enableDrum64Device() {
        this.setAdditionalDrumDevices(new int[]{64});
    }

    public void setAdditionalDrumDevices(int[] additionalDrumDevices) {
        this.additionalDrumDevices = additionalDrumDevices;
    }

    public void enableDevice(DeviceID deviceID) {
        this.deviceIDs.add(deviceID);
    }

    public int getNumTracks() {
        return this.numTracks;
    }

    public void setNumTracks(int numTracks) {
        this.numTracks = numTracks;
    }

    public int getNumFxTracks() {
        return this.numFxTracks == -1 ? this.numTracks : this.numFxTracks;
    }

    public void setNumFxTracks(int numFxTracks) {
        this.numFxTracks = numFxTracks;
    }

    public int getNumScenes() {
        return this.numScenes;
    }

    public void setNumScenes(int numScenes) {
        this.numScenes = numScenes;
    }

    public int getNumSends() {
        return this.numSends;
    }

    public void setNumSends(int numSends) {
        this.numSends = numSends;
    }

    public int getNumParamPages() {
        return this.numParamPages;
    }

    public void setNumParamPages(int numParamPages) {
        this.numParamPages = numParamPages;
    }

    public int getNumParams() {
        return this.numParams;
    }

    public void setNumParams(int numParams) {
        this.numParams = numParams;
    }

    public int getNumDevicesInBank() {
        return this.numDevicesInBank;
    }

    public void setNumDevicesInBank(int numDevicesInBank) {
        this.numDevicesInBank = numDevicesInBank;
    }

    public int getNumDeviceLayers() {
        return this.numDeviceLayers;
    }

    public void setNumDeviceLayers(int numDeviceLayers) {
        this.numDeviceLayers = numDeviceLayers;
    }

    public int getNumDrumPadLayers() {
        return this.numDrumPadLayers;
    }

    public void setNumDrumPadLayers(int numDrumPadLayers) {
        this.numDrumPadLayers = numDrumPadLayers;
    }

    public int getNumFilterColumnEntries() {
        return this.numFilterColumnEntries;
    }

    public void setNumFilterColumnEntries(int numFilterColumnEntries) {
        this.numFilterColumnEntries = numFilterColumnEntries;
    }

    public int getNumResults() {
        return this.numResults;
    }

    public void setNumResults(int numResults) {
        this.numResults = numResults;
    }

    public boolean hasFlatTrackList() {
        return this.hasFlatTrackList;
    }

    public void setHasFlatTrackList(boolean hasFlatTrackList) {
        this.hasFlatTrackList = hasFlatTrackList;
    }

    public boolean hasFullFlatTrackList() {
        return this.hasFullFlatTrackList;
    }

    public void setHasFullFlatTrackList(boolean hasFullFlatTrackList) {
        this.hasFullFlatTrackList = hasFullFlatTrackList;
    }

    public int getNumMarkers() {
        return this.numMarkers;
    }

    public void setNumMarkers(int numMarkers) {
        this.numMarkers = numMarkers;
    }

    public boolean wantsMainDrumDevice() {
        return this.wantsDrumDevice;
    }

    public int[] wantsAdditionalDrumDevices() {
        return this.additionalDrumDevices;
    }

    public List<DeviceID> getDeviceIDs() {
        return new ArrayList<DeviceID>(this.deviceIDs);
    }

    public boolean wantsClipLauncherNavigator() {
        return this.wantsClipLauncherNavigator;
    }

    public void setWantsClipLauncherNavigator(boolean wantsClipLauncherNavigator) {
        this.wantsClipLauncherNavigator = wantsClipLauncherNavigator;
    }
}

