/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw;

import de.mossgrabers.framework.daw.constants.AutomationMode;
import de.mossgrabers.framework.daw.constants.LaunchQuantization;
import de.mossgrabers.framework.daw.constants.PostRecordingAction;
import de.mossgrabers.framework.observer.IObserverManagement;
import de.mossgrabers.framework.parameter.IParameter;
import java.util.Arrays;

public interface ITransport
extends IObserverManagement {
    public void play();

    public boolean isPlaying();

    public void restart();

    public void stop();

    public void stopAndRewind();

    public void startRecording();

    public boolean isRecording();

    public boolean isArrangerOverdub();

    public void toggleOverdub();

    public boolean isLauncherOverdub();

    public void setLauncherOverdub(boolean var1);

    public void toggleLauncherOverdub();

    public boolean isMetronomeOn();

    public void toggleMetronome();

    public void setMetronome(boolean var1);

    public boolean isMetronomeTicksOn();

    public void toggleMetronomeTicks();

    public void setMetronomeTicks(boolean var1);

    public IParameter getMetronomeVolumeParameter();

    public String getMetronomeVolumeStr();

    public void changeMetronomeVolume(int var1);

    public void setMetronomeVolume(int var1);

    public int getMetronomeVolume();

    public void setLoop(boolean var1);

    public void toggleLoop();

    public boolean isLoop();

    public boolean isWritingClipLauncherAutomation();

    public boolean isWritingArrangerAutomation();

    public AutomationMode[] getAutomationWriteModes();

    public AutomationMode getAutomationWriteMode();

    public void setAutomationWriteMode(AutomationMode var1);

    default public void nextAutomationWriteMode() {
        AutomationMode[] automationWriteModes = this.getAutomationWriteModes();
        AutomationMode automationWriteMode = this.getAutomationWriteMode();
        int pos = Arrays.asList(automationWriteModes).indexOf((Object)automationWriteMode) + 1;
        if (pos >= automationWriteModes.length) {
            pos = 0;
        }
        this.setAutomationWriteMode(automationWriteModes[pos]);
    }

    public void toggleWriteArrangerAutomation();

    public void toggleWriteClipLauncherAutomation();

    public void resetAutomationOverrides();

    public void returnToArrangement();

    public String getPositionText();

    public String getBeatText();

    public void setPosition(double var1);

    public double getPosition();

    public void setPositionToEnd();

    public void changePosition(boolean var1, boolean var2);

    public String getLoopStartBeatText();

    public void changeLoopStart(boolean var1, boolean var2);

    public void selectLoopStart();

    public double getLoopStart();

    public double getLoopEnd();

    public void selectLoopEnd();

    public String getLoopLengthBeatText();

    public void changeLoopLength(boolean var1, boolean var2);

    public void setPunchIn(boolean var1);

    public void togglePunchIn();

    public boolean isPunchInEnabled();

    public void setPunchOut(boolean var1);

    public void togglePunchOut();

    public boolean isPunchOutEnabled();

    public void tapTempo();

    public void changeTempo(boolean var1, boolean var2);

    public void setTempo(double var1);

    public double getTempo();

    public String formatTempo(double var1);

    public String formatTempoNoFraction(double var1);

    public double scaleTempo(double var1, int var3);

    public void setTempoIndication(boolean var1);

    public IParameter getCrossfadeParameter();

    public void setCrossfade(int var1);

    public int getCrossfade();

    public void changeCrossfade(int var1);

    public boolean isPrerollMetronomeEnabled();

    public void togglePrerollMetronome();

    public int getPrerollMeasures();

    public void setPrerollMeasures(int var1);

    public int getNumerator();

    public int getDenominator();

    public int getQuartersPerMeasure();

    public PostRecordingAction getClipLauncherPostRecordingAction();

    public void setClipLauncherPostRecordingAction(PostRecordingAction var1);

    public double getClipLauncherPostRecordingTimeOffset();

    public void setClipLauncherPostRecordingTimeOffset(double var1);

    public LaunchQuantization getDefaultLaunchQuantization();

    public void setDefaultLaunchQuantization(LaunchQuantization var1);

    default public void nextLaunchQuantization() {
        LaunchQuantization[] launchQuantizations = LaunchQuantization.values();
        LaunchQuantization launchQuantization = this.getDefaultLaunchQuantization();
        int pos = Arrays.asList(launchQuantizations).indexOf((Object)launchQuantization) + 1;
        if (pos >= launchQuantizations.length) {
            pos = 0;
        }
        this.setDefaultLaunchQuantization(launchQuantizations[pos]);
    }

    public boolean isFillModeActive();

    public void setFillModeActive(boolean var1);

    public void toggleFillModeActive();
}

