/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller.grid;

import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.grid.IVirtualFader;
import de.mossgrabers.framework.controller.grid.IVirtualFaderCallback;
import de.mossgrabers.framework.daw.IHost;

public class VirtualFaderImpl
implements IVirtualFader {
    private static final int PAD_VALUE_AMOUNT = 16;
    private static final int[] SPEED_SCALE = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 19, 20, 21, 22, 23, 24, 25};
    private static final int LOOP_DELAY = 6;
    private final IHost host;
    private final IVirtualFaderCallback callback;
    private final IPadGrid padGrid;
    private final int index;
    private int color;
    private boolean isPanorama;
    private final int[] colorStates = new int[8];
    private int moveDelay;
    private int moveTimerDelay;
    private int moveDestination;
    private int moveTargetValue;
    private boolean moveDirectionIsUpwards = true;
    private boolean isKnobType;

    public VirtualFaderImpl(IHost host, IVirtualFaderCallback callback) {
        this(host, callback, null, -1);
    }

    public VirtualFaderImpl(IHost host, IVirtualFaderCallback callback, IPadGrid padGrid, int index) {
        this.host = host;
        this.padGrid = padGrid;
        this.index = index;
        this.callback = callback;
    }

    @Override
    public int getColorState(int index) {
        return this.colorStates[index];
    }

    @Override
    public void setup(int color, boolean isPan) {
        this.color = color;
        this.isPanorama = isPan;
    }

    @Override
    public void setValue(int value) {
        int i;
        for (i = 0; i < this.colorStates.length; ++i) {
            this.colorStates[i] = 0;
        }
        if (this.isPanorama) {
            this.drawPanorama(value);
        } else {
            this.drawFader(value);
        }
        for (i = 0; i < this.colorStates.length; ++i) {
            this.lightPad(i, this.colorStates[7 - i]);
        }
    }

    @Override
    public void moveTo(int row, int velocity) {
        this.moveDelay = SPEED_SCALE[velocity] * 6;
        this.moveTimerDelay = SPEED_SCALE[SPEED_SCALE.length - 1 - velocity] * 6;
        --this.moveTimerDelay;
        this.isKnobType = false;
        int min = row * 16;
        int max = Math.min(127, (row + 1) * 16 - 1);
        int newDestination = this.smoothFaderValue(row, max);
        if (min <= this.moveDestination && this.moveDestination <= max) {
            int step = (this.moveDestination - min) / 4;
            if (this.moveDirectionIsUpwards) {
                newDestination = min + 4 * (step + 2) - 1;
                if (newDestination > max) {
                    newDestination = min + 4 * step - 1;
                    this.moveDirectionIsUpwards = false;
                }
            } else {
                newDestination = min + 4 * (step - 1) + 1;
                if (newDestination < min) {
                    newDestination = min + 4 * (step + 2) - 1;
                    this.moveDirectionIsUpwards = true;
                }
            }
        } else if (row == 0) {
            newDestination = 0;
        }
        this.moveDestination = newDestination;
        this.moveFaderToDestination();
    }

    protected void moveFaderToDestination() {
        int current = this.callback.getValue();
        if (current == this.moveDestination) {
            return;
        }
        this.moveDirectionIsUpwards = current < this.moveDestination;
        this.moveTargetValue = this.moveDirectionIsUpwards ? Math.min(current + this.moveDelay, this.moveDestination) : Math.max(current - this.moveDelay, this.moveDestination);
        this.callback.setValue(this.moveTargetValue);
        this.host.scheduleTask(this::moveFaderToDestinationCallback, 6L);
    }

    protected void moveFaderToDestinationCallback() {
        int updatedValue = this.callback.getValue();
        if (!this.isKnobType && updatedValue != this.moveTargetValue) {
            this.host.println("FORCED!");
            this.callback.setValue(this.moveDestination);
            return;
        }
        this.isKnobType = true;
        this.host.scheduleTask(this::moveFaderToDestination, this.moveTimerDelay);
    }

    private int smoothFaderValue(int row, int value) {
        if (this.isPanorama && (row == 3 || row == 4)) {
            return 64;
        }
        int oldValue = this.callback.getValue();
        if (row == 0) {
            return oldValue == 0 ? 15 : 0;
        }
        return value;
    }

    private void drawFader(int value) {
        double pos = 8.0 * (double)value / 127.0;
        int numPads = (int)pos;
        int fine = (int)Math.round(3.0 * (pos - (double)numPads));
        for (int i = 0; i < 8; ++i) {
            if (i < numPads) {
                this.colorStates[i] = this.color;
                continue;
            }
            if (i != numPads) continue;
            this.colorStates[i] = fine == 3 ? this.color : fine;
        }
    }

    private void drawPanorama(int value) {
        if (value == 64) {
            this.colorStates[3] = this.color;
            this.colorStates[4] = this.color;
            return;
        }
        if (value < 64) {
            double pos = 4.0 * (double)value / 64.0 - 1.0;
            int numPads = (int)pos;
            int fine = 3 - (int)Math.abs(Math.round(3.0 * (pos - (double)numPads)));
            for (int i = 0; i < 4; ++i) {
                if (i - 1 > numPads) {
                    this.colorStates[i] = this.color;
                    continue;
                }
                if (i - 1 != numPads) continue;
                this.colorStates[i] = fine == 3 ? this.color : fine;
            }
            return;
        }
        double pos = 4.0 * (double)(value - 64) / 64.0;
        int numPads = (int)pos;
        int fine = (int)Math.round(3.0 * (pos - (double)numPads));
        for (int i = 4; i < 8; ++i) {
            if (i - 4 < numPads) {
                this.colorStates[i] = this.color;
                continue;
            }
            if (i - 4 != numPads) continue;
            this.colorStates[i] = fine == 3 ? this.color : fine;
        }
    }

    private void lightPad(int y, int color) {
        if (this.padGrid != null) {
            this.padGrid.lightEx(this.index, y, color);
        }
    }
}

