/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller.display;

import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.hardware.IHwTextDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;

public abstract class AbstractTextDisplay
implements ITextDisplay {
    public static final int NOTIFICATION_TIME = 700;
    protected IHost host;
    protected IMidiOutput output;
    protected int noOfLines;
    protected int noOfCells;
    protected int noOfCharacters;
    protected int charactersOfCell;
    protected String emptyLine;
    protected String notificationMessage;
    protected boolean centerNotification = true;
    protected int notificationTimeout = 0;
    protected final Object notificationLock = new Object();
    protected String emptyCell;
    protected String[] currentMessage;
    protected String[] message;
    protected String[] fullRows;
    protected String[] cells;
    protected IHwTextDisplay hwDisplay;

    protected AbstractTextDisplay(IHost host, IMidiOutput output, int noOfLines, int noOfCells, int noOfCharacters) {
        this.host = host;
        this.output = output;
        this.setNumberOfCells(noOfLines, noOfCells, noOfCharacters);
    }

    protected void setNumberOfCells(int noOfLines, int noOfCells, int noOfCharacters) {
        this.noOfLines = noOfLines;
        this.noOfCells = noOfCells;
        this.noOfCharacters = noOfCharacters;
        this.charactersOfCell = this.noOfCharacters / this.noOfCells;
        this.emptyCell = "                                                                     ".substring(0, this.charactersOfCell);
        StringBuilder sb = new StringBuilder(this.noOfCharacters);
        for (int i = 0; i < this.noOfCharacters; ++i) {
            sb.append(' ');
        }
        this.notificationMessage = this.emptyLine = sb.toString();
        this.currentMessage = new String[this.noOfLines];
        this.message = new String[this.noOfLines];
        this.fullRows = new String[this.noOfLines];
        this.cells = new String[this.noOfLines * this.noOfCells];
    }

    @Override
    public int getNumberOfLines() {
        return this.noOfLines;
    }

    @Override
    public int getNumberOfCellCharacters() {
        return this.noOfCharacters;
    }

    @Override
    public void setHardwareDisplay(IHwTextDisplay display) {
        this.hwDisplay = display;
    }

    @Override
    public IHwTextDisplay getHardwareDisplay() {
        return this.hwDisplay;
    }

    @Override
    public ITextDisplay setRow(int row, String str) {
        this.fullRows[row] = str;
        return this;
    }

    @Override
    public ITextDisplay clear() {
        for (int i = 0; i < this.noOfLines; ++i) {
            this.clearRow(i);
        }
        return this;
    }

    @Override
    public ITextDisplay clearRow(int row) {
        for (int i = 0; i < this.noOfCells; ++i) {
            this.clearCell(row, i);
        }
        return this;
    }

    @Override
    public ITextDisplay clearBlock(int row, int block) {
        int cell = 2 * block;
        this.clearCell(row, cell);
        this.clearCell(row, cell + 1);
        return this;
    }

    @Override
    public ITextDisplay clearColumn(int column) {
        for (int i = 0; i < this.noOfLines; ++i) {
            this.clearCell(i, column);
        }
        return this;
    }

    @Override
    public ITextDisplay done(int row) {
        if (this.fullRows[row] != null) {
            this.message[row] = this.fullRows[row];
            this.fullRows[row] = null;
        } else {
            int index = row * this.noOfCells;
            this.message[row] = "";
            for (int i = 0; i < this.noOfCells; ++i) {
                int n = row;
                this.message[n] = this.message[n] + this.cells[index + i];
            }
        }
        return this;
    }

    @Override
    public ITextDisplay allDone() {
        for (int row = 0; row < this.noOfLines; ++row) {
            this.done(row);
        }
        return this;
    }

    @Override
    public ITextDisplay clearCell(int row, int column) {
        this.cells[row * this.noOfCells + column] = this.emptyCell;
        return this;
    }

    @Override
    public ITextDisplay setCell(int row, int column, int value, Format format) {
        this.setCell(row, column, Integer.toString(value));
        return this;
    }

    @Override
    public ITextDisplay setCell(int row, int column, String value) {
        try {
            this.cells[row * this.noOfCells + column] = StringUtils.pad(value, this.charactersOfCell);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.host.error("Display array index out of bounds.", ex);
        }
        return this;
    }

    @Override
    public ITextDisplay setBlock(int row, int block, String value) {
        int cell = 2 * block;
        if (value.length() >= this.charactersOfCell) {
            this.cells[row * this.noOfCells + cell] = StringUtils.pad(value.substring(0, this.charactersOfCell), this.charactersOfCell);
            this.cells[row * this.noOfCells + cell + 1] = StringUtils.pad(value.substring(this.charactersOfCell), this.charactersOfCell);
        } else {
            this.setCell(row, cell, value);
            this.clearCell(row, cell + 1);
        }
        return this;
    }

    @Override
    public void notify(String message) {
        if (message != null) {
            this.notifyOnDisplay(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelNotification() {
        Object object = this.notificationLock;
        synchronized (object) {
            this.notificationTimeout = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNotificationActive() {
        Object object = this.notificationLock;
        synchronized (object) {
            return this.notificationTimeout > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyOnDisplay(String message) {
        StringBuilder msg = new StringBuilder();
        if (this.centerNotification) {
            int padLength = (this.noOfCharacters - message.length()) / 2 + 1;
            String padding = padLength > 0 ? this.emptyLine.substring(0, padLength) : "";
            msg.append(padding).append(message).append(padding);
        } else {
            msg.append(message);
        }
        for (int row = 0; row < this.noOfLines; ++row) {
            msg.append(this.emptyLine);
        }
        this.notificationMessage = msg.toString();
        Object object = this.notificationLock;
        synchronized (object) {
            boolean isRunning = this.notificationTimeout > 0;
            this.notificationTimeout = 700;
            this.showNotification();
            if (!isRunning) {
                this.host.scheduleTask(this::watch, 100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void watch() {
        Object object = this.notificationLock;
        synchronized (object) {
            this.notificationTimeout -= 100;
            if (this.notificationTimeout <= 0) {
                this.removeNotification();
            } else {
                this.host.scheduleTask(this::watch, 100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.notificationLock;
        synchronized (object) {
            if (this.notificationTimeout > 0) {
                this.updateNotification();
                return;
            }
        }
        for (int row = 0; row < this.noOfLines; ++row) {
            if (this.currentMessage[row] != null && this.currentMessage[row].equals(this.message[row])) continue;
            String previousMessage = this.currentMessage[row];
            this.currentMessage[row] = this.message[row];
            if (this.currentMessage[row] == null) continue;
            this.updateLine(row, this.currentMessage[row], previousMessage);
        }
    }

    protected void showNotification() {
        this.flush();
    }

    protected void updateNotification() {
        for (int row = 0; row < this.noOfLines; ++row) {
            int pos = row * this.noOfCharacters;
            int length = this.notificationMessage.length();
            String text = pos < length ? this.notificationMessage.substring(pos, Math.min(length, pos + this.noOfCharacters)) : "";
            this.updateLine(row, StringUtils.pad(text, this.noOfCharacters), this.currentMessage[row]);
        }
    }

    protected void removeNotification() {
        this.forceFlush();
    }

    protected void updateLine(int row, String text, String previousText) {
        this.hwDisplay.setLine(row, this.convertCharacterset(text));
        this.writeLine(row, text, previousText);
    }

    protected String convertCharacterset(String text) {
        return text;
    }

    @Override
    public void forceFlush() {
        for (int row = 0; row < this.noOfLines; ++row) {
            this.currentMessage[row] = "";
        }
    }

    public void setCenterNotification(boolean centerNotification) {
        this.centerNotification = centerNotification;
    }
}

