/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.OutputID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.DummyDisplay;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.grid.ILightGuide;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwAbsoluteKnob;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.controller.hardware.IHwContinuousControl;
import de.mossgrabers.framework.controller.hardware.IHwControl;
import de.mossgrabers.framework.controller.hardware.IHwFader;
import de.mossgrabers.framework.controller.hardware.IHwLight;
import de.mossgrabers.framework.controller.hardware.IHwPianoKeyboard;
import de.mossgrabers.framework.controller.hardware.IHwRelativeKnob;
import de.mossgrabers.framework.controller.hardware.IHwSurfaceFactory;
import de.mossgrabers.framework.controller.valuechanger.ISensitivityCallback;
import de.mossgrabers.framework.controller.valuechanger.RelativeEncoding;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.daw.midi.INoteInput;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.graphics.IBitmap;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public abstract class AbstractControlSurface<C extends Configuration>
implements IControlSurface<C> {
    private static final String SHOULD_BE_HANDLED_IN_FRAMEWORK = " should be handled in framework...";
    protected static final int BUTTON_STATE_INTERVAL = 500;
    protected static final int NUM_NOTES = 128;
    protected static final int NUM_INFOS = 256;
    protected final IHost host;
    protected final IHwSurfaceFactory surfaceFactory;
    protected final C configuration;
    protected final ColorManager colorManager;
    protected final IMidiOutput output;
    protected final IMidiInput input;
    protected final int surfaceID;
    protected final ViewManager viewManager = new ViewManager();
    protected final ModeManager modeManager = new ModeManager();
    protected int defaultMidiChannel = 0;
    private final Map<ContinuousID, IHwContinuousControl> continuous = new EnumMap<ContinuousID, IHwContinuousControl>(ContinuousID.class);
    private final Map<ButtonID, IHwButton> buttons = new EnumMap<ButtonID, IHwButton>(ButtonID.class);
    private final Map<OutputID, IHwLight> lights = new EnumMap<OutputID, IHwLight>(OutputID.class);
    protected List<ITextDisplay> textDisplays = new ArrayList<ITextDisplay>(1);
    protected List<IGraphicDisplay> graphicsDisplays = new ArrayList<IGraphicDisplay>(1);
    protected final IPadGrid padGrid;
    protected ILightGuide lightGuide;
    protected boolean notifyViewChange = true;
    private int[] keyTranslationTable;
    private final DummyDisplay dummyDisplay;
    private IHwPianoKeyboard pianoKeyboard;
    private final Object updateCounterLock = new Object();
    private int updateCounter = 0;
    private boolean knobSensitivityIsSlow = false;
    private final List<ISensitivityCallback> knobSensitivityObservers = new ArrayList<ISensitivityCallback>();
    protected boolean isShuttingDown = false;

    protected AbstractControlSurface(IHost host, C configuration, ColorManager colorManager, IMidiOutput output, IMidiInput input, IPadGrid padGrid, double width, double height) {
        this(0, host, configuration, colorManager, output, input, padGrid, width, height);
    }

    protected AbstractControlSurface(int surfaceID, IHost host, C configuration, ColorManager colorManager, IMidiOutput output, IMidiInput input, IPadGrid padGrid, double width, double height) {
        this(surfaceID, host, configuration, colorManager, output, input, padGrid, null, width, height);
    }

    protected AbstractControlSurface(int surfaceID, IHost host, C configuration, ColorManager colorManager, IMidiOutput output, IMidiInput input, IPadGrid padGrid, ILightGuide lightGuide, double width, double height) {
        this.surfaceID = surfaceID;
        this.host = host;
        this.configuration = configuration;
        this.colorManager = colorManager;
        this.padGrid = padGrid;
        this.lightGuide = lightGuide;
        this.surfaceFactory = host.createSurfaceFactory(width, height);
        this.dummyDisplay = new DummyDisplay(host);
        this.output = output;
        this.input = input;
        if (this.input != null) {
            this.input.setMidiCallback(this::handleMidi);
        }
        this.createPads();
        this.createLightGuide();
    }

    protected void createPads() {
        if (this.padGrid == null) {
            return;
        }
        int size = this.padGrid.getRows() * this.padGrid.getCols();
        int startNote = this.padGrid.getStartNote();
        for (int i = 0; i < size; ++i) {
            int note = startNote + i;
            ButtonID buttonID = ButtonID.get(ButtonID.PAD1, i);
            IHwButton pad = this.createButton(buttonID, "P " + (i + 1));
            pad.addLight(this.surfaceFactory.createLight(this.surfaceID, null, () -> this.padGrid.getLightInfo(note).getEncoded(), state -> this.padGrid.sendState(note), colorIndex -> this.colorManager.getColor(colorIndex, buttonID), pad));
            int[] translated = this.padGrid.translateToController(note);
            pad.bind(this.input, BindType.NOTE, translated[0], translated[1]);
            pad.bind((event, velocity) -> this.handleGridNote(event, note, velocity));
        }
    }

    @Override
    public void consumePads() {
        int size = this.padGrid.getRows() * this.padGrid.getCols();
        for (int i = 0; i < size; ++i) {
            this.getButton(ButtonID.get(ButtonID.PAD1, i)).setConsumed();
        }
    }

    protected void createLightGuide() {
        if (this.lightGuide == null) {
            return;
        }
        int size = this.lightGuide.getCols();
        for (int i = 0; i < size; ++i) {
            int note = this.lightGuide.getStartNote() + i;
            this.createLight(OutputID.get(OutputID.LIGHT_GUIDE1, i), () -> this.lightGuide.getLightInfo(note).getEncoded(), state -> this.lightGuide.sendState(note), colorIndex -> this.colorManager.getColor(colorIndex, null), null);
        }
    }

    @Override
    public void rebindGrid() {
        int size = this.padGrid.getRows() * this.padGrid.getCols();
        int startNote = this.padGrid.getStartNote();
        for (int i = 0; i < size; ++i) {
            int note = startNote + i;
            IHwButton pad = this.getButton(ButtonID.get(ButtonID.PAD1, i));
            int[] translated = this.padGrid.translateToController(note);
            pad.bind(this.input, BindType.NOTE, translated[0], translated[1]);
        }
    }

    @Override
    public void unbindGrid() {
        int size = this.padGrid.getRows() * this.padGrid.getCols();
        for (int i = 0; i < size; ++i) {
            this.getButton(ButtonID.get(ButtonID.PAD1, i)).unbind();
        }
    }

    @Override
    public int getSurfaceID() {
        return this.surfaceID;
    }

    @Override
    public ViewManager getViewManager() {
        return this.viewManager;
    }

    @Override
    public void recallPreferredView(ITrack track) {
        IView view;
        if (!track.doesExist()) {
            return;
        }
        Views preferredView = this.viewManager.getPreferredView(track.getPosition());
        if (preferredView == null) {
            Views views = preferredView = track.canHoldNotes() ? this.configuration.getStartupView() : this.configuration.getPreferredAudioView();
        }
        if ((view = (IView)this.viewManager.get(preferredView)) == null) {
            return;
        }
        this.viewManager.setActive(preferredView);
        if (this.notifyViewChange) {
            this.getDisplay().notify(view.getName());
        }
    }

    @Override
    public ModeManager getModeManager() {
        return this.modeManager;
    }

    @Override
    public C getConfiguration() {
        return this.configuration;
    }

    @Override
    public IDisplay getDisplay() {
        if (this.graphicsDisplays.isEmpty()) {
            return this.getTextDisplay(0);
        }
        return this.getGraphicsDisplay();
    }

    @Override
    public ITextDisplay getTextDisplay() {
        return this.getTextDisplay(0);
    }

    @Override
    public ITextDisplay getTextDisplay(int index) {
        if (index >= this.textDisplays.size()) {
            return this.dummyDisplay;
        }
        return this.textDisplays.get(index);
    }

    @Override
    public IGraphicDisplay getGraphicsDisplay() {
        return this.getGraphicsDisplay(0);
    }

    @Override
    public IGraphicDisplay getGraphicsDisplay(int index) {
        return this.graphicsDisplays.get(index);
    }

    @Override
    public void addTextDisplay(ITextDisplay display) {
        display.setHardwareDisplay(this.surfaceFactory.createTextDisplay(this.surfaceID, OutputID.get(OutputID.DISPLAY1, this.textDisplays.size()), display.getNumberOfLines()));
        this.textDisplays.add(display);
    }

    @Override
    public void addGraphicsDisplay(IGraphicDisplay display) {
        IBitmap bitmap = display.getImage();
        display.setHardwareDisplay(this.surfaceFactory.createGraphicsDisplay(this.surfaceID, OutputID.DISPLAY1, bitmap));
        this.graphicsDisplays.add(display);
    }

    @Override
    public void addPianoKeyboard(int numKeys, IMidiInput keyboardInput, boolean addWheels) {
        this.pianoKeyboard = this.surfaceFactory.createPianoKeyboard(this.surfaceID, numKeys);
        this.pianoKeyboard.bind(keyboardInput);
        if (!addWheels) {
            return;
        }
        IHwFader modulationWheel = this.createFader(ContinuousID.MODULATION_WHEEL, "Modulation", true);
        modulationWheel.bind(keyboardInput, BindType.CC, 1);
        IHwFader pitchbendWheel = this.createFader(ContinuousID.PITCHBEND_WHEEL, "Pitchbend", true);
        pitchbendWheel.bind(keyboardInput, BindType.PITCHBEND, 0);
    }

    @Override
    public IHwPianoKeyboard getPianoKeyboard() {
        return this.pianoKeyboard;
    }

    @Override
    public IPadGrid getPadGrid() {
        return this.padGrid;
    }

    @Override
    public ILightGuide getLightGuide() {
        return this.lightGuide;
    }

    @Override
    public IMidiOutput getMidiOutput() {
        return this.output;
    }

    @Override
    public IMidiInput getMidiInput() {
        return this.input;
    }

    @Override
    public void setKeyTranslationTable(int[] table) {
        this.keyTranslationTable = table;
        if (this.input == null) {
            return;
        }
        Integer[] t = new Integer[table.length];
        for (int i = 0; i < table.length; ++i) {
            t[i] = table[i];
        }
        INoteInput defaultNoteInput = this.input.getDefaultNoteInput();
        if (defaultNoteInput != null) {
            defaultNoteInput.setKeyTranslationTable(t);
        }
    }

    @Override
    public int[] getKeyTranslationTable() {
        return this.keyTranslationTable;
    }

    @Override
    public void setVelocityTranslationTable(int[] table) {
        if (this.input == null) {
            return;
        }
        Integer[] t = new Integer[table.length];
        for (int i = 0; i < table.length; ++i) {
            t[i] = table[i];
        }
        INoteInput defaultNoteInput = this.input.getDefaultNoteInput();
        if (defaultNoteInput != null) {
            defaultNoteInput.setVelocityTranslationTable(t);
        }
    }

    @Override
    public Map<ButtonID, IHwButton> getButtons() {
        return new EnumMap<ButtonID, IHwButton>(this.buttons);
    }

    @Override
    public IHwButton getButton(ButtonID buttonID) {
        return this.buttons.get((Object)buttonID);
    }

    @Override
    public IHwContinuousControl getContinuous(ContinuousID continuousID) {
        return this.continuous.get((Object)continuousID);
    }

    @Override
    public List<IHwRelativeKnob> getRelativeKnobs() {
        ArrayList<IHwRelativeKnob> relativeKnobs = new ArrayList<IHwRelativeKnob>();
        this.continuous.forEach((id, control) -> {
            if (control instanceof IHwRelativeKnob) {
                IHwRelativeKnob knob = (IHwRelativeKnob)control;
                relativeKnobs.add(knob);
            }
        });
        return relativeKnobs;
    }

    @Override
    public IHwLight getLight(OutputID outputID) {
        return this.lights.get((Object)outputID);
    }

    @Override
    public Collection<IHwLight> getLights() {
        return this.lights.values();
    }

    @Override
    public void unbindAllInputControls() {
        for (IHwContinuousControl control : this.continuous.values()) {
            control.unbind();
        }
        for (IHwButton button : this.buttons.values()) {
            button.unbind();
        }
    }

    @Override
    public void rebindAllInputControls() {
        for (IHwContinuousControl control : this.continuous.values()) {
            control.rebind();
        }
        for (IHwButton button : this.buttons.values()) {
            button.rebind();
        }
    }

    @Override
    public boolean isShiftPressed() {
        return this.isPressed(ButtonID.SHIFT);
    }

    @Override
    public boolean isSelectPressed() {
        return this.isPressed(ButtonID.SELECT);
    }

    @Override
    public boolean isDeletePressed() {
        return this.isPressed(ButtonID.DELETE);
    }

    @Override
    public boolean isSoloPressed() {
        return this.isPressed(ButtonID.SOLO);
    }

    @Override
    public boolean isMutePressed() {
        return this.isPressed(ButtonID.MUTE);
    }

    @Override
    public boolean isPressed(ButtonID buttonID) {
        IHwButton button = this.buttons.get((Object)buttonID);
        return button != null && button.isPressed();
    }

    @Override
    public boolean isLongPressed(ButtonID buttonID) {
        IHwButton button = this.buttons.get((Object)buttonID);
        return button != null && button.isLongPressed();
    }

    @Override
    public IHwButton createButton(ButtonID buttonID, String label) {
        IHwButton button = this.surfaceFactory.createButton(this.surfaceID, buttonID, label);
        this.buttons.put(buttonID, button);
        return button;
    }

    @Override
    public IHwLight createLight(OutputID outputID, Supplier<ColorEx> supplier, Consumer<ColorEx> sendConsumer) {
        IHwLight light = this.surfaceFactory.createLight(this.surfaceID, outputID, supplier, sendConsumer);
        if (outputID != null) {
            this.lights.put(outputID, light);
        }
        return light;
    }

    @Override
    public IHwLight createLight(OutputID outputID, IntSupplier supplier, IntConsumer sendConsumer, IntFunction<ColorEx> stateToColorFunction, IHwButton button) {
        IHwLight light = this.surfaceFactory.createLight(this.surfaceID, outputID, supplier, sendConsumer, stateToColorFunction, button);
        if (outputID != null) {
            this.lights.put(outputID, light);
        }
        return light;
    }

    @Override
    public IHwFader createFader(ContinuousID faderID, String label, boolean isVertical) {
        IHwFader fader = this.surfaceFactory.createFader(this.surfaceID, faderID, label, isVertical);
        this.continuous.put(faderID, fader);
        return fader;
    }

    @Override
    public IHwAbsoluteKnob createAbsoluteKnob(ContinuousID knobID, String label) {
        IHwAbsoluteKnob knob = this.surfaceFactory.createAbsoluteKnob(this.surfaceID, knobID, label);
        this.continuous.put(knobID, knob);
        return knob;
    }

    @Override
    public IHwRelativeKnob createRelativeKnob(ContinuousID knobID, String label) {
        IHwRelativeKnob knob = this.surfaceFactory.createRelativeKnob(this.surfaceID, knobID, label);
        this.continuous.put(knobID, knob);
        return knob;
    }

    @Override
    public IHwRelativeKnob createRelativeKnob(ContinuousID knobID, String label, RelativeEncoding encoding) {
        IHwRelativeKnob knob = this.surfaceFactory.createRelativeKnob(this.surfaceID, knobID, label, encoding);
        this.continuous.put(knobID, knob);
        return knob;
    }

    @Override
    public void setTrigger(int cc, int state) {
        this.setTrigger(this.defaultMidiChannel, cc, state);
    }

    @Override
    public void setTrigger(int channel, int cc, int state) {
        this.setTrigger(null, channel, cc, state);
    }

    @Override
    public void setTrigger(BindType bindType, int channel, int cc, int value) {
        if (this.output == null) {
            return;
        }
        if (bindType == BindType.NOTE) {
            this.output.sendNoteEx(channel, cc, value);
        } else {
            this.output.sendCCEx(channel, cc, value);
        }
    }

    @Override
    public void setTriggerConsumed(ButtonID buttonID) {
        IHwButton button = this.buttons.get((Object)buttonID);
        if (button != null) {
            button.setConsumed();
        }
    }

    @Override
    public boolean isTriggerConsumed(ButtonID buttonID) {
        IHwButton button = this.buttons.get((Object)buttonID);
        return button != null && button.isConsumed();
    }

    @Override
    public void turnOffTriggers() {
        this.buttons.values().forEach(button -> {
            IHwLight light = button.getLight();
            if (light != null) {
                light.turnOff();
            }
        });
        this.continuous.forEach((id, control) -> control.turnOff());
        this.surfaceFactory.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.updateCounterLock;
        synchronized (object) {
            ++this.updateCounter;
            this.scheduleTask(this::flushHandler, 1L);
        }
    }

    @Override
    public void forceFlush() {
        this.textDisplays.forEach(ITextDisplay::forceFlush);
        this.flushButtonLEDs();
        this.continuous.forEach((id, control) -> control.forceFlush());
        this.lights.forEach((outputID, light) -> light.forceFlush());
        if (this.lightGuide != null) {
            this.lightGuide.forceFlush();
        }
    }

    @Override
    public void flushButtonLEDs() {
        this.buttons.forEach((id, button) -> {
            IHwLight light = button.getLight();
            if (light != null) {
                light.forceFlush();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushHandler() {
        Object object = this.updateCounterLock;
        synchronized (object) {
            if (this.updateCounter == 0) {
                return;
            }
        }
        try {
            this.internalFlushHandler();
        }
        catch (RuntimeException ex) {
            this.host.error("Crash during flush.", ex);
        }
        object = this.updateCounterLock;
        synchronized (object) {
            if (this.updateCounter > 1) {
                this.updateCounter = 1;
                this.scheduleTask(this::flushHandler, 1L);
            } else {
                this.updateCounter = 0;
            }
        }
    }

    protected void internalFlushHandler() {
        this.updateViewControls();
        this.updateGrid();
        this.flushHardware();
    }

    @Override
    public void clearCache() {
        this.surfaceFactory.clearCache();
    }

    @Override
    public final synchronized void shutdown() {
        this.isShuttingDown = true;
        this.internalShutdown();
        this.flushHardware();
    }

    protected void internalShutdown() {
        this.turnOffTriggers();
        if (this.padGrid != null) {
            this.padGrid.turnOff();
        }
        this.textDisplays.forEach(IDisplay::shutdown);
        this.graphicsDisplays.forEach(IDisplay::shutdown);
    }

    protected void handleMidi(int status, int data1, int data2) {
        int code = status & 0xF0;
        int channel = status & 0xF;
        switch (code) {
            case 128: {
                this.handleNoteOff(data1, data2);
                break;
            }
            case 144: {
                this.handleNoteOn(data1, data2);
                break;
            }
            case 160: {
                this.handlePolyAftertouch(data1, data2);
                break;
            }
            case 176: {
                this.handleCC(data1, data2);
                break;
            }
            case 192: {
                this.handleProgramChange(channel, data1, data2);
                break;
            }
            case 208: {
                this.handleChannelAftertouch(data1);
                break;
            }
            case 224: {
                this.handlePitchbend(data1, data2);
                break;
            }
            default: {
                this.host.error("Unhandled MIDI status: " + status);
            }
        }
    }

    protected void handleCC(int data1, int data2) {
        this.host.error("CC " + data1 + SHOULD_BE_HANDLED_IN_FRAMEWORK);
    }

    protected void handlePitchbend(int data1, int data2) {
        this.host.error("Pitchbend should be handled in framework...");
    }

    protected void handleNoteOff(int data1, int data2) {
    }

    protected void handleNoteOn(int data1, int data2) {
    }

    protected void handleChannelAftertouch(int data1) {
        IView view = (IView)this.viewManager.getActive();
        if (view != null) {
            view.executeAftertouchCommand(-1, data1);
        }
    }

    protected void handlePolyAftertouch(int data1, int data2) {
        IView view = (IView)this.viewManager.getActive();
        if (view != null) {
            view.executeAftertouchCommand(data1, data2);
        }
    }

    protected void handleProgramChange(int channel, int data1, int data2) {
    }

    @Override
    public void scheduleTask(Runnable callback, long delay) {
        this.host.scheduleTask(() -> {
            try {
                callback.run();
            }
            catch (RuntimeException ex) {
                this.host.error("Could not execute scheduled task.", ex);
            }
        }, delay);
    }

    @Override
    public void println(String message) {
        this.host.println(message);
    }

    @Override
    public void errorln(String message) {
        this.host.error(message);
    }

    @Override
    public void sendMidiEvent(int status, int data1, int data2) {
        this.input.sendRawMidiEvent(status, data1, data2);
    }

    @Override
    public IHwSurfaceFactory getSurfaceFactory() {
        return this.surfaceFactory;
    }

    public IHost getHost() {
        return this.host;
    }

    @Override
    public boolean isKnobSensitivitySlow() {
        return this.knobSensitivityIsSlow;
    }

    @Override
    public void setKnobSensitivityIsSlow(boolean knobSensitivityIsSlow) {
        this.knobSensitivityIsSlow = knobSensitivityIsSlow;
        this.knobSensitivityObservers.forEach(ISensitivityCallback::knobSensitivityHasChanged);
    }

    @Override
    public void addKnobSensitivityObserver(ISensitivityCallback observer) {
        this.knobSensitivityObservers.add(observer);
    }

    protected void handleGridNote(ButtonEvent event, int note, int velocity) {
        IView view = (IView)this.viewManager.getActive();
        if (view == null) {
            return;
        }
        if (event == ButtonEvent.LONG) {
            view.onGridNoteLongPress(note);
        } else {
            view.onGridNote(note, velocity);
        }
    }

    protected void updateViewControls() {
        IView view = (IView)this.viewManager.getActive();
        if (view != null) {
            view.updateControlSurface();
        }
    }

    protected void updateGrid() {
        IView view = (IView)this.viewManager.getActive();
        if (view != null) {
            view.drawGrid();
        }
    }

    protected void flushHardware() {
        this.textDisplays.forEach(ITextDisplay::flush);
        this.surfaceFactory.flush();
        this.continuous.values().forEach(IHwControl::update);
    }
}

