/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.mode;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ModeMultiSelectCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private final ModeManager modeManager;
    private final List<Modes> modeIds = new ArrayList<Modes>();
    private Modes currentModeID;
    private final int numModeIds;

    public ModeMultiSelectCommand(IModel model, S surface, Modes ... modeIds) {
        super(model, surface);
        this.modeManager = this.surface.getModeManager();
        this.modeIds.addAll(Arrays.asList(modeIds));
        this.currentModeID = this.modeIds.get(0);
        this.numModeIds = this.modeIds.size();
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        this.switchMode(true, event);
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        this.switchMode(false, event);
    }

    protected void switchMode(boolean selectNext, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        Modes activeModeId = (Modes)((Object)this.modeManager.getActiveID());
        Modes newMode = this.currentModeID;
        if (this.currentModeID.equals((Object)activeModeId)) {
            int index;
            int startIndex = index = this.modeIds.indexOf((Object)activeModeId);
            while (this.sendDoesNotExist(newMode = this.modeIds.get(index = this.changeIndex(selectNext, index))) && index != startIndex) {
            }
        }
        this.activateMode(newMode);
    }

    private boolean sendDoesNotExist(Modes mode) {
        if (Modes.isSendMode(mode)) {
            return !this.model.getTrackBank().canEditSend(mode.ordinal() - Modes.SEND1.ordinal());
        }
        if (Modes.isLayerSendMode(mode)) {
            return !this.model.getTrackBank().canEditSend(mode.ordinal() - Modes.DEVICE_LAYER_SEND1.ordinal());
        }
        return false;
    }

    private int changeIndex(boolean selectNext, int index) {
        if (selectNext) {
            int next = index + 1;
            return next < 0 || next >= this.numModeIds ? 0 : next;
        }
        int prev = index - 1;
        return prev < 0 || prev >= this.numModeIds ? this.numModeIds - 1 : prev;
    }

    public void activateMode(Modes modeID) {
        this.currentModeID = modeID;
        this.modeManager.setActive(modeID);
        if (!this.shouldNotify()) {
            return;
        }
        if (Modes.isSendMode(modeID)) {
            int sendIndex = modeID.ordinal() - Modes.SEND1.ordinal();
            this.mvHelper.notifySelectedSend(sendIndex);
        } else {
            this.surface.getDisplay().notify(((IMode)this.modeManager.get(modeID)).getName());
        }
    }

    protected boolean shouldNotify() {
        return true;
    }
}

